package com.taboola.android.api;

import android.support.annotation.Keep;

@Keep
public interface TaboolaOnClickListener {
    /**
     * Sdk allows to intercept recommendation clicks, and block default click handling for organic items.
     * If you want to block the default behavior, and display the recommendation content on your own,
     * return {@code false} in {@link TaboolaOnClickListener#onItemClick(String, String, String, boolean)}
     * <p> Note: The return value will be ignored for non-organic items (!).
     * <p>The method will be called every time a user clicks a recommendation, right before triggering the default behavior
     *
     * @param placementName The placement associated with the item the user clicked on.
     * @param itemId The item id of the item the user clicked on.
     * @param clickUrl The click url of the item the user clicked on.
     * @param isOrganic True if the item clicked on is organic, false otherwise.
     *
     * @return This is a logic switch controlled by you! Return false to block default SDK behavior, and display the recommendation content on your own, true otherwise.
     */
    boolean onItemClick(String placementName, String itemId, String clickUrl, boolean isOrganic);
}