package com.taboola.android.api;

import android.support.annotation.Keep;

/**
 * This callback returns feedback for requesting recommendation items.
 * Usually either success or failure.
 */
@Keep
public interface TBRecommendationRequestCallback{
    /**
     * Recommendations successfully fetched.
     * @param response A {@link TBRecommendationsResponse} containing the fetched recommendations.
     */
    void onRecommendationsFetched(TBRecommendationsResponse response);

    /**
     * Recommendations fetching failed.
     * @param t The Throwable associated with the failure.
     */
    void onRecommendationsFailed(Throwable t);
}