/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.plus.shared;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.RequiresApi;
import android.util.Log;
import com.taboola.android.plus.common.ISdkPlusCore;
import com.taboola.android.plus.core.AbsWidgetManager;
import com.taboola.android.plus.core.BridgeInternalCore;
import com.taboola.android.plus.core.WidgetManagerCallback;
import com.taboola.android.utils.Logger;

@RequiresApi(api=21)
public class TBLWidgetManager {
    public static final String WIDGET_ITEM_CLICK_ACTION = "com.taboola.android.plus.home.screen.widget.ITEM_CLICK_ACTION";
    private static final String TAG = TBLWidgetManager.class.getSimpleName();

    public static void handleWidgetItemClick(@NonNull Intent intent, @NonNull Context activityContext) {
        Bundle extras = intent.getExtras();
        if (intent.getAction() != null && WIDGET_ITEM_CLICK_ACTION.equals(intent.getAction()) && extras != null) {
            Log.d((String)TAG, (String)("handleClick() called with: intent = [" + intent + "], activityContext = [" + activityContext + "]"));
            if (ISdkPlusCore.isDebug()) {
                for (String key : extras.keySet()) {
                    Logger.i((String)TAG, (String)(key + " : " + (extras.get(key) != null ? extras.get(key) : "NULL")));
                }
            }
            TBLWidgetManager.handleClick(extras, activityContext);
        }
    }

    private static void handleClick(final @NonNull Bundle extras, final @NonNull Context activityContext) {
        BridgeInternalCore.getWidgetManagerAsync(new WidgetManagerCallback(){

            @Override
            public void onManagerRetrieved(AbsWidgetManager manager) {
                if (manager != null) {
                    manager.handleClick(extras, activityContext);
                } else {
                    Logger.e((String)TAG, (String)"handle click: failed to handle item click getWidgetManagerAsync failed ");
                }
            }

            @Override
            public void onManagerFailed(Throwable t) {
                Logger.e((String)TAG, (String)("handle click: failed to handle item click getWidgetManagerAsync failed " + t.getMessage()));
            }
        });
    }
}

