/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.plus.shared;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.support.annotation.RequiresApi;
import android.text.TextUtils;
import android.util.Log;
import com.taboola.android.plus.common.ISdkPlusCore;
import com.taboola.android.plus.core.AbsScheduledManager;
import com.taboola.android.plus.core.AbsWidgetManager;
import com.taboola.android.plus.core.BridgeInternalCore;
import com.taboola.android.plus.core.InternalSdkPlusCoreInitCallback;
import com.taboola.android.plus.core.PlusFeature;
import com.taboola.android.plus.core.ScheduledManagerCallback;
import com.taboola.android.plus.core.WidgetManagerCallback;
import com.taboola.android.utils.Logger;

@RequiresApi(api=21)
public class OnApplicationUpdatedReceiver
extends BroadcastReceiver {
    private static final String TAG = OnApplicationUpdatedReceiver.class.getSimpleName();

    public void onReceive(Context context, Intent intent) {
        if (intent == null || !TextUtils.equals((CharSequence)"android.intent.action.MY_PACKAGE_REPLACED", (CharSequence)intent.getAction())) {
            Logger.e((String)TAG, (String)"can't handle intent");
            return;
        }
        Log.i((String)TAG, (String)"onReceive: application was just updated");
        BridgeInternalCore.getSdkPlusCoreAsync(new InternalSdkPlusCoreInitCallback(){

            @Override
            public void onSdkPlusCoreInitSuccessful(ISdkPlusCore sdkPlusCore) {
                Log.d((String)TAG, (String)"onSdkPlusCoreInitSuccessful() called");
                sdkPlusCore.rescheduleConfigJobIfNeeded();
            }

            @Override
            public void onSdkPlusCoreInitFailed(Throwable throwable) {
                Log.e((String)TAG, (String)"onSdkPlusCoreInitFailed: ", (Throwable)throwable);
            }
        });
        if (BridgeInternalCore.isFeatureActivated(PlusFeature.SCHEDULED_NOTIFICATIONS)) {
            BridgeInternalCore.getScheduledNotificationManagerAsync(new ScheduledManagerCallback(){

                @Override
                public void onManagerRetrieved(AbsScheduledManager iScheduledNotificationManager) {
                    iScheduledNotificationManager.rescheduleJobIfNeeded();
                }

                @Override
                public void onManagerRetrieveFailed(Throwable throwable) {
                    Log.e((String)TAG, (String)"onManagerRetrieveFailed: failed to restore notification refresh job: failed to get notification manager ", (Throwable)throwable);
                }
            });
        } else {
            Log.d((String)TAG, (String)"onReceive: scheduled notifications are not activated during sdk init. No need to restore scheduled notifications job");
        }
        if (BridgeInternalCore.isFeatureActivated(PlusFeature.APP_WIDGET)) {
            BridgeInternalCore.getWidgetManagerAsync(new WidgetManagerCallback(){

                @Override
                public void onManagerRetrieved(AbsWidgetManager manager) {
                    manager.rescheduleJobIfNeeded();
                }

                @Override
                public void onManagerFailed(Throwable t) {
                    Log.e((String)TAG, (String)"onManagerFailed: failed to restore widget refresh job: failed to get widget manager ", (Throwable)t);
                }
            });
        } else {
            Log.d((String)TAG, (String)"onReceive: home screen widget is not activated during sdk init. No need to restore job");
        }
    }
}

