/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.plus.notifications.scheduled;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import android.support.annotation.Size;
import android.text.format.DateUtils;
import android.util.Log;
import com.taboola.android.api.TBPlacement;
import com.taboola.android.api.TBRecommendationItem;
import com.taboola.android.plus.notifications.scheduled.EngagementGroupsHelper;
import com.taboola.android.plus.notifications.scheduled.NotificationBackgroundJobsManager;
import com.taboola.android.plus.notifications.scheduled.NotificationContent;
import com.taboola.android.plus.notifications.scheduled.NotificationContentState;
import com.taboola.android.plus.notifications.scheduled.NotificationRefreshCallback;
import com.taboola.android.plus.notifications.scheduled.ScheduledNotificationsConfig;
import com.taboola.android.plus.notifications.scheduled.ScheduledNotificationsLocalStorage;
import com.taboola.android.plus.notifications.scheduled.ScheduledNotificationsRenderer;
import com.taboola.android.plus.notifications.scheduled.TBContent;
import com.taboola.android.plus.notifications.scheduled.TBScheduledNotificationAnalyticsManager;
import com.taboola.android.plus.notifications.scheduled.content.NotificationContentRepository;
import com.taboola.android.plus.notifications.scheduled.layout_model.MultipleNotificationsLayoutModel;
import com.taboola.android.plus.notifications.scheduled.layout_model.ReadMoreLayoutModel;
import com.taboola.android.plus.notifications.scheduled.layout_model.ScheduledNotificationsLayoutModel;
import com.taboola.android.plus.notifications.scheduled.layout_model.SingleNotificationLayoutModel;
import com.taboola.android.plus.notifications.scheduled.util.ScheduledNotificationUtil;
import com.taboola.android.utils.Logger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Random;

@RequiresApi(api=21)
public class ScheduledNotificationController {
    private static final String TAG = ScheduledNotificationController.class.getSimpleName();
    private final NotificationContentRepository contentRepository;
    private final ScheduledNotificationsRenderer renderer;
    private final TBScheduledNotificationAnalyticsManager analyticsManager;
    private final NotificationBackgroundJobsManager backgroundManager;
    private final ScheduledNotificationsLocalStorage scheduledLocalStorage;
    private final EngagementGroupsHelper engagementGroupsHelper;
    private final ScheduledNotificationUtil scheduledNotificationUtil;
    private final ScheduledNotificationsConfig notificationConfig;
    private final HashMap<TBPlacement, Boolean> viewedItemsMap = new HashMap();

    ScheduledNotificationController(@NonNull NotificationContentRepository contentRepository, @NonNull ScheduledNotificationsRenderer renderer, @NonNull TBScheduledNotificationAnalyticsManager analyticsManager, @NonNull NotificationBackgroundJobsManager backgroundManager, @NonNull ScheduledNotificationsLocalStorage scheduledLocalStorage, @NonNull EngagementGroupsHelper engagementGroupsHelper, @NonNull ScheduledNotificationUtil scheduledNotificationUtil, @NonNull ScheduledNotificationsConfig notificationConfig) {
        this.contentRepository = contentRepository;
        this.renderer = renderer;
        this.analyticsManager = analyticsManager;
        this.backgroundManager = backgroundManager;
        this.scheduledLocalStorage = scheduledLocalStorage;
        this.engagementGroupsHelper = engagementGroupsHelper;
        this.scheduledNotificationUtil = scheduledNotificationUtil;
        this.notificationConfig = notificationConfig;
    }

    void refreshNotification(@NonNull @Size(min=1L) List<String> categories, final @NonNull NotificationRefreshCallback callback) {
        this.contentRepository.loadNewContent(this.notificationConfig, categories, new NotificationContentRepository.NotificationContentRefreshCallback(){

            @Override
            public void onContentRefreshSuccessful(@NonNull TBContent validPlacements) {
                if (validPlacements.isEmpty()) {
                    Log.d((String)TAG, (String)"onNotificationContentFetched(): notification content is empty");
                    callback.onNotificationRefreshSuccessful();
                } else {
                    try {
                        ScheduledNotificationsLayoutModel scheduledNotificationsLayoutModel = ScheduledNotificationsLayoutModel.determineNotificationModel(ScheduledNotificationController.this.notificationConfig.getScheduledNotificationsLayout());
                        ScheduledNotificationController.this.renderNewNotification(validPlacements, 0, scheduledNotificationsLayoutModel);
                        callback.onNotificationRefreshSuccessful();
                    }
                    catch (Exception e) {
                        callback.onNotificationRefreshFailed(new Throwable(e));
                    }
                }
            }

            @Override
            public void onContentRefreshFailed(@NonNull Throwable t) {
                callback.onNotificationRefreshFailed(t);
            }
        });
    }

    private void renderNewNotification(@NonNull @Size(min=1L) TBContent tbContent, int firstPlacementIndex, @NonNull ScheduledNotificationsLayoutModel scheduledNotificationsLayoutModel) {
        int availableItemsCount = tbContent.getPlacements().size();
        this.viewedItemsMap.clear();
        for (TBPlacement item : tbContent.getPlacements()) {
            this.viewedItemsMap.put(item, false);
        }
        switch (scheduledNotificationsLayoutModel.getPreferredLayoutType()) {
            case SingleContentNotificationLayout: {
                this.renderSingleNotification(tbContent, firstPlacementIndex, availableItemsCount);
                break;
            }
            case MultipleContentNotificationLayout: {
                this.renderMultipleNotification(tbContent, firstPlacementIndex, availableItemsCount);
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown layout type");
            }
        }
    }

    private void renderMultipleNotification(@Size(min=1L) @NonNull TBContent tbContent, int firstPlacementIndex, int availableItemsCount) {
        MultipleNotificationsLayoutModel multipleModel = MultipleNotificationsLayoutModel.determineNotificationsLayout(this.notificationConfig.getScheduledNotificationsLayout().getContentNotificationLayout().getMultipleItemNotificationsLayout(), availableItemsCount);
        int itemCountToDisplay = this.getMaxNumberOfItems(multipleModel.getMultipleCollapsedLayout().getMaxNumberOfItems(), multipleModel.getMultipleExpandedLayout().getMaxNumberOfItems());
        if (multipleModel.isEnoughItems(availableItemsCount)) {
            NotificationContentState notificationContentState = new NotificationContentState(firstPlacementIndex, itemCountToDisplay);
            NotificationContent notificationContent = this.determineNotificationContent(tbContent, notificationContentState, true);
            this.contentRepository.setNotificationState(notificationContentState);
            this.renderNotification(notificationContent, multipleModel, true);
        } else {
            this.renderSingleNotification(tbContent, firstPlacementIndex, availableItemsCount);
        }
    }

    private void renderSingleNotification(@Size(min=1L) @NonNull TBContent tbContent, int firstPlacementIndex, int availableItemsCount) {
        int itemCountToDisplay = 1;
        SingleNotificationLayoutModel singleModel = SingleNotificationLayoutModel.determineNotificationLayout(this.notificationConfig.getScheduledNotificationsLayout().getContentNotificationLayout().getSingleItemNotificationsLayout(), availableItemsCount);
        this.renderer.prefetchThumbnails(tbContent, singleModel);
        NotificationContentState notificationContentState = new NotificationContentState(firstPlacementIndex, itemCountToDisplay);
        NotificationContent notificationContent = this.determineNotificationContent(tbContent, notificationContentState, false);
        this.contentRepository.setNotificationState(notificationContentState);
        this.renderNotification(notificationContent, singleModel, true);
    }

    private NotificationContent determineNotificationContent(@NonNull @Size(min=1L) TBContent tbContent, @NonNull NotificationContentState notificationContentState, boolean isMultipleLayoutType) {
        ArrayList<TBPlacement> placements = tbContent.getPlacements();
        int firstPlacementIndex = notificationContentState.getFirstPlacementIndex();
        int itemCountToDisplay = notificationContentState.getItemCountToDisplay();
        int placementSize = placements.size();
        int fromIndex = Math.min(firstPlacementIndex, placementSize - 1);
        int toIndex = Math.min(firstPlacementIndex + itemCountToDisplay, placementSize);
        ArrayList<TBPlacement> currentNotificationPlacements = new ArrayList<TBPlacement>(placements.subList(fromIndex, toIndex));
        NotificationContent notificationContent = new NotificationContent(currentNotificationPlacements);
        String notificationAppNameLabel = this.scheduledNotificationUtil.getNotificationAppNameLabel(this.notificationConfig.getScheduledNotificationsLayout());
        int notificationAppIconId = this.scheduledNotificationUtil.getNotificationAppIconId();
        notificationContent.setNotificationAppNameLabel(notificationAppNameLabel);
        notificationContent.setIsHotItem(tbContent.getItems().get(fromIndex).isHotItem());
        notificationContent.setApplicationIconId(notificationAppIconId);
        if (isMultipleLayoutType) {
            notificationContent.setHasMultiplePages(false);
        } else {
            notificationContent.setHasMultiplePages(itemCountToDisplay * 2 <= tbContent.getContentSize());
        }
        return notificationContent;
    }

    private NotificationContent determineReadMoreNotificationContent(@NonNull @Size(min=1L) TBContent tbContent) {
        ArrayList<TBPlacement> currentNotificationPlacements = new ArrayList<TBPlacement>();
        if (tbContent.getReadMoreNotificationItem() != null) {
            currentNotificationPlacements.add(tbContent.getReadMoreNotificationItem().getThumbnailPlacement());
        } else {
            currentNotificationPlacements.add(null);
        }
        currentNotificationPlacements.add(tbContent.getReadMoreNotificationItem().getContentPlacement());
        NotificationContent notificationContent = new NotificationContent(currentNotificationPlacements);
        notificationContent.setHasMultiplePages(true);
        String notificationAppNameLabel = this.scheduledNotificationUtil.getNotificationAppNameLabel(this.notificationConfig.getScheduledNotificationsLayout());
        int notificationAppIconId = this.scheduledNotificationUtil.getNotificationAppIconId();
        notificationContent.setNotificationAppNameLabel(notificationAppNameLabel);
        notificationContent.setApplicationIconId(notificationAppIconId);
        return notificationContent;
    }

    private void renderNotification(@NonNull NotificationContent notificationContent, @NonNull SingleNotificationLayoutModel singleNotificationLayoutModel, boolean isNewNotification) {
        if (notificationContent.getPlacements() != null && !notificationContent.getPlacements().isEmpty()) {
            TBPlacement placement = notificationContent.getPlacements().get(0);
            if (placement != null && !placement.getItems().isEmpty()) {
                TBRecommendationItem item = (TBRecommendationItem)placement.getItems().get(0);
                this.backgroundManager.cancelAutoSwitchTimer();
                ScheduledNotificationsRenderer.RenderResult renderResult = ScheduledNotificationUtil.isSponsoredItem(item) ? this.renderer.renderNotification(notificationContent, singleNotificationLayoutModel.getSponsoredNotificationLayoutModel()) : this.renderer.renderNotification(notificationContent, singleNotificationLayoutModel.getTrendingNotificationLayoutModel());
                if (renderResult.isSuccessful()) {
                    this.onContentRenderSuccess(notificationContent, isNewNotification);
                } else {
                    Log.e((String)TAG, (String)("Failed to renderContent with error: " + renderResult.getErrorMessage()));
                    this.analyticsManager.sendFailedToRenderEvent(renderResult.getErrorMessage());
                }
            } else {
                Log.e((String)TAG, (String)"renderNotification: Failded to renderContent placement is invalid");
            }
        } else {
            Log.e((String)TAG, (String)"renderNotification: Failed to renderContent cannot get placements from notification content");
        }
    }

    private void renderNotification(@NonNull NotificationContent notificationContent, @NonNull MultipleNotificationsLayoutModel multipleNotificationsLayoutModel, boolean isNewNotification) {
        this.backgroundManager.cancelAutoSwitchTimer();
        ScheduledNotificationsRenderer.RenderResult renderResult = this.renderer.renderMultipleNotification(notificationContent, multipleNotificationsLayoutModel);
        if (renderResult.isSuccessful()) {
            this.onContentRenderSuccess(notificationContent, isNewNotification);
        } else {
            Log.e((String)TAG, (String)("Failed to renderContent with error: " + renderResult.getErrorMessage()));
            this.analyticsManager.sendFailedToRenderEvent(renderResult.getErrorMessage());
        }
    }

    void renderPrevPage() {
        this.contentRepository.fetchCurrentData(new NotificationContentRepository.FetchCurrentDataCallback(){

            @Override
            public void onFetched(@Nullable TBContent content, @Nullable NotificationContentState contentState) {
                if (content != null && !content.isEmpty() && contentState != null) {
                    if (ScheduledNotificationController.this.shouldShowReadMore() && content.getReadMoreNotificationItem() != null) {
                        ScheduledNotificationController.this.renderReadMoreNotificationPage(content, contentState, false);
                    } else {
                        try {
                            ScheduledNotificationController.this.renderPrevNotificationPage(content, contentState);
                        }
                        catch (Exception e) {
                            Logger.e((String)TAG, (String)("it's impossible to render prev notification page because of " + e));
                        }
                    }
                } else {
                    Log.w((String)TAG, (String)"renderPrevPage: trying to render prev page while content or contentState is null");
                }
            }
        });
    }

    void renderNextPage(final boolean isScrollTriggeredByUser) {
        this.contentRepository.fetchCurrentData(new NotificationContentRepository.FetchCurrentDataCallback(){

            @Override
            public void onFetched(@Nullable TBContent content, @Nullable NotificationContentState contentState) {
                if (content != null && !content.isEmpty() && contentState != null) {
                    if (isScrollTriggeredByUser && ScheduledNotificationController.this.shouldShowReadMore() && content.getReadMoreNotificationItem() != null) {
                        ScheduledNotificationController.this.renderReadMoreNotificationPage(content, contentState, true);
                    } else {
                        try {
                            ScheduledNotificationController.this.renderNextNotificationPage(content, contentState, isScrollTriggeredByUser);
                        }
                        catch (Exception e) {
                            Logger.e((String)TAG, (String)("it's impossible to render next notification page because of " + e));
                        }
                    }
                } else {
                    Log.w((String)TAG, (String)"renderNextPage: trying to render next page while content or contentState is null");
                }
            }
        });
    }

    private void renderPrevNotificationPage(@NonNull @Size(min=1L) TBContent tbContent, @NonNull NotificationContentState currentNotificationContentState) {
        ScheduledNotificationsConfig.ScheduledNotificationsLayout.SingleItemNotificationsLayout singleItemNotificationsLayout = this.notificationConfig.getScheduledNotificationsLayout().getContentNotificationLayout().getSingleItemNotificationsLayout();
        SingleNotificationLayoutModel singleNotificationLayoutModel = SingleNotificationLayoutModel.determineNotificationLayout(singleItemNotificationsLayout, 1);
        NotificationContentState newNotificationContentState = new NotificationContentState(this.getPrevPlacementIndex(tbContent.getContentSize(), currentNotificationContentState.getFirstPlacementIndex()));
        NotificationContent notificationContent = this.determineNotificationContent(tbContent, newNotificationContentState, false);
        this.viewedItemsMap.put(tbContent.getPlacements().get(this.getPrevPlacementIndex(tbContent.getPlacements().size(), currentNotificationContentState.getFirstPlacementIndex())), true);
        this.viewedItemsMap.put(tbContent.getPlacements().get(this.getProperCurrentPlacementIndex(tbContent.getPlacements().size(), currentNotificationContentState.getFirstPlacementIndex())), true);
        this.scheduledNotificationUtil.reportPlacementVisibility(notificationContent.getPlacements());
        this.contentRepository.setNotificationState(newNotificationContentState);
        this.renderNotification(notificationContent, singleNotificationLayoutModel, false);
    }

    private void renderNextNotificationPage(@NonNull @Size(min=1L) TBContent tbContent, @NonNull NotificationContentState currentNotificationContentState, boolean shouldReportNextPageVisibility) {
        SingleNotificationLayoutModel singleNotificationLayoutModel = SingleNotificationLayoutModel.determineNotificationLayout(this.notificationConfig.getScheduledNotificationsLayout().getContentNotificationLayout().getSingleItemNotificationsLayout(), 1);
        NotificationContentState newNotificationContentState = new NotificationContentState(this.getNextPlacementIndex(tbContent.getContentSize(), currentNotificationContentState.getFirstPlacementIndex()));
        NotificationContent notificationContent = this.determineNotificationContent(tbContent, newNotificationContentState, false);
        if (shouldReportNextPageVisibility) {
            this.viewedItemsMap.put(tbContent.getPlacements().get(this.getProperCurrentPlacementIndex(tbContent.getPlacements().size(), currentNotificationContentState.getFirstPlacementIndex())), true);
            this.viewedItemsMap.put(tbContent.getPlacements().get(this.getNextPlacementIndex(tbContent.getPlacements().size(), currentNotificationContentState.getFirstPlacementIndex())), true);
            this.scheduledNotificationUtil.reportPlacementVisibility(notificationContent.getPlacements());
        }
        this.contentRepository.setNotificationState(newNotificationContentState);
        this.renderNotification(notificationContent, singleNotificationLayoutModel, false);
    }

    private void renderReadMoreNotificationPage(@NonNull @Size(min=1L) TBContent tbContent, @NonNull NotificationContentState currentNotificationContentState, boolean isNext) {
        ReadMoreLayoutModel readMoreLayoutModel = ReadMoreLayoutModel.determineNotificationLayout(this.notificationConfig.getScheduledNotificationsLayout().getReadMoreNotificationsLayoutConfig(), 1, this.notificationConfig.getReadMoreItem().getReadMoreFeatureEnabled());
        this.renderer.prefetchThumbnails(tbContent, readMoreLayoutModel);
        int firstPlacementIndex = currentNotificationContentState.getFirstPlacementIndex();
        int index = isNext ? this.getNextPlacementIndex(tbContent.getContentSize(), firstPlacementIndex) : this.getPrevPlacementIndex(tbContent.getContentSize(), firstPlacementIndex);
        NotificationContentState newNotificationContentState = new NotificationContentState(index);
        NotificationContent notificationContent = this.determineReadMoreNotificationContent(tbContent);
        this.refreshContentList(tbContent);
        this.contentRepository.setNotificationState(newNotificationContentState);
        this.backgroundManager.cancelAutoSwitchTimer();
        ScheduledNotificationsRenderer.RenderResult renderResult = this.renderer.renderReadMoreNotification(notificationContent, readMoreLayoutModel, this.generateReadMoreRandomNumber());
        if (renderResult.isSuccessful()) {
            this.onContentRenderSuccess(notificationContent, false);
        } else {
            Log.e((String)TAG, (String)("Failed to renderContent with error: " + renderResult.getErrorMessage()));
            this.analyticsManager.sendFailedToRenderEvent(renderResult.getErrorMessage());
        }
    }

    void onUserDismissedNotification(@NonNull ArrayList<TBPlacement> placements, String collapsedNotificationLayout, String expandedNotificationLayout, boolean isTrendingItem, String randomThumbnailNumber) {
        this.backgroundManager.cancelAutoSwitchTimer();
        this.analyticsManager.sendDismissedEvent(placements, collapsedNotificationLayout, expandedNotificationLayout, isTrendingItem, randomThumbnailNumber);
    }

    void removePlacement(String imageUri) {
        Log.v((String)TAG, (String)"removePlacement() called");
        this.backgroundManager.cancelAutoSwitchTimer();
        this.contentRepository.deletePlacement(imageUri, this.getOnDeletePlacementCallback());
    }

    void removePlacement(TBPlacement placement) {
        Log.v((String)TAG, (String)"removePlacement() called");
        this.backgroundManager.cancelAutoSwitchTimer();
        this.contentRepository.deletePlacement(placement, this.getOnDeletePlacementCallback());
    }

    @NonNull
    private NotificationContentRepository.OnDeletePlacementCallback getOnDeletePlacementCallback() {
        return new NotificationContentRepository.OnDeletePlacementCallback(){

            @Override
            public void onDeleted(@NonNull TBContent currentContent, @NonNull NotificationContentState contentState) {
                if (currentContent.isEmpty()) {
                    ScheduledNotificationController.this.dismissNotification();
                } else {
                    int firstPlacementIndex;
                    for (firstPlacementIndex = contentState.getFirstPlacementIndex(); firstPlacementIndex >= currentContent.getContentSize(); --firstPlacementIndex) {
                    }
                    try {
                        ScheduledNotificationsLayoutModel scheduledNotificationsLayoutModel = ScheduledNotificationsLayoutModel.determineNotificationModel(ScheduledNotificationController.this.notificationConfig.getScheduledNotificationsLayout());
                        ScheduledNotificationController.this.renderNewNotification(currentContent, firstPlacementIndex, scheduledNotificationsLayoutModel);
                    }
                    catch (Exception e) {
                        Logger.e((String)TAG, (String)("it's impossible to render the notification because of " + e));
                    }
                }
            }
        };
    }

    void refreshContentList(TBContent tbContent) {
        for (TBPlacement item : tbContent.getPlacements()) {
            this.viewedItemsMap.put(item, false);
        }
    }

    private int getProperCurrentPlacementIndex(int availableItemCount, int currentIndex) {
        if (currentIndex >= availableItemCount) {
            return availableItemCount - 1;
        }
        return currentIndex;
    }

    private int getNextPlacementIndex(int availableItemCount, int currentIndex) {
        int newIndex = currentIndex + 1;
        if (newIndex < availableItemCount) {
            return newIndex;
        }
        return 0;
    }

    private int getPrevPlacementIndex(int availableItemCount, int currentIndex) {
        int prevIndex = currentIndex - 1;
        if (prevIndex >= 0) {
            return prevIndex;
        }
        return availableItemCount - 1;
    }

    private String generateReadMoreRandomNumber() {
        Random random = new Random();
        int randomNumber = random.nextInt(5) + 5;
        String randomString = randomNumber == 9 ? randomNumber + "+" : Integer.toString(randomNumber);
        return randomString;
    }

    private void onContentRenderSuccess(@NonNull NotificationContent notificationContent, boolean isNewNotification) {
        if (isNewNotification) {
            this.updateSuccessfulRenderCounter(this.scheduledLocalStorage.getLastShownNotificationTimestamp());
            this.scheduledLocalStorage.setLastShownNotificationTime(System.currentTimeMillis());
        }
        if (notificationContent.hasMultiplePages()) {
            long autoNextIntervalMs = this.engagementGroupsHelper.getCurrentEngagementGroup().getNotificationsConfig().getAutoNextIntervalMs();
            this.backgroundManager.scheduleContentSwitchTimer(autoNextIntervalMs);
        }
        this.analyticsManager.sendRenderEvent(notificationContent.getPlacements(), notificationContent.isHotItem());
    }

    private void updateSuccessfulRenderCounter(long lastShownNotificationTimestamp) {
        if (!DateUtils.isToday((long)lastShownNotificationTimestamp)) {
            this.scheduledLocalStorage.setCountOfRenderedNotificationsToday(0);
        }
        int counter = this.scheduledLocalStorage.getCountOfRenderedNotificationsToday();
        this.scheduledLocalStorage.setCountOfRenderedNotificationsToday(++counter);
    }

    private boolean shouldShowReadMore() {
        boolean areNotificationsRead = Collections.frequency(new ArrayList<Boolean>(this.viewedItemsMap.values()), false) == 0;
        return this.notificationConfig.getReadMoreItem().getReadMoreFeatureEnabled() != false && areNotificationsRead;
    }

    public void dismissNotification() {
        try {
            Log.d((String)TAG, (String)"dismissNotification() called");
            this.backgroundManager.cancelAutoSwitchTimer();
            this.renderer.dismissNotification();
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("dismissNotification: " + e), (Throwable)e);
        }
    }

    private int getMaxNumberOfItems(int collapsedLayoutMaxItemsCount, int expandedLayoutMaxItemsCount) {
        return Math.max(collapsedLayoutMaxItemsCount, expandedLayoutMaxItemsCount);
    }
}

