/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.plus.notifications.push;

import android.content.ActivityNotFoundException;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.os.Parcelable;
import android.support.annotation.RequiresApi;
import android.util.Log;
import android.widget.Toast;
import com.taboola.android.plus.common.ConditionCheckUtil;
import com.taboola.android.plus.notifications.push.IPushNotificationsInternal;
import com.taboola.android.plus.notifications.push.PushBridgeInternal;
import com.taboola.android.plus.notifications.push.TBPushNotificationsAnalyticsManager;
import com.taboola.android.plus.notifications.push.models.BreakingNotificationContent;
import com.taboola.android.utils.Logger;

@RequiresApi(api=21)
public class PushNotificationsStateReceiver
extends BroadcastReceiver {
    private static final String INTENT_KEY_REQUEST_CODE = "intent_key_request_code";
    private static final String TAG = PushNotificationsStateReceiver.class.getSimpleName();
    private static final long NOTIFICATION_CLICK_DELAY = 3000L;
    private static long lastNotificationClickTime = 0L;

    public void onReceive(final Context context, final Intent intent) {
        if (intent != null && intent.getExtras() != null) {
            PushBridgeInternal.getPushNotificationManagerAsync(new IPushNotificationsInternal.PushManagerInternalCallback(){

                @Override
                public void onManagerRetrieved(IPushNotificationsInternal manager) {
                    PushNotificationsStateReceiver.this.handleRequest(context, intent, manager, manager.getAnalyticsManagerInternal());
                }

                @Override
                public void onManagerRetrieveFailed(Throwable throwable) {
                    Logger.e((String)TAG, (String)("onReceive: failed to handle request : getPushNotificationManagerAsync failed : " + throwable.getMessage()));
                }
            });
        }
    }

    @RequiresApi(api=21)
    private void handleRequest(Context context, Intent intent, IPushNotificationsInternal tbPushNotificationsManager, TBPushNotificationsAnalyticsManager pushNotificationsAnalyticsManager) {
        int reqCode = intent.getIntExtra(INTENT_KEY_REQUEST_CODE, -1);
        switch (reqCode) {
            case 4100: {
                BreakingNotificationContent breakingNotificationContent = (BreakingNotificationContent)intent.getParcelableExtra("com.taboola.android.plus.notification.NOTIFICATION_INTENT_EXTRA_KEY_PUSH_CONTENT");
                pushNotificationsAnalyticsManager.sendPushBreakingDismissedEvent(breakingNotificationContent);
                break;
            }
            case 5300: {
                this.handlePushBreakingItemClick(context, intent, tbPushNotificationsManager, pushNotificationsAnalyticsManager);
                break;
            }
            default: {
                Log.e((String)TAG, (String)("onReceive: Illegal request code: " + reqCode));
            }
        }
    }

    @RequiresApi(api=21)
    private void handlePushBreakingItemClick(Context context, Intent intent, IPushNotificationsInternal pushNotificationsManager, TBPushNotificationsAnalyticsManager analyticsManager) {
        Log.v((String)TAG, (String)"onReceive: push item clicked");
        if (System.currentTimeMillis() < lastNotificationClickTime + 3000L) {
            return;
        }
        if (!ConditionCheckUtil.isNetworkAvailable(context)) {
            Toast.makeText((Context)context, (CharSequence)pushNotificationsManager.getLocalizationStrings().getNoNetworkConnection(), (int)1).show();
            return;
        }
        this.collapseStatusBar(context);
        BreakingNotificationContent breakingNotificationContent = (BreakingNotificationContent)intent.getParcelableExtra("com.taboola.android.plus.notification.NOTIFICATION_INTENT_EXTRA_KEY_PUSH_CONTENT");
        Intent clickIntent = new Intent("com.taboola.android.plus.notification.NOTIFICATION_CLICK_EVENT");
        clickIntent.setFlags(0x34000000);
        clickIntent.putExtra("notification_type", "breaking");
        clickIntent.putExtra("com.taboola.android.plus.notification.NOTIFICATION_INTENT_EXTRA_KEY_PUSH_CONTENT", (Parcelable)breakingNotificationContent);
        clickIntent.setPackage(context.getPackageName());
        try {
            context.startActivity(clickIntent);
        }
        catch (ActivityNotFoundException e) {
            Log.e((String)TAG, (String)e.getMessage());
        }
        analyticsManager.sendTapPushBreakingEvent(breakingNotificationContent);
        pushNotificationsManager.dismissNotification();
        lastNotificationClickTime = System.currentTimeMillis();
    }

    private void collapseStatusBar(Context applicationContext) {
        Log.d((String)TAG, (String)"collapseStatusBar: ");
        applicationContext.sendBroadcast(new Intent("android.intent.action.CLOSE_SYSTEM_DIALOGS"));
    }
}

