/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.plus.home.screen.widget;

import android.content.Context;
import android.content.Intent;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import android.text.TextUtils;
import android.util.Log;
import com.google.gson.JsonObject;
import com.taboola.android.api.TBPlacement;
import com.taboola.android.api.TBRecommendationItem;
import com.taboola.android.plus.common.AbstractAnalyticsManager;
import com.taboola.android.plus.common.ICommonAnalyticsEventManager;
import com.taboola.android.plus.common.ISdkPlusCore;
import com.taboola.android.plus.common.SharedLocalStorage;
import com.taboola.android.plus.home.screen.widget.TBWidgetEventProperties;
import com.taboola.android.plus.notifications.scheduled.util.ScheduledNotificationUtil;
import com.taboola.android.utils.Logger;
import com.taboola.android.utils.network.KibanaUtils;
import org.json.JSONObject;

@RequiresApi(api=21)
public class TBWidgetAnalyticsManager
extends AbstractAnalyticsManager<TBWidgetEventProperties>
implements ICommonAnalyticsEventManager {
    private static final String TAG = TBWidgetAnalyticsManager.class.getSimpleName();
    private static final String WIDGET_ITEM_CLICKED = "WidgetItemClick";
    private static final String WIDGET_FEATURE_ENABLED = "WidgetEnabled";
    private static final String WIDGET_FEATURE_DISABLED = "WidgetDisabled";
    private static final String WIDGET_OPEN_APP = "WidgetOpenApp";
    private static final String WIDGET_APP_REFRESH = "WidgetAppRefresh";
    private static final String UNKNOWN_WIDGET_EVENT = "Unknown widget event";
    private static final String INVALID_ITEM_IN_SERVER_RESPONSE = "InvalidItemSvrRes";
    private static final String TABOOLA_API_NOT_INITIALIZED_EVENT = "TBApiNotInit";

    public TBWidgetAnalyticsManager(ISdkPlusCore sdkPlusCore) {
        super(sdkPlusCore);
    }

    public void sendClickOnWidgetItemEvent(@NonNull TBPlacement placement, @NonNull String itemId, @NonNull String clickUrl, @NonNull String articleTitle, boolean isOrganic) {
        TBWidgetEventProperties eventProperties = new TBWidgetEventProperties.Builder(WIDGET_ITEM_CLICKED, false).setPlacement(placement).setItemId(itemId).setClickUrl(clickUrl).setArticleTitle(articleTitle).isOrganic(isOrganic).setTimestamp(KibanaUtils.getISO8601currentTime()).build();
        this.sendEvent(eventProperties, false);
    }

    public void sendWidgetEnabledEvent() {
        this.sentWidgetEvent(WIDGET_FEATURE_ENABLED);
    }

    public void sendWidgetDisabledEvent() {
        this.sentWidgetEvent(WIDGET_FEATURE_DISABLED);
    }

    public void sendWidgetOpenAppEvent() {
        this.sentWidgetEvent(WIDGET_OPEN_APP);
    }

    public void sendWidgetAppRefreshEvent(String reasonMessage) {
        TBWidgetEventProperties eventProperties = new TBWidgetEventProperties.Builder(WIDGET_APP_REFRESH, false).setTimestamp(KibanaUtils.getISO8601currentTime()).setReasonMessage(reasonMessage).build();
        this.sendEvent(eventProperties, false);
    }

    private void sentWidgetEvent(String widgetEventTitle) {
        if (TextUtils.isEmpty((CharSequence)widgetEventTitle)) {
            widgetEventTitle = UNKNOWN_WIDGET_EVENT;
        }
        TBWidgetEventProperties eventProperties = new TBWidgetEventProperties.Builder(widgetEventTitle, false).setTimestamp(KibanaUtils.getISO8601currentTime()).build();
        this.sendEvent(eventProperties, false);
    }

    @Override
    public void sendInvalidItemInServerResponseEvent(String errorMessage, String errorDetails, String recommendationItemId) {
        TBWidgetEventProperties eventProperties = ((TBWidgetEventProperties.Builder)((TBWidgetEventProperties.Builder)new TBWidgetEventProperties.Builder(INVALID_ITEM_IN_SERVER_RESPONSE, false).setErrorMessage(errorMessage)).setError(errorDetails)).build();
        this.sendEvent(eventProperties, false);
    }

    @Override
    public void sendTaboolaApiNotInitializedEvent(String info) {
        Log.e((String)TAG, (String)("TaboolaApiNotInitializedEvent: " + info));
        final TBWidgetEventProperties eventProperties = ((TBWidgetEventProperties.Builder)new TBWidgetEventProperties.Builder(TABOOLA_API_NOT_INITIALIZED_EVENT, false).setError(info)).build();
        this.getNetworkExecutor().execute(new Runnable(){

            @Override
            public void run() {
                TBWidgetAnalyticsManager.this.sendEventToKusto(TBWidgetAnalyticsManager.this.appContext, eventProperties);
            }
        });
    }

    @Override
    protected void broadcastEvent(@NonNull TBWidgetEventProperties tbWidgetEventProperties) {
        try {
            Intent intent = new Intent();
            intent.setAction("tb.analytics.action.name");
            intent.setPackage(this.appContext.getPackageName());
            intent.putExtra("key_event_name", tbWidgetEventProperties.getEventName());
            JSONObject eventsProperties = this.getEventProperties(this.appContext, tbWidgetEventProperties.getError(), tbWidgetEventProperties.isBlocked(), tbWidgetEventProperties.isDeviceLocked(), tbWidgetEventProperties.getExceptionMessage(), tbWidgetEventProperties.getExceptionStackTrace(), tbWidgetEventProperties.getErrorMessage(), tbWidgetEventProperties.getPlacement(), tbWidgetEventProperties.getClickUrl(), tbWidgetEventProperties.getItemId(), tbWidgetEventProperties.getArticleTitle(), tbWidgetEventProperties.getReasonMessage(), tbWidgetEventProperties.isOrganic(), tbWidgetEventProperties.getWidgetLayoutTitle(), tbWidgetEventProperties.getTimestamp());
            intent.putExtra("key_event_properties", eventsProperties.toString());
            JSONObject userProperties = this.getUserProperties(this.appContext);
            intent.putExtra("key_user_properties", userProperties.toString());
            this.appContext.sendBroadcast(intent);
        }
        catch (Exception e) {
            Logger.e((String)TAG, (String)("broadcastEvent fail [" + e.getMessage() + "]"), (Throwable)e);
        }
    }

    private JSONObject getEventProperties(@NonNull Context appContext, @Nullable String error, Boolean isBlocked, Boolean isDeviceLocked, String exceptionMessage, String exceptionStackTrace, String errorMessage, @Nullable TBPlacement placement, String clickUrl, String id, String articleTitle, String reason, Boolean isOrganic, String widgetLayoutTitle, String timestamp) {
        JSONObject eventProperties = this.getCommonEventProperties(appContext, error, isBlocked, isDeviceLocked, exceptionMessage, exceptionStackTrace, errorMessage);
        try {
            if (placement != null && !placement.getItems().isEmpty()) {
                eventProperties.put("placement", ((TBRecommendationItem)placement.getItems().get(0)).getExtraDataMap().get("name"));
            }
            if (!TextUtils.isEmpty((CharSequence)clickUrl)) {
                eventProperties.put("clickUrl", (Object)clickUrl);
            }
            if (!TextUtils.isEmpty((CharSequence)id)) {
                eventProperties.put("id", (Object)id);
            }
            if (!TextUtils.isEmpty((CharSequence)articleTitle)) {
                eventProperties.put("articleTitle", (Object)articleTitle);
            }
            if (!TextUtils.isEmpty((CharSequence)reason)) {
                eventProperties.put("reason", (Object)reason);
            }
            if (!TextUtils.isEmpty((CharSequence)widgetLayoutTitle)) {
                eventProperties.put("widgetLayoutTitle", (Object)widgetLayoutTitle);
            }
            if (isOrganic.booleanValue()) {
                eventProperties.put("clickIgnored", true);
            }
            if (!TextUtils.isEmpty((CharSequence)timestamp)) {
                eventProperties.put("timestamp", (Object)timestamp);
            }
        }
        catch (Exception e) {
            Logger.e((String)TAG, (String)("getEventProperties: parsing issue [" + e.getMessage() + "]"), (Throwable)e);
        }
        return eventProperties;
    }

    @Override
    public JsonObject getJsonObjectForKusto(@NonNull Context appContext, @NonNull TBWidgetEventProperties tbWidgetEventProperties, @NonNull SharedLocalStorage sharedLocalStorage) {
        JsonObject event = super.getJsonObjectForKusto(appContext, tbWidgetEventProperties, sharedLocalStorage);
        try {
            TBRecommendationItem item;
            TBPlacement placement = tbWidgetEventProperties.getPlacement();
            TBRecommendationItem tBRecommendationItem = item = placement != null && !placement.getItems().isEmpty() ? (TBRecommendationItem)placement.getItems().get(0) : null;
            if (item != null) {
                event.add("TBRecommendationItem", ScheduledNotificationUtil.createJsonElementFromRecommendationItem(item));
            }
        }
        catch (Exception e) {
            Logger.e((String)TAG, (String)"Error while parse TBRecommendationItem ", (Throwable)e);
        }
        if (!TextUtils.isEmpty((CharSequence)tbWidgetEventProperties.getItemId())) {
            event.addProperty("itemId", tbWidgetEventProperties.getItemId());
        }
        if (!TextUtils.isEmpty((CharSequence)tbWidgetEventProperties.getClickUrl())) {
            event.addProperty("clickUrl", tbWidgetEventProperties.getClickUrl());
        }
        if (tbWidgetEventProperties.isOrganic().booleanValue()) {
            event.addProperty("isOrganic", Boolean.valueOf(true));
        }
        if (!TextUtils.isEmpty((CharSequence)tbWidgetEventProperties.getArticleTitle())) {
            event.addProperty("articleTitle", tbWidgetEventProperties.getArticleTitle());
        }
        if (!TextUtils.isEmpty((CharSequence)tbWidgetEventProperties.getErrorMessage())) {
            event.addProperty("errorMessage", tbWidgetEventProperties.getErrorMessage());
        }
        if (!TextUtils.isEmpty((CharSequence)tbWidgetEventProperties.getReasonMessage())) {
            event.addProperty("reasonMessage", tbWidgetEventProperties.getReasonMessage());
        }
        if (!TextUtils.isEmpty((CharSequence)tbWidgetEventProperties.getTimestamp())) {
            event.addProperty("timestamp", tbWidgetEventProperties.getTimestamp());
        }
        return event;
    }
}

