/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.plus.notifications.scheduled;

import android.content.Context;
import android.content.Intent;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import android.support.annotation.UiThread;
import android.text.TextUtils;
import android.util.Log;
import com.google.gson.JsonObject;
import com.taboola.android.api.TBPlacement;
import com.taboola.android.api.TBRecommendationItem;
import com.taboola.android.api.TaboolaApi;
import com.taboola.android.plus.common.AbstractAnalyticsManager;
import com.taboola.android.plus.common.SharedLocalStorage;
import com.taboola.android.plus.common.TBDeviceInfoUtil;
import com.taboola.android.plus.core.SdkPlusCore;
import com.taboola.android.plus.notifications.scheduled.NotificationContent;
import com.taboola.android.plus.notifications.scheduled.ScheduledNotificationsLocalStorage;
import com.taboola.android.plus.notifications.scheduled.TBScheduledNotificationEventProperties;
import com.taboola.android.plus.notifications.scheduled.util.ScheduledNotificationUtil;
import com.taboola.android.utils.Logger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.json.JSONObject;

@RequiresApi(api=21)
public class TBScheduledNotificationAnalyticsManager
extends AbstractAnalyticsManager<TBScheduledNotificationEventProperties> {
    private static final String TAG = TBScheduledNotificationAnalyticsManager.class.getSimpleName();
    private static final String TB_ANALYTICS_ACTION_NAME = "tb.analytics.action.name";
    private static final String TB_ANALYTICS_KEY_EVENT_NAME = "key_event_name";
    private static final String TB_ANALYTICS_KEY_EVENT_PROPERTIES = "key_event_properties";
    private static final String TB_ANALYTICS_KEY_USER_PROPERTIES = "key_user_properties";
    private static final String TB_ANALYTICS_KEY_RESPONSE_ITEM_COUNT = "response_item_count";
    private static final String ENABLED_EVENT = "EnabledEvent";
    private static final String DISABLED_EVENT = "DisabledEvent";
    private static final String CONTENT_REFRESH_SUCCESSFUL_EVENT = "ContentRefreshScss";
    private static final String CONTENT_REFRESH_FAILED_EVENT = "ContentRefreshFail";
    private static final String RENDER_EVENT_V2 = "RenderEvent_v2";
    private static final String PRE_RENDER_EVENT = "BeforeRender";
    private static final String FAILED_TO_RENDER_EVENT_V2 = "RenderFailed";
    private static final String FAILED_TO_LOAD_IMAGE_EVENT = "ImageLoadFail";
    private static final String NEXT_ITEM_EVENT = "NextItemEvent";
    private static final String AUTO_NEXT_ITEM_EVENT_V2 = "AutoNextItem";
    private static final String PREV_ITEM_EVENT = "PrevItemEvent";
    private static final String TAP_NOTIFICATION_EVENT = "TapNotif";
    private static final String DISMISSED_EVENT = "DismissedEvent";
    private static final String NOTIFICATION_BLOCKED_BY_CONFIG_EVENT = "CfgBllkdNotif";
    private static final String USER_NOTIFICATION_ENGAGEMENT_GROUP_PROMOTED = "UserNotifEgmtPromot";
    private static final String USER_NOTIFICATION_ENGAGEMENT_GROUP_DEMOTED = "UserNotifEgmtDemot";
    private static final String USER_ASSIGNED_TO_NOTIFICATION_ENGAGEMENT_GROUP = "usrNotifEgmtGrpSet";
    private static final String NOTIFICATION_DISABLED_BY_SYSTEM_EVENT = "NotifDsbldBySys";
    private static final String NOTIFICATION_ENABLED_BY_SYSTEM_EVENT = "NotifEnbldBySys";
    private static final String CHECK_NOTIFICATION_DISABLED_STATUS_EVENT_V3 = "ChkNotifDsbldStatus";
    private static final String INVALID_ITEM_IN_SERVER_RESPONSE = "InvalidItemSvrRes";
    private static final String COLLAPSED_NOTIFICATION_LAYOUT_PROPERTY_KEY = "collapsedNotificationLayout";
    private static final String EXPANDED_NOTIFICATION_LAYOUT_PROPERTY_KEY = "expandedNotificationLayout";
    private static final String TABOOLA_API_NOT_INITIALIZED_EVENT = "TBApiNotInit";
    @NonNull
    private final ScheduledNotificationsLocalStorage scheduledNotificationLocalStorage;

    public TBScheduledNotificationAnalyticsManager(@NonNull SdkPlusCore sdkPlusCore, @NonNull ScheduledNotificationsLocalStorage scheduledNotificationLocalStorage) {
        super(sdkPlusCore);
        this.scheduledNotificationLocalStorage = scheduledNotificationLocalStorage;
    }

    public void sendInvalidItemInServerResponseEvent(String errorMessage, String errorDetails, String recommendationItemId) {
        TBScheduledNotificationEventProperties eventProperties = ((TBScheduledNotificationEventProperties.Builder)((TBScheduledNotificationEventProperties.Builder)new TBScheduledNotificationEventProperties.Builder(INVALID_ITEM_IN_SERVER_RESPONSE, false).setErrorMessage(errorMessage)).setError(errorDetails)).setRecommendationItemId(recommendationItemId).build();
        this.sendEvent(eventProperties, false);
    }

    void sendEnabledEvent() {
        if (this.scheduledNotificationLocalStorage.getPreviousState() == 0 || this.scheduledNotificationLocalStorage.getPreviousState() == -1) {
            TBScheduledNotificationEventProperties eventProperties = new TBScheduledNotificationEventProperties.Builder(ENABLED_EVENT, true).build();
            this.sendEvent(eventProperties, true);
            this.scheduledNotificationLocalStorage.setPreviousState(1);
        }
    }

    void sendDisabledEvent() {
        if (this.scheduledNotificationLocalStorage.getPreviousState() == 1 || this.scheduledNotificationLocalStorage.getPreviousState() == -1) {
            TBScheduledNotificationEventProperties eventProperties = new TBScheduledNotificationEventProperties.Builder(DISABLED_EVENT, true).build();
            this.sendEvent(eventProperties, true);
            this.scheduledNotificationLocalStorage.setPreviousState(0);
        }
    }

    public void sendContentRefreshSuccessfulEvent(int responseItemCount) {
        TBScheduledNotificationEventProperties eventProperties = ((TBScheduledNotificationEventProperties.Builder)new TBScheduledNotificationEventProperties.Builder(CONTENT_REFRESH_SUCCESSFUL_EVENT, false).setResponseItemCount(responseItemCount).setIsDeviceLocked(TBDeviceInfoUtil.isDeviceLocked(this.appContext))).build();
        this.sendEvent(eventProperties, true);
        this.scheduledNotificationLocalStorage.setLastContentRefreshEventTime(System.currentTimeMillis());
    }

    public void sendContentRefreshFailedEvent() {
        TBScheduledNotificationEventProperties eventProperties = ((TBScheduledNotificationEventProperties.Builder)new TBScheduledNotificationEventProperties.Builder(CONTENT_REFRESH_FAILED_EVENT, false).setIsDeviceLocked(TBDeviceInfoUtil.isDeviceLocked(this.appContext))).build();
        this.sendEvent(eventProperties, true);
        this.scheduledNotificationLocalStorage.setLastContentRefreshEventTime(System.currentTimeMillis());
    }

    void sendBeforeRenderEvent(@NonNull NotificationContent notificationContent, @NonNull String notificationLayoutModel) {
        TBPlacement placement = null;
        ArrayList<TBPlacement> placements = notificationContent.getPlacements();
        if (placements != null && !placements.isEmpty()) {
            placement = placements.get(0);
        }
        TBScheduledNotificationEventProperties.Builder eventProperties = ((TBScheduledNotificationEventProperties.Builder)new TBScheduledNotificationEventProperties.Builder(PRE_RENDER_EVENT, false).setPlacement(placement).setIsDeviceLocked(TBDeviceInfoUtil.isDeviceLocked(this.appContext))).setIsHotItem(notificationContent.isHotItem());
        try {
            eventProperties.setNotificationLayoutConfig(notificationLayoutModel);
        }
        catch (Exception e) {
            Logger.e((String)TAG, (String)"sendBeforeRenderEvent fail parse NotificationLayoutConfig ", (Throwable)e);
            ((TBScheduledNotificationEventProperties.Builder)eventProperties.setNotificationLayoutConfig("bad NotificationLayoutConfig").setExceptionMessage(e.getMessage())).setExceptionStackTrace(Arrays.toString(e.getStackTrace()));
        }
        if (placements != null && placements.size() > 1) {
            eventProperties.setUiMode(this.scheduledNotificationLocalStorage.getUiMode());
        }
        this.sendEvent(eventProperties.build(), false);
    }

    void sendRenderEvent(List<TBPlacement> placements, boolean isHotItem) {
        long lastRenderEventTime;
        long lastContentRefreshTime = this.scheduledNotificationLocalStorage.getLastContentRefreshEventTime();
        if (lastContentRefreshTime > (lastRenderEventTime = this.scheduledNotificationLocalStorage.getLastRenderEventTimestamp())) {
            TBScheduledNotificationEventProperties eventProperties;
            if (placements != null && placements.size() > 1) {
                eventProperties = ((TBScheduledNotificationEventProperties.Builder)new TBScheduledNotificationEventProperties.Builder(RENDER_EVENT_V2, false).setUiMode(this.scheduledNotificationLocalStorage.getUiMode()).setPlacement(placements.get(0)).setIsDeviceLocked(TBDeviceInfoUtil.isDeviceLocked(this.appContext))).setIsHotItem(isHotItem).build();
            } else {
                TBPlacement placement = null;
                if (placements != null && !placements.isEmpty()) {
                    placement = placements.get(0);
                }
                eventProperties = ((TBScheduledNotificationEventProperties.Builder)new TBScheduledNotificationEventProperties.Builder(RENDER_EVENT_V2, false).setPlacement(placement).setIsDeviceLocked(TBDeviceInfoUtil.isDeviceLocked(this.appContext))).setIsHotItem(isHotItem).build();
            }
            this.sendEvent(eventProperties, true);
            this.scheduledNotificationLocalStorage.setLastRenderEventTimestamp(System.currentTimeMillis());
        }
    }

    void sendFailedToRenderEvent(String reason) {
        long lastContentRefreshTime = this.scheduledNotificationLocalStorage.getLastContentRefreshEventTime();
        long lastFailedToRenderEventTime = this.scheduledNotificationLocalStorage.getLastFailedToRenderEventTime();
        if (lastFailedToRenderEventTime < lastContentRefreshTime) {
            TBScheduledNotificationEventProperties eventProperties = ((TBScheduledNotificationEventProperties.Builder)((TBScheduledNotificationEventProperties.Builder)new TBScheduledNotificationEventProperties.Builder(FAILED_TO_RENDER_EVENT_V2, false).setError(reason)).setIsDeviceLocked(TBDeviceInfoUtil.isDeviceLocked(this.appContext))).build();
            this.sendEvent(eventProperties, true);
            this.scheduledNotificationLocalStorage.setLastFailedToRenderEventTime(System.currentTimeMillis());
        }
    }

    void sendUserAssignedToNotificationEngagementGroupEvent(@NonNull String currentEngagementGroupName) {
        TBScheduledNotificationEventProperties eventProperties = ((TBScheduledNotificationEventProperties.Builder)new TBScheduledNotificationEventProperties.Builder(USER_ASSIGNED_TO_NOTIFICATION_ENGAGEMENT_GROUP, false).setNewNotificationEngagementGroupName(currentEngagementGroupName).setIsDeviceLocked(TBDeviceInfoUtil.isDeviceLocked(this.appContext))).build();
        this.sendEvent(eventProperties, true);
    }

    void sendUserNotificationEngagementGroupPromotedEvent(@NonNull String previousNotificationEngagementGroupName, @NonNull String newNotificationEngagementGroupName) {
        TBScheduledNotificationEventProperties eventProperties = ((TBScheduledNotificationEventProperties.Builder)new TBScheduledNotificationEventProperties.Builder(USER_NOTIFICATION_ENGAGEMENT_GROUP_PROMOTED, false).setPreviousNotificationEngagementGroupName(previousNotificationEngagementGroupName).setNewNotificationEngagementGroupName(newNotificationEngagementGroupName).setIsDeviceLocked(TBDeviceInfoUtil.isDeviceLocked(this.appContext))).build();
        this.sendEvent(eventProperties, true);
    }

    void sendUserNotificationEngagementGroupDemotedEvent(@NonNull String previousGroupName, @NonNull String newGroupName) {
        TBScheduledNotificationEventProperties eventProperties = new TBScheduledNotificationEventProperties.Builder(USER_NOTIFICATION_ENGAGEMENT_GROUP_DEMOTED, false).setPreviousNotificationEngagementGroupName(previousGroupName).setNewNotificationEngagementGroupName(newGroupName).build();
        this.sendEvent(eventProperties, true);
    }

    void sendFailedToLoadImage(@Nullable String url, @NonNull Throwable throwable, @Nullable String notificationType) {
        TBScheduledNotificationEventProperties.Builder propertiesBuilder = (TBScheduledNotificationEventProperties.Builder)((TBScheduledNotificationEventProperties.Builder)((TBScheduledNotificationEventProperties.Builder)((TBScheduledNotificationEventProperties.Builder)new TBScheduledNotificationEventProperties.Builder(FAILED_TO_LOAD_IMAGE_EVENT, false).setUrl(url).setIsDeviceLocked(TBDeviceInfoUtil.isDeviceLocked(this.appContext))).setError(throwable.getMessage())).setExceptionMessage(throwable.getMessage())).setExceptionStackTrace(Arrays.toString(throwable.getStackTrace()));
        if (notificationType != null) {
            propertiesBuilder.setNotificationType(notificationType);
        }
        this.sendEvent(propertiesBuilder.build(), true);
    }

    void sendNextItemEvent(List<TBPlacement> placements, String collapsedNotificationLayout, String expandedNotificationLayout, boolean isHotItem) {
        TBScheduledNotificationEventProperties eventProperties;
        if (placements != null && placements.size() > 1) {
            eventProperties = ((TBScheduledNotificationEventProperties.Builder)new TBScheduledNotificationEventProperties.Builder(NEXT_ITEM_EVENT, true).setUiMode(this.scheduledNotificationLocalStorage.getUiMode()).setCollapsedNotificationLayout(collapsedNotificationLayout).setExpandedNotificationLayout(expandedNotificationLayout).setPlacement(placements.get(0)).setIsDeviceLocked(TBDeviceInfoUtil.isDeviceLocked(this.appContext))).setIsHotItem(isHotItem).build();
        } else {
            TBPlacement placement = null;
            if (placements != null && !placements.isEmpty()) {
                placement = placements.get(0);
            }
            eventProperties = ((TBScheduledNotificationEventProperties.Builder)new TBScheduledNotificationEventProperties.Builder(NEXT_ITEM_EVENT, true).setCollapsedNotificationLayout(collapsedNotificationLayout).setExpandedNotificationLayout(expandedNotificationLayout).setPlacement(placement).setIsDeviceLocked(TBDeviceInfoUtil.isDeviceLocked(this.appContext))).setIsHotItem(isHotItem).build();
        }
        this.sendEvent(eventProperties, true);
    }

    void sendAutoNextEvent() {
        long lastContentRefreshEventTime = this.scheduledNotificationLocalStorage.getLastContentRefreshEventTime();
        long lastAutoNextItemEventTime = this.scheduledNotificationLocalStorage.getLastAutoNextItemEventTime();
        if (lastAutoNextItemEventTime < lastContentRefreshEventTime) {
            TBScheduledNotificationEventProperties eventProperties = ((TBScheduledNotificationEventProperties.Builder)new TBScheduledNotificationEventProperties.Builder(AUTO_NEXT_ITEM_EVENT_V2, false).setIsDeviceLocked(TBDeviceInfoUtil.isDeviceLocked(this.appContext))).build();
            this.sendEvent(eventProperties, true);
            this.scheduledNotificationLocalStorage.setLastAutoNextItemEventTime(System.currentTimeMillis());
        }
    }

    void sendPrevItemEvent(List<TBPlacement> placements, String collapsedNotificationLayout, String expandedNotificationLayout, boolean isHotItem) {
        TBScheduledNotificationEventProperties eventProperties;
        if (placements != null && placements.size() > 1) {
            eventProperties = ((TBScheduledNotificationEventProperties.Builder)new TBScheduledNotificationEventProperties.Builder(PREV_ITEM_EVENT, true).setUiMode(this.scheduledNotificationLocalStorage.getUiMode()).setCollapsedNotificationLayout(collapsedNotificationLayout).setExpandedNotificationLayout(expandedNotificationLayout).setIsDeviceLocked(TBDeviceInfoUtil.isDeviceLocked(this.appContext))).setPlacement(placements.get(0)).setIsHotItem(isHotItem).build();
        } else {
            TBPlacement placement = null;
            if (placements != null && !placements.isEmpty()) {
                placement = placements.get(0);
            }
            eventProperties = ((TBScheduledNotificationEventProperties.Builder)new TBScheduledNotificationEventProperties.Builder(PREV_ITEM_EVENT, true).setCollapsedNotificationLayout(collapsedNotificationLayout).setExpandedNotificationLayout(expandedNotificationLayout).setPlacement(placement).setIsDeviceLocked(TBDeviceInfoUtil.isDeviceLocked(this.appContext))).setIsHotItem(isHotItem).build();
        }
        this.sendEvent(eventProperties, true);
    }

    void sendTapNotificationEvent(@NonNull TBPlacement placement, boolean isClickIgnored, String collapsedNotificationLayout, String expandedNotificationLayout, boolean isHotItem, String randomCounter) {
        TBScheduledNotificationEventProperties eventProperties = ((TBScheduledNotificationEventProperties.Builder)new TBScheduledNotificationEventProperties.Builder(TAP_NOTIFICATION_EVENT, true).setCollapsedNotificationLayout(collapsedNotificationLayout).setExpandedNotificationLayout(expandedNotificationLayout).setPlacement(placement).setIsClickIgnored(isClickIgnored).setIsDeviceLocked(TBDeviceInfoUtil.isDeviceLocked(this.appContext))).setIsHotItem(isHotItem).setRandomCounter(randomCounter).build();
        this.sendEvent(eventProperties, true);
    }

    void sendDismissedEvent(List<TBPlacement> placements, String collapsedNotificationLayout, String expandedNotificationLayout, boolean isHotItem, String randomCounter) {
        TBScheduledNotificationEventProperties eventProperties;
        if (placements != null && placements.size() > 1) {
            eventProperties = ((TBScheduledNotificationEventProperties.Builder)new TBScheduledNotificationEventProperties.Builder(DISMISSED_EVENT, true).setUiMode(this.scheduledNotificationLocalStorage.getUiMode()).setCollapsedNotificationLayout(collapsedNotificationLayout).setExpandedNotificationLayout(expandedNotificationLayout).setPlacement(placements.get(0)).setIsDeviceLocked(TBDeviceInfoUtil.isDeviceLocked(this.appContext))).setIsHotItem(isHotItem).setRandomCounter(randomCounter).build();
        } else {
            TBPlacement placement = null;
            if (placements != null && !placements.isEmpty()) {
                placement = placements.get(0);
            }
            eventProperties = ((TBScheduledNotificationEventProperties.Builder)new TBScheduledNotificationEventProperties.Builder(DISMISSED_EVENT, true).setCollapsedNotificationLayout(collapsedNotificationLayout).setExpandedNotificationLayout(expandedNotificationLayout).setPlacement(placement).setIsDeviceLocked(TBDeviceInfoUtil.isDeviceLocked(this.appContext))).setIsHotItem(isHotItem).setRandomCounter(randomCounter).build();
        }
        this.sendEvent(eventProperties, true);
        this.scheduledNotificationLocalStorage.setLastDismissEventTimestamp(System.currentTimeMillis());
    }

    void sendNotificationBlockedByConfig() {
        if (!this.scheduledNotificationLocalStorage.isNotificationBlockedByConfigEventAlreadySend()) {
            TBScheduledNotificationEventProperties eventProperties = new TBScheduledNotificationEventProperties.Builder(NOTIFICATION_BLOCKED_BY_CONFIG_EVENT, false).build();
            this.sendEvent(eventProperties, true);
            this.scheduledNotificationLocalStorage.setSendNotificationBlockedByConfigEvent();
        }
    }

    public void sendTaboolaApiNotInitializedEvent(String info) {
        Log.e((String)TAG, (String)("TaboolaApiNotInitializedEvent: " + info));
        final TBScheduledNotificationEventProperties eventProperties = ((TBScheduledNotificationEventProperties.Builder)new TBScheduledNotificationEventProperties.Builder(TABOOLA_API_NOT_INITIALIZED_EVENT, true).setError(info)).build();
        this.getNetworkExecutor().execute(new Runnable(){

            @Override
            public void run() {
                TBScheduledNotificationAnalyticsManager.this.sendEventToKusto(TBScheduledNotificationAnalyticsManager.this.appContext, eventProperties);
            }
        });
    }

    public void sendNotificationDisabledBySystemEvent() {
        TBScheduledNotificationEventProperties eventProperties = ((TBScheduledNotificationEventProperties.Builder)new TBScheduledNotificationEventProperties.Builder(NOTIFICATION_DISABLED_BY_SYSTEM_EVENT, false).setIsDeviceLocked(TBDeviceInfoUtil.isDeviceLocked(this.appContext))).build();
        this.sendEvent(eventProperties, true);
    }

    public void sendNotificationEnabledBySystemEvent() {
        TBScheduledNotificationEventProperties eventProperties = ((TBScheduledNotificationEventProperties.Builder)new TBScheduledNotificationEventProperties.Builder(NOTIFICATION_ENABLED_BY_SYSTEM_EVENT, false).setIsDeviceLocked(TBDeviceInfoUtil.isDeviceLocked(this.appContext))).build();
        this.sendEvent(eventProperties, true);
    }

    public void sendCheckNotificationDisabledStatusEvent(boolean isBlocked) {
        long lastCheckNotificationDisabledStatusEventTime = this.sharedLocalStorage.getLastCheckNotificationDisabledStatusEventTime();
        if (System.currentTimeMillis() - lastCheckNotificationDisabledStatusEventTime > 86400000L && isBlocked) {
            TBScheduledNotificationEventProperties eventProperties = ((TBScheduledNotificationEventProperties.Builder)((TBScheduledNotificationEventProperties.Builder)new TBScheduledNotificationEventProperties.Builder(CHECK_NOTIFICATION_DISABLED_STATUS_EVENT_V3, false).setIsBlocked(true)).setIsDeviceLocked(TBDeviceInfoUtil.isDeviceLocked(this.appContext))).build();
            this.sendEvent(eventProperties, true);
            this.sharedLocalStorage.setLastCheckNotificationDisabledStatusEventTime(System.currentTimeMillis());
        }
    }

    @Override
    public JsonObject getJsonObjectForKusto(@NonNull Context appContext, @NonNull TBScheduledNotificationEventProperties tbNotificationEventProperties, @NonNull SharedLocalStorage sharedLocalStorage) {
        JsonObject event = super.getJsonObjectForKusto(appContext, tbNotificationEventProperties, sharedLocalStorage);
        if (tbNotificationEventProperties.getResponseItemCount() != -1) {
            event.addProperty("responseItemCount", (Number)tbNotificationEventProperties.getResponseItemCount());
        }
        if (!TextUtils.isEmpty((CharSequence)tbNotificationEventProperties.getUiMode())) {
            event.addProperty("itemTitle", tbNotificationEventProperties.getUiMode());
        } else if (tbNotificationEventProperties.getPlacement() != null && !tbNotificationEventProperties.getPlacement().getItems().isEmpty()) {
            event.addProperty("itemTitle", (String)((TBRecommendationItem)tbNotificationEventProperties.getPlacement().getItems().get(0)).getExtraDataMap().get("name"));
        }
        if (!TextUtils.isEmpty((CharSequence)tbNotificationEventProperties.getUrl())) {
            event.addProperty("image_url", tbNotificationEventProperties.getUrl());
        }
        if (tbNotificationEventProperties.isHotItem() != null) {
            event.addProperty("isHotItem", tbNotificationEventProperties.isHotItem());
        }
        if (!TextUtils.isEmpty((CharSequence)tbNotificationEventProperties.getNotificationType())) {
            event.addProperty("notificationType", tbNotificationEventProperties.getNotificationType());
        }
        if (tbNotificationEventProperties.getExceptionCountPeriodMs() != -1L) {
            event.addProperty("exceptionCountPeriodMs", (Number)tbNotificationEventProperties.getExceptionCountPeriodMs());
        }
        if (!TextUtils.isEmpty((CharSequence)tbNotificationEventProperties.getRandomCounter())) {
            event.addProperty("randomCounter", tbNotificationEventProperties.getRandomCounter());
        }
        if (tbNotificationEventProperties.isclickIgnored()) {
            event.addProperty("clickIgnored", Boolean.valueOf(true));
        }
        if (!TextUtils.isEmpty((CharSequence)tbNotificationEventProperties.getCollapsedNotificationLayout())) {
            event.addProperty(COLLAPSED_NOTIFICATION_LAYOUT_PROPERTY_KEY, tbNotificationEventProperties.getCollapsedNotificationLayout());
        }
        if (!TextUtils.isEmpty((CharSequence)tbNotificationEventProperties.getExpandedNotificationLayout())) {
            event.addProperty(EXPANDED_NOTIFICATION_LAYOUT_PROPERTY_KEY, tbNotificationEventProperties.getExpandedNotificationLayout());
        }
        if (!TextUtils.isEmpty((CharSequence)tbNotificationEventProperties.getNewNotificationEngagementGroupName())) {
            event.addProperty("newNotificationEngagementGroupName", tbNotificationEventProperties.getNewNotificationEngagementGroupName());
        }
        if (!TextUtils.isEmpty((CharSequence)tbNotificationEventProperties.getPreviousNotificationEngagementGroupName())) {
            event.addProperty("previousNotificationEngagementGroupName", tbNotificationEventProperties.getPreviousNotificationEngagementGroupName());
        }
        if (!TextUtils.isEmpty((CharSequence)tbNotificationEventProperties.getErrorMessage())) {
            event.addProperty("errorMessage", tbNotificationEventProperties.getErrorMessage());
        }
        if (!TextUtils.isEmpty((CharSequence)tbNotificationEventProperties.getRecommendationItemId())) {
            event.addProperty("recommendationItemId", tbNotificationEventProperties.getRecommendationItemId());
        }
        try {
            TBRecommendationItem item;
            TBPlacement placement = tbNotificationEventProperties.getPlacement();
            TBRecommendationItem tBRecommendationItem = item = placement != null && !placement.getItems().isEmpty() ? (TBRecommendationItem)placement.getItems().get(0) : null;
            if (item != null) {
                event.add("TBRecommendationItem", ScheduledNotificationUtil.createJsonElementFromRecommendationItem(item));
            }
        }
        catch (Exception e) {
            Logger.e((String)TAG, (String)"Error while parse TBRecommendationItem ", (Throwable)e);
        }
        if (!TextUtils.isEmpty((CharSequence)tbNotificationEventProperties.getNotificationLayoutConfig())) {
            event.addProperty("NotificationLayoutConfig", tbNotificationEventProperties.getNotificationLayoutConfig());
        }
        if (!TextUtils.isEmpty((CharSequence)tbNotificationEventProperties.getChannelId())) {
            event.addProperty("channelId", tbNotificationEventProperties.getChannelId());
        }
        return event;
    }

    @Override
    @UiThread
    protected void sendEventToTrc(@NonNull TBScheduledNotificationEventProperties tbScheduledNotificationEventProperties) {
        if (TaboolaApi.getInstance().isInitialized()) {
            TBPlacement placement = tbScheduledNotificationEventProperties.getPlacement();
            if (placement != null && placement.getItems() != null && !placement.getItems().isEmpty()) {
                TBRecommendationItem item = (TBRecommendationItem)placement.getItems().get(0);
                Map<String, String> map = this.getEventMap(this.appContext, tbScheduledNotificationEventProperties);
                item.reportEvent(tbScheduledNotificationEventProperties.getEventName(), map, "youmaylike");
            }
        } else {
            String info = "TBNotificationAnalyticsManager: sendEventToTrc(): " + tbScheduledNotificationEventProperties.getEventName();
            this.sendTaboolaApiNotInitializedEvent(info);
        }
    }

    @Override
    public void broadcastEvent(@NonNull TBScheduledNotificationEventProperties tbNotificationEventProperties) {
        try {
            Intent intent = new Intent();
            intent.setAction(TB_ANALYTICS_ACTION_NAME);
            intent.setPackage(this.appContext.getPackageName());
            intent.putExtra(TB_ANALYTICS_KEY_EVENT_NAME, tbNotificationEventProperties.getEventName());
            JSONObject eventsProperties = this.getEventProperties(this.appContext, tbNotificationEventProperties.getPlacement(), tbNotificationEventProperties.getResponseItemCount(), tbNotificationEventProperties.getError(), tbNotificationEventProperties.getUrl(), tbNotificationEventProperties.isclickIgnored(), tbNotificationEventProperties.getCollapsedNotificationLayout(), tbNotificationEventProperties.getExpandedNotificationLayout(), tbNotificationEventProperties.isBlocked(), tbNotificationEventProperties.isDeviceLocked(), tbNotificationEventProperties.isHotItem(), tbNotificationEventProperties.getUiMode(), tbNotificationEventProperties.getExceptionMessage(), tbNotificationEventProperties.getExceptionCount(), tbNotificationEventProperties.getExceptionCountPeriodMs(), tbNotificationEventProperties.getExceptionStackTrace(), tbNotificationEventProperties.getNewNotificationEngagementGroupName(), tbNotificationEventProperties.getPreviousNotificationEngagementGroupName(), tbNotificationEventProperties.getRecommendationItemId(), tbNotificationEventProperties.getErrorMessage(), tbNotificationEventProperties.getRandomCounter(), tbNotificationEventProperties.getNotificationType());
            intent.putExtra(TB_ANALYTICS_KEY_EVENT_PROPERTIES, eventsProperties.toString());
            if (tbNotificationEventProperties.getResponseItemCount() != -1) {
                intent.putExtra(TB_ANALYTICS_KEY_RESPONSE_ITEM_COUNT, tbNotificationEventProperties.getResponseItemCount());
            }
            JSONObject userProperties = this.getUserProperties(this.appContext);
            intent.putExtra(TB_ANALYTICS_KEY_USER_PROPERTIES, userProperties.toString());
            this.appContext.sendBroadcast(intent);
        }
        catch (Exception e) {
            Logger.e((String)TAG, (String)("broadcastEvent fail [" + e.getMessage() + "]"), (Throwable)e);
        }
    }

    @Override
    @NonNull
    public Map<String, String> getEventMap(@NonNull Context appContext, @NonNull TBScheduledNotificationEventProperties tbNotificationEventProperties) {
        Map<String, String> map = super.getEventMap(appContext, tbNotificationEventProperties);
        if (tbNotificationEventProperties.getResponseItemCount() != -1) {
            map.put("responseItemCount", String.valueOf(tbNotificationEventProperties.getResponseItemCount()));
        }
        if (tbNotificationEventProperties.getUiMode() != null && !tbNotificationEventProperties.getUiMode().isEmpty()) {
            map.put("itemTitle", tbNotificationEventProperties.getUiMode());
        } else {
            String name;
            TBPlacement placement = tbNotificationEventProperties.getPlacement();
            TBRecommendationItem item = placement != null && !placement.getItems().isEmpty() ? (TBRecommendationItem)placement.getItems().get(0) : null;
            String string = name = item != null && item.getExtraDataMap() != null ? (String)item.getExtraDataMap().get("name") : null;
            if (!TextUtils.isEmpty(name)) {
                map.put("itemTitle", name);
            }
        }
        if (tbNotificationEventProperties.getUrl() != null && !tbNotificationEventProperties.getUrl().isEmpty()) {
            map.put("image_url", tbNotificationEventProperties.getUrl());
        }
        if (tbNotificationEventProperties.isHotItem() != null) {
            map.put("isHotItem", String.valueOf(tbNotificationEventProperties.isHotItem()));
        }
        if (tbNotificationEventProperties.getExceptionCount() != -1) {
            map.put("exceptionCount", String.valueOf(tbNotificationEventProperties.getExceptionCount()));
        }
        if (tbNotificationEventProperties.getExceptionCountPeriodMs() != -1L) {
            map.put("exceptionCountPeriodMs", String.valueOf(tbNotificationEventProperties.getExceptionCountPeriodMs()));
        }
        if (tbNotificationEventProperties.getRandomCounter() != null) {
            map.put("randomCounter", tbNotificationEventProperties.getRandomCounter());
        }
        if (tbNotificationEventProperties.isclickIgnored()) {
            map.put("clickIgnored", String.valueOf(true));
        }
        return map;
    }

    private JSONObject getEventProperties(@NonNull Context appContext, @Nullable TBPlacement placement, int responseItemCount, @Nullable String error, @Nullable String url, boolean isClickIngnored, String collapsedNotificationLayout, String expandedNotificationLayout, Boolean isBlocked, Boolean isDeviceLocked, Boolean isHotItem, String uiMode, String exceptionMessage, int exceptionCount, long exceptionCountPeriodMs, String exceptionStackTrace, String newNotificationEngagementGroupName, String previousNotificationEngagementGroupName, String recommendationItemId, String errorMessage, String randomCounter, String notificationType) {
        JSONObject eventProperties = this.getCommonEventProperties(appContext, error, isBlocked, isDeviceLocked, exceptionMessage, exceptionStackTrace, errorMessage);
        try {
            if (responseItemCount != -1) {
                eventProperties.put("responseItemCount", responseItemCount);
            }
            if (!TextUtils.isEmpty((CharSequence)uiMode)) {
                eventProperties.put("placement", (Object)uiMode);
            } else if (placement != null && !placement.getItems().isEmpty()) {
                eventProperties.put("placement", ((TBRecommendationItem)placement.getItems().get(0)).getExtraDataMap().get("name"));
            }
            if (!TextUtils.isEmpty((CharSequence)url)) {
                eventProperties.put("image_url", (Object)url);
            }
            if (!TextUtils.isEmpty((CharSequence)newNotificationEngagementGroupName)) {
                eventProperties.put("newNotificationEngagementGroupName", (Object)newNotificationEngagementGroupName);
            }
            if (!TextUtils.isEmpty((CharSequence)previousNotificationEngagementGroupName)) {
                eventProperties.put("previousNotificationEngagementGroupName", (Object)previousNotificationEngagementGroupName);
            }
            if (!TextUtils.isEmpty((CharSequence)recommendationItemId)) {
                eventProperties.put("invalidRecommendationItemId", (Object)recommendationItemId);
            }
            if (isHotItem != null) {
                eventProperties.put("isHotItem", (Object)isHotItem);
            }
            if (isClickIngnored) {
                eventProperties.put("clickIgnored", true);
            }
            if (!TextUtils.isEmpty((CharSequence)collapsedNotificationLayout)) {
                eventProperties.put(COLLAPSED_NOTIFICATION_LAYOUT_PROPERTY_KEY, (Object)collapsedNotificationLayout);
            }
            if (!TextUtils.isEmpty((CharSequence)expandedNotificationLayout)) {
                eventProperties.put(EXPANDED_NOTIFICATION_LAYOUT_PROPERTY_KEY, (Object)expandedNotificationLayout);
            }
            if (exceptionCount != -1) {
                eventProperties.put("exceptionCount", exceptionCount);
            }
            if (exceptionCountPeriodMs != -1L) {
                eventProperties.put("exceptionCountPeriodMs", exceptionCountPeriodMs);
            }
            if (!TextUtils.isEmpty((CharSequence)randomCounter)) {
                eventProperties.put("randomCounter", (Object)randomCounter);
            }
            if (!TextUtils.isEmpty((CharSequence)notificationType)) {
                eventProperties.put("notificationType", (Object)notificationType);
            }
        }
        catch (Exception e) {
            Logger.e((String)TAG, (String)("getEventProperties: parsing issue [" + e.getMessage() + "]"), (Throwable)e);
        }
        return eventProperties;
    }
}

