/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.plus.notifications.scheduled;

import android.support.annotation.NonNull;
import android.util.Log;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.taboola.android.plus.common.BaseConfig;
import com.taboola.android.plus.common.BaseConfigValidator;
import com.taboola.android.plus.notifications.scheduled.ScheduledNotificationsConfig;
import com.taboola.android.plus.notifications.scheduled.content.NotificationContentConfig;
import com.taboola.android.plus.notifications.scheduled.read_more.ReadMoreItemConfig;
import com.taboola.android.plus.notifications.scheduled.read_more.ReadMoreNotificationsLayoutConfig;
import java.util.ArrayList;

class ScheduledNotificationsConfigValidator
extends BaseConfigValidator {
    private static final String TAG = ScheduledNotificationsConfigValidator.class.getSimpleName();

    ScheduledNotificationsConfigValidator() {
    }

    private boolean isEngagementGroupsValid(JsonArray groupsArray) {
        ArrayList<Boolean> groupValidationList = new ArrayList<Boolean>();
        if (groupsArray.size() == 0) {
            return false;
        }
        for (JsonElement element : groupsArray) {
            if (element.getAsJsonObject().get("groupName").getAsString().equalsIgnoreCase("Default")) {
                JsonElement groupNotificationConfig = element.getAsJsonObject().get("notificationsConfig");
                boolean isDefaultGroupObjectValid = ScheduledNotificationsConfigValidator.isObjectValid(element, ScheduledNotificationsConfig.SmartNotificationFrequency.EngagementGroups.getDefaultRequiredFields());
                if (groupNotificationConfig != null) {
                    boolean isNotificationConfigFromDefaultGroupValid = ScheduledNotificationsConfigValidator.isObjectValid((JsonElement)groupNotificationConfig.getAsJsonObject(), ScheduledNotificationsConfig.SmartNotificationFrequency.EngagementGroups.NotificationsConfig.getDefaultRequiredFields());
                    groupValidationList.add(isDefaultGroupObjectValid && isNotificationConfigFromDefaultGroupValid);
                    continue;
                }
                groupValidationList.add(false);
                continue;
            }
            groupValidationList.add(ScheduledNotificationsConfigValidator.isObjectValid((JsonElement)element.getAsJsonObject(), ScheduledNotificationsConfig.SmartNotificationFrequency.EngagementGroups.getRequiredFields()));
        }
        for (Boolean isGroupValid : groupValidationList) {
            if (isGroupValid.booleanValue()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isConfigValid(@NonNull JsonElement scheduledConfig) {
        JsonElement multipleLayout = null;
        JsonElement trendingLayoutConfig = null;
        JsonElement sponsoredLayoutConfig = null;
        JsonElement readMoreLayoutConfig = null;
        JsonElement engagementGroups = null;
        JsonElement categoryToPlacement = null;
        JsonElement readMore = scheduledConfig.getAsJsonObject().get("readMoreItem");
        JsonElement notificationsContent = scheduledConfig.getAsJsonObject().get("notificationsContent");
        JsonElement scheduledNotificationLayout = scheduledConfig.getAsJsonObject().get("scheduledNotificationsLayout");
        JsonElement smartNotificationFrequency = scheduledConfig.getAsJsonObject().get("smartNotificationFrequency");
        if (smartNotificationFrequency != null) {
            engagementGroups = smartNotificationFrequency.getAsJsonObject().get("engagementGroups");
        }
        if (notificationsContent != null) {
            categoryToPlacement = notificationsContent.getAsJsonObject().get("categoryToPlacement");
        }
        if (scheduledNotificationLayout != null) {
            readMoreLayoutConfig = scheduledNotificationLayout.getAsJsonObject().get("readMoreNotificationsLayout");
            JsonElement contentNotificationsLayout = scheduledNotificationLayout.getAsJsonObject().get("contentNotificationLayout");
            if (contentNotificationsLayout != null) {
                multipleLayout = contentNotificationsLayout.getAsJsonObject().get("multipleItemNotificationsLayout");
                JsonElement singleLayout = contentNotificationsLayout.getAsJsonObject().get("singleItemNotificationsLayout");
                if (singleLayout != null) {
                    trendingLayoutConfig = singleLayout.getAsJsonObject().get("trendingNotificationsLayout");
                    sponsoredLayoutConfig = singleLayout.getAsJsonObject().get("sponsoredNotificationsLayout");
                }
            }
        }
        if (!ScheduledNotificationsConfigValidator.isObjectValid(scheduledConfig, ScheduledNotificationsConfig.getRequiredFields())) {
            Log.e((String)TAG, (String)"isConfigValid: schdeduled notifications config is invalid");
            return false;
        }
        if (!ScheduledNotificationsConfigValidator.isObjectValid(notificationsContent, NotificationContentConfig.getRequiredFields())) {
            Log.e((String)TAG, (String)"isConfigValid: notifications content config is invalid");
            return false;
        }
        if (categoryToPlacement != null && categoryToPlacement.getAsJsonObject().entrySet().isEmpty()) {
            Log.e((String)TAG, (String)"isConfigValid: category to placement map is emtpty");
            return false;
        }
        if (readMore != null && !ScheduledNotificationsConfigValidator.isObjectValid(readMore, ReadMoreItemConfig.getRequiredFields())) {
            Log.e((String)TAG, (String)"isConfigValid: read more notification config is invalid");
            return false;
        }
        if (scheduledNotificationLayout != null && !ScheduledNotificationsConfigValidator.isObjectValid(scheduledNotificationLayout, ScheduledNotificationsConfig.ScheduledNotificationsLayout.getRequiredFields())) {
            Log.e((String)TAG, (String)"isConfigValid: scheduled notification layout config is invalid");
            return false;
        }
        if (multipleLayout != null && !ScheduledNotificationsConfigValidator.isObjectValid(multipleLayout, ScheduledNotificationsConfig.ScheduledNotificationsLayout.MultipleItemNotificationsLayout.getRequiredFields())) {
            Log.e((String)TAG, (String)"isConfigValid: multiple notification layout config is invalid");
            return false;
        }
        if (sponsoredLayoutConfig != null && !ScheduledNotificationsConfigValidator.isObjectValid(sponsoredLayoutConfig, ScheduledNotificationsConfig.ScheduledNotificationsLayout.SingleItemNotificationsLayout.SponsoredNotificationsLayout.getRequiredFields())) {
            Log.e((String)TAG, (String)"isConfigValid: sponsoredLayoutConfig notification config is invalid");
            return false;
        }
        if (trendingLayoutConfig != null && !ScheduledNotificationsConfigValidator.isObjectValid(trendingLayoutConfig, ScheduledNotificationsConfig.ScheduledNotificationsLayout.SingleItemNotificationsLayout.TrendingNotificationsLayout.getRequiredFields())) {
            Log.e((String)TAG, (String)"isConfigValid: trendingLayoutConfig notification config is invalid");
            return false;
        }
        if (readMoreLayoutConfig != null && !ScheduledNotificationsConfigValidator.isObjectValid(readMoreLayoutConfig, ReadMoreNotificationsLayoutConfig.getRequiredFields())) {
            Log.e((String)TAG, (String)"isConfigValid: readMore notification layout config is invalid");
            return false;
        }
        if (!ScheduledNotificationsConfigValidator.isObjectValid(smartNotificationFrequency, ScheduledNotificationsConfig.SmartNotificationFrequency.getRequiredFields())) {
            Log.e((String)TAG, (String)"isConfigValid: smart notification frequency object is invalid");
            return false;
        }
        if (!this.isEngagementGroupsValid(engagementGroups.getAsJsonArray())) {
            Log.e((String)TAG, (String)"isConfigValid: engagement groups object is invalid");
            return false;
        }
        return true;
    }

    @Override
    public <T extends BaseConfig> T parseConfig(@NonNull JsonElement config, @NonNull Class<T> type) {
        Gson gson = new GsonBuilder().registerTypeAdapter(ScheduledNotificationsConfig.SmartNotificationFrequency.class, (Object)new ScheduledNotificationsConfig.SmartNotificationFrequency.SmartNotificationFrequencyAdapter()).create();
        return (T)((BaseConfig)type.cast(gson.fromJson(config, ScheduledNotificationsConfig.class)));
    }
}

