/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.plus.notifications.scheduled;

import android.content.ActivityNotFoundException;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.os.Parcelable;
import android.support.annotation.RequiresApi;
import android.text.TextUtils;
import android.util.Log;
import android.widget.Toast;
import com.taboola.android.api.TBPlacement;
import com.taboola.android.api.TaboolaApi;
import com.taboola.android.plus.common.ConditionCheckUtil;
import com.taboola.android.plus.common.TBDeviceInfoUtil;
import com.taboola.android.plus.common.UrlOpenUtil;
import com.taboola.android.plus.notifications.scheduled.EngagementGroupsHelper;
import com.taboola.android.plus.notifications.scheduled.IScheduledNotificationsInternal;
import com.taboola.android.plus.notifications.scheduled.ScheduledBridgeInternal;
import com.taboola.android.plus.notifications.scheduled.ScheduledNotificationController;
import com.taboola.android.plus.notifications.scheduled.ScheduledNotificationsLocalStorage;
import com.taboola.android.plus.notifications.scheduled.TBScheduledNotificationAnalyticsManager;
import com.taboola.android.plus.notifications.scheduled.TaboolaUnlockActivity;
import com.taboola.android.plus.notifications.scheduled.util.ScheduledNotificationUtil;
import com.taboola.android.utils.Logger;
import java.util.ArrayList;

@RequiresApi(api=21)
public class ScheduledNotificationStateReceiver
extends BroadcastReceiver {
    private static final String TAG = ScheduledNotificationStateReceiver.class.getSimpleName();
    private static final int NOTIFICATION_ITEM_INDEX = 0;
    private static final long NOTIFICATION_CLICK_DELAY_MS = 3000L;
    private static final long NOTIFICATION_CONTENT_SCROLL_ACTION_CLICK_DELAY_MS = 500L;
    private static long lastNotificationClickTimestamp = 0L;
    private static long lastContentScrollActionClickTimestamp = 0L;
    private static final String NOTIFICATION_TYPE_READ_MORE = "Read more notification type";
    private IScheduledNotificationsInternal notificationManager;
    private ScheduledNotificationController notificationController;
    private TBScheduledNotificationAnalyticsManager analyticsManager;
    private ScheduledNotificationsLocalStorage localStorage;
    private ScheduledNotificationUtil scheduledNotificationUtil;
    private EngagementGroupsHelper engagementGroupsHelper;

    public void onReceive(final Context context, final Intent intent) {
        if (intent != null && intent.getExtras() != null) {
            if (this.notificationManager == null) {
                Log.d((String)TAG, (String)"onReceive: notificationManager not initialized. Subscribing for init.");
                ScheduledBridgeInternal.getScheduledNotificationManagerAsync(new IScheduledNotificationsInternal.ScheduledManagerInternalCallback(){

                    @Override
                    public void onManagerRetrieved(IScheduledNotificationsInternal scheduledNotificationsManager) {
                        Log.d((String)TAG, (String)"onManagerRetrieved: notificationManager init successful");
                        ScheduledNotificationStateReceiver.this.notificationManager = scheduledNotificationsManager;
                        ScheduledNotificationStateReceiver.this.notificationController = ScheduledNotificationStateReceiver.this.notificationManager.getScheduledNotificationController();
                        ScheduledNotificationStateReceiver.this.analyticsManager = ScheduledNotificationStateReceiver.this.notificationManager.getScheduledAnalyticsManager();
                        ScheduledNotificationStateReceiver.this.localStorage = ScheduledNotificationStateReceiver.this.notificationManager.getScheduledLocalStorage();
                        ScheduledNotificationStateReceiver.this.engagementGroupsHelper = ScheduledNotificationStateReceiver.this.notificationManager.getEngagementGroupsHelper();
                        ScheduledNotificationStateReceiver.this.scheduledNotificationUtil = ScheduledNotificationStateReceiver.this.notificationManager.getScheduledNotificationUtil();
                        if (TaboolaApi.getInstance().isInitialized()) {
                            ScheduledNotificationStateReceiver.this.handleIntent(context, intent);
                        } else {
                            String info = "ScheduledNotificationStateReceiver: onReceive(): onManagerRetrieved()";
                            ScheduledNotificationStateReceiver.this.analyticsManager.sendTaboolaApiNotInitializedEvent(info);
                        }
                    }

                    @Override
                    public void onManagerRetrieveFailed(Throwable throwable) {
                        Log.e((String)TAG, (String)"onReceive: failed to handle request: onManagerRetrieveFailed: ", (Throwable)throwable);
                    }
                });
            } else {
                Logger.d((String)TAG, (String)"onReceive: notificationManager is already initialized. Handling intent.");
                this.handleIntent(context, intent);
            }
        }
    }

    private void handleIntent(Context context, Intent intent) {
        int reqCode = intent.getIntExtra("intent_key_request_code", -1);
        switch (reqCode) {
            case 2100: 
            case 2200: {
                this.onActionPrevClicked(intent);
                break;
            }
            case 3100: 
            case 3200: {
                this.onActionNextClicked(intent);
                break;
            }
            case 3500: {
                this.onAutoNextTriggered();
                break;
            }
            case 4000: {
                this.onUserDismissedNotification(intent);
                break;
            }
            case 6100: 
            case 6200: {
                this.onAttributionClick(context, intent);
                break;
            }
            case 5000: {
                this.handleItemClick(context, intent, false);
                break;
            }
            case 5100: 
            case 5101: 
            case 5102: 
            case 5200: 
            case 5201: 
            case 5202: 
            case 5203: 
            case 5204: 
            case 5205: {
                this.handleItemClick(context, intent, true);
                break;
            }
            case 3600: {
                this.onImageLoadFailed(intent);
                break;
            }
            default: {
                Log.e((String)TAG, (String)("onReceive: Illegal request code: " + reqCode));
            }
        }
    }

    private void onActionPrevClicked(Intent intent) {
        Log.v((String)TAG, (String)"onReceive: ACTION_PREV");
        if (System.currentTimeMillis() < lastContentScrollActionClickTimestamp + 500L) {
            return;
        }
        this.engagementGroupsHelper.handleUserEngagedAction();
        ArrayList placements = intent.getParcelableArrayListExtra("com.taboola.android.plus.notifications.scheduled.NOTIFICATION_INTENT_EXTRA_KEY_PLACEMENT_LIST");
        this.scheduledNotificationUtil.reportPlacementVisibility(placements);
        boolean isHotItem = intent.getBooleanExtra("com.taboola.android.plus.notifications.scheduled.NOTIFICATION_INTENT_EXTRA_KEY_IS_HOT_ITEM", false);
        String collapsedNotificationLayout = intent.getStringExtra("com.taboola.android.plus.notifications.scheduled.NOTIFICATION_INTENT_EXTRA_KEY_COLLAPSED_NOTIFICATION_LAYOUT ");
        String expandedNotificationLayout = intent.getStringExtra("com.taboola.android.plus.notifications.scheduled.NOTIFICATION_INTENT_EXTRA_KEY_EXPANDED_NOTIFICATION_LAYOUT ");
        this.analyticsManager.sendPrevItemEvent(placements, collapsedNotificationLayout, expandedNotificationLayout, isHotItem);
        this.notificationController.renderPrevPage();
        lastContentScrollActionClickTimestamp = System.currentTimeMillis();
    }

    private void onActionNextClicked(Intent intent) {
        Log.v((String)TAG, (String)"onReceive: ACTION_NEXT");
        if (System.currentTimeMillis() < lastContentScrollActionClickTimestamp + 500L) {
            return;
        }
        this.engagementGroupsHelper.handleUserEngagedAction();
        ArrayList placements = intent.getParcelableArrayListExtra("com.taboola.android.plus.notifications.scheduled.NOTIFICATION_INTENT_EXTRA_KEY_PLACEMENT_LIST");
        this.scheduledNotificationUtil.reportPlacementVisibility(placements);
        boolean isHotItem = intent.getBooleanExtra("com.taboola.android.plus.notifications.scheduled.NOTIFICATION_INTENT_EXTRA_KEY_IS_HOT_ITEM", false);
        String collapsedNotificationLayout = intent.getStringExtra("com.taboola.android.plus.notifications.scheduled.NOTIFICATION_INTENT_EXTRA_KEY_COLLAPSED_NOTIFICATION_LAYOUT ");
        String expandedNotificationLayout = intent.getStringExtra("com.taboola.android.plus.notifications.scheduled.NOTIFICATION_INTENT_EXTRA_KEY_EXPANDED_NOTIFICATION_LAYOUT ");
        this.analyticsManager.sendNextItemEvent(placements, collapsedNotificationLayout, expandedNotificationLayout, isHotItem);
        this.notificationController.renderNextPage(true);
        lastContentScrollActionClickTimestamp = System.currentTimeMillis();
    }

    private void onAutoNextTriggered() {
        Log.v((String)TAG, (String)"onReceive: auto_switch");
        long autoNextIntervalMs = this.engagementGroupsHelper.getCurrentEngagementGroup().getNotificationsConfig().getAutoNextIntervalMs();
        if (System.currentTimeMillis() < lastContentScrollActionClickTimestamp + autoNextIntervalMs) {
            return;
        }
        this.notificationController.renderNextPage(false);
        this.analyticsManager.sendAutoNextEvent();
    }

    private void onUserDismissedNotification(Intent intent) {
        this.engagementGroupsHelper.handleUserUnengagedAction();
        Log.v((String)TAG, (String)"onReceive: notification dismissed by a user");
        ArrayList placements = intent.getParcelableArrayListExtra("com.taboola.android.plus.notifications.scheduled.NOTIFICATION_INTENT_EXTRA_KEY_PLACEMENT_LIST");
        this.scheduledNotificationUtil.reportPlacementVisibility(placements);
        boolean isHotItem = intent.getBooleanExtra("com.taboola.android.plus.notifications.scheduled.NOTIFICATION_INTENT_EXTRA_KEY_IS_HOT_ITEM", false);
        String readMoreRandomCounter = intent.getStringExtra("com.taboola.android.plus.notifications.scheduled.NOTIFICATION_INTENT_EXTRA_KEY_READ_MORE_RANDOM_COUNTER");
        String collapsedNotificationLayout = intent.getStringExtra("com.taboola.android.plus.notifications.scheduled.NOTIFICATION_INTENT_EXTRA_KEY_COLLAPSED_NOTIFICATION_LAYOUT ");
        String expandedNotificationLayout = intent.getStringExtra("com.taboola.android.plus.notifications.scheduled.NOTIFICATION_INTENT_EXTRA_KEY_EXPANDED_NOTIFICATION_LAYOUT ");
        this.notificationController.onUserDismissedNotification(placements, collapsedNotificationLayout, expandedNotificationLayout, isHotItem, readMoreRandomCounter);
    }

    private void onAttributionClick(Context context, Intent intent) {
        Log.v((String)TAG, (String)"onReceive: on attribution click");
        if (!ConditionCheckUtil.isNetworkAvailable(context)) {
            Toast.makeText((Context)context, (CharSequence)this.notificationManager.getLocalizationStrings().getNoNetworkConnection(), (int)1).show();
            return;
        }
        if (System.currentTimeMillis() < lastNotificationClickTimestamp + 3000L) {
            return;
        }
        this.engagementGroupsHelper.handleUserEngagedAction();
        ArrayList placements = intent.getParcelableArrayListExtra("com.taboola.android.plus.notifications.scheduled.NOTIFICATION_INTENT_EXTRA_KEY_PLACEMENT_LIST");
        this.scheduledNotificationUtil.reportPlacementVisibility(placements);
        this.collapseStatusBar(context);
        if (TBDeviceInfoUtil.isDeviceLocked(context)) {
            Log.d((String)TAG, (String)"handleIntent: attribution click");
            TaboolaUnlockActivity.attributionLaunch(context);
        } else {
            UrlOpenUtil.handleAttributionClick(context);
        }
    }

    private void handleItemClick(Context context, Intent intent, boolean shouldUnlockManually) {
        Log.v((String)TAG, (String)"onReceive: item clicked");
        if (System.currentTimeMillis() < lastNotificationClickTimestamp + 3000L) {
            return;
        }
        if (!ConditionCheckUtil.isNetworkAvailable(context)) {
            Toast.makeText((Context)context, (CharSequence)this.notificationManager.getLocalizationStrings().getNoNetworkConnection(), (int)1).show();
            return;
        }
        this.engagementGroupsHelper.handleUserEngagedAction();
        ArrayList placements = intent.getParcelableArrayListExtra("com.taboola.android.plus.notifications.scheduled.NOTIFICATION_INTENT_EXTRA_KEY_PLACEMENT_LIST");
        this.scheduledNotificationUtil.reportPlacementVisibility(placements);
        Intent externalClickIntent = new Intent("com.taboola.android.plus.notification.NOTIFICATION_CLICK_EVENT");
        externalClickIntent.setFlags(0x34000000);
        TBPlacement placement = (TBPlacement)intent.getParcelableExtra("com.taboola.android.plus.notifications.scheduled.NOTIFICATION_INTENT_EXTRA_KEY_PLACEMENT");
        externalClickIntent.putExtra("com.taboola.android.plus.notifications.scheduled.NOTIFICATION_CLICK_EVENT_PLACEMENT", (Parcelable)placement);
        externalClickIntent.putExtra("com.taboola.android.plus.notifications.scheduled.NOTIFICATION_CLICK_EVENT_ITEM_INDEX", 0);
        externalClickIntent.putExtra("notification_type", "Scheduled");
        externalClickIntent.setPackage(context.getPackageName());
        boolean isHotItem = intent.getBooleanExtra("com.taboola.android.plus.notifications.scheduled.NOTIFICATION_INTENT_EXTRA_KEY_IS_HOT_ITEM", false);
        try {
            this.collapseStatusBar(context);
            if (shouldUnlockManually && TBDeviceInfoUtil.isDeviceLocked(context)) {
                TaboolaUnlockActivity.launch(context, externalClickIntent);
            } else {
                context.startActivity(externalClickIntent);
            }
        }
        catch (ActivityNotFoundException e) {
            Log.e((String)TAG, (String)e.getMessage());
        }
        String collapsedNotificationLayout = intent.getStringExtra("com.taboola.android.plus.notifications.scheduled.NOTIFICATION_INTENT_EXTRA_KEY_COLLAPSED_NOTIFICATION_LAYOUT ");
        String expandedNotificationLayout = intent.getStringExtra("com.taboola.android.plus.notifications.scheduled.NOTIFICATION_INTENT_EXTRA_KEY_EXPANDED_NOTIFICATION_LAYOUT ");
        boolean isReadMore = intent.getBooleanExtra("com.taboola.android.plus.notifications.scheduled.NOTIFICATION_INTENT_EXTRA_KEY_IS_READ_MORE", false);
        String readMoreRandomCounter = intent.getStringExtra("com.taboola.android.plus.notifications.scheduled.NOTIFICATION_INTENT_EXTRA_KEY_READ_MORE_RANDOM_COUNTER");
        Log.d((String)TAG, (String)("isReadMore: " + isReadMore));
        this.analyticsManager.sendTapNotificationEvent(placement, false, collapsedNotificationLayout, expandedNotificationLayout, isHotItem, readMoreRandomCounter);
        if (isReadMore) {
            this.notificationManager.getScheduledNotificationController().dismissNotification();
        } else {
            this.notificationController.removePlacement(placement);
        }
        lastNotificationClickTimestamp = System.currentTimeMillis();
    }

    private void onImageLoadFailed(Intent intent) {
        Log.w((String)TAG, (String)"onReceive: ImageLoadFailed: removing current item");
        String imageUri = intent.getStringExtra("com.taboola.android.plus.notifications.scheduled.NOTIFICATION_INTENT_EXTRA_KEY_IMAGE_URI");
        boolean isReadMore = intent.getBooleanExtra("com.taboola.android.plus.notifications.scheduled.NOTIFICATION_INTENT_EXTRA_KEY_IS_READ_MORE", false);
        Throwable exception = (Throwable)intent.getSerializableExtra("com.taboola.android.plus.notifications.scheduled.NOTIFICATION_INTENT_EXTRA_KEY_EXCEPTION");
        if (!(TextUtils.isEmpty((CharSequence)imageUri) || imageUri.equals("null") || isReadMore)) {
            this.notificationController.removePlacement(imageUri);
        }
        String notificationType = isReadMore ? NOTIFICATION_TYPE_READ_MORE : null;
        this.analyticsManager.sendFailedToLoadImage(imageUri, exception, notificationType);
    }

    private void collapseStatusBar(Context applicationContext) {
        Log.d((String)TAG, (String)"collapseStatusBar() called");
        applicationContext.sendBroadcast(new Intent("android.intent.action.CLOSE_SYSTEM_DIALOGS"));
    }
}

