/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.plus.core;

import android.accounts.NetworkErrorException;
import android.support.annotation.Keep;
import android.support.annotation.MainThread;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import android.support.annotation.RestrictTo;
import android.util.Log;
import com.taboola.android.plus.core.AbsPushManager;
import com.taboola.android.plus.core.AbsScheduledManager;
import com.taboola.android.plus.core.CoreInitCallback;
import com.taboola.android.plus.core.ICoreProvider;
import com.taboola.android.plus.core.InternalFeatureInitCallback;
import com.taboola.android.plus.core.InternalSdkPlusCoreInitCallback;
import com.taboola.android.plus.core.PlusFeature;
import com.taboola.android.plus.core.PushManagerCallback;
import com.taboola.android.plus.core.ScheduledManagerCallback;
import com.taboola.android.plus.core.SdkPlusCore;
import com.taboola.android.plus.core.SdkPlusInitCallback;
import com.taboola.android.plus.core.SdkPlusPublisherInfo;
import com.taboola.android.plus.core.TBLPushManager;
import com.taboola.android.plus.core.TBLScheduledManager;
import com.taboola.android.utils.Logger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Executor;

@Keep
@RequiresApi(api=21)
public class TaboolaSdkPlus {
    private static final String TAG = TaboolaSdkPlus.class.getSimpleName();
    private static TaboolaSdkPlus singleton = null;
    private SdkPlusCore sdkPlusCore;
    private AbsScheduledManager scheduledNotificationsManager;
    private AbsPushManager pushNotificationsManager;
    private final List<SdkPlusInitCallback> externalCallbacks = new ArrayList<SdkPlusInitCallback>();
    private final List<InternalSdkPlusCoreInitCallback> coreInitCallbacks = new ArrayList<InternalSdkPlusCoreInitCallback>();
    private final List<InternalFeatureInitCallback> pushInitCallbacks = new ArrayList<InternalFeatureInitCallback>();
    private final List<InternalFeatureInitCallback> scheduledInitCallbacks = new ArrayList<InternalFeatureInitCallback>();
    private boolean isScheduledInitInProgress = false;
    private boolean isPushInitInProgress = false;
    private ICoreProvider coreProvider;
    private SdkPlusPublisherInfo sdkPlusPublisherInfo;
    private Executor mainThreadExecutor;

    private TaboolaSdkPlus() {
    }

    static void setSdkPlusCore(SdkPlusCore sdkPlusCore) {
        TaboolaSdkPlus.getInstanceInternal().sdkPlusCore = sdkPlusCore;
    }

    static void setCoreProvider(ICoreProvider coreProvider) {
        TaboolaSdkPlus.getInstanceInternal().coreProvider = coreProvider;
    }

    static ICoreProvider getCoreProvider() {
        return TaboolaSdkPlus.getInstanceInternal().coreProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static TaboolaSdkPlus getInstanceInternal() {
        if (singleton != null) return singleton;
        Class<TaboolaSdkPlus> clazz = TaboolaSdkPlus.class;
        synchronized (TaboolaSdkPlus.class) {
            if (singleton != null) return singleton;
            singleton = new TaboolaSdkPlus();
            // ** MonitorExit[var0] (shouldn't be in output)
            return singleton;
        }
    }

    @RequiresApi(api=21)
    public static synchronized void init(@NonNull SdkPlusPublisherInfo info, @Nullable SdkPlusInitCallback callback) {
        TaboolaSdkPlus.getInstanceInternal().initInternal(info, callback);
    }

    private void initInternal(final @NonNull SdkPlusPublisherInfo info, @Nullable SdkPlusInitCallback callback) {
        this.sdkPlusPublisherInfo = info;
        if (callback != null) {
            this.externalCallbacks.add(callback);
        }
        this.sdkPlusCore.init(info, this.coreProvider.getMigrationManager(), new CoreInitCallback(){

            @Override
            public void onCoreInitSuccessful(@NonNull SdkPlusCore sdkPlusCore) {
                TaboolaSdkPlus.this.onCoreInitialized(sdkPlusCore);
                TaboolaSdkPlus.this.initFeatures();
            }

            @Override
            public void onCoreInitFailed(Throwable throwable) {
                Logger.e((String)TAG, (String)("onCoreInitFailed: " + throwable.toString()), (Throwable)throwable);
                for (InternalSdkPlusCoreInitCallback coreInitCallback : TaboolaSdkPlus.this.coreInitCallbacks) {
                    coreInitCallback.onSdkPlusCoreInitFailed(throwable);
                }
                TaboolaSdkPlus.this.coreInitCallbacks.clear();
                for (PlusFeature plusFeature : info.getActiveFeatures()) {
                    for (SdkPlusInitCallback externalCallback : TaboolaSdkPlus.this.externalCallbacks) {
                        externalCallback.onFeatureInitFailed(plusFeature, throwable);
                    }
                }
                TaboolaSdkPlus.this.externalCallbacks.clear();
            }
        });
    }

    private void onCoreInitialized(@NonNull SdkPlusCore sdkPlusCore) {
        this.mainThreadExecutor = sdkPlusCore.getSdkPlusExecutors().getMainThreadExecutor();
        for (InternalSdkPlusCoreInitCallback coreInitCallback : this.coreInitCallbacks) {
            coreInitCallback.onSdkPlusCoreInitSuccessful(sdkPlusCore);
        }
        this.coreInitCallbacks.clear();
    }

    private void initFeatures() {
        block4: for (PlusFeature plusFeature : this.sdkPlusPublisherInfo.getActiveFeatures()) {
            InternalFeatureInitCallback internalFeatureInitCallback = new InternalFeatureInitCallback(){

                @Override
                public void onFeatureInitSuccessful(final PlusFeature plusFeature) {
                    TaboolaSdkPlus.this.mainThreadExecutor.execute(new Runnable(){

                        @Override
                        public void run() {
                            TaboolaSdkPlus.this.onFeatureInitSuccessful(plusFeature);
                        }
                    });
                }

                @Override
                public void onFeatureInitFailed(final PlusFeature plusFeature, final Exception exception) {
                    TaboolaSdkPlus.this.mainThreadExecutor.execute(new Runnable(){

                        @Override
                        public void run() {
                            TaboolaSdkPlus.this.onFeatureInitFailed(plusFeature, exception);
                        }
                    });
                }
            };
            switch (plusFeature) {
                case SCHEDULED_NOTIFICATIONS: {
                    this.initScheduledNotifications(internalFeatureInitCallback);
                    continue block4;
                }
                case PUSH_NOTIFICATIONS: {
                    this.initPushNotifications(internalFeatureInitCallback);
                }
            }
        }
    }

    private void initScheduledNotifications(InternalFeatureInitCallback internalFeatureInitCallback) {
        this.scheduledNotificationsManager = this.coreProvider.getScheduledNotificationsManager();
        this.isScheduledInitInProgress = true;
        this.scheduledNotificationsManager.init(this.sdkPlusCore, this.sdkPlusPublisherInfo.getScheduledNotificationExtraProperties(), internalFeatureInitCallback);
    }

    private void initPushNotifications(InternalFeatureInitCallback internalFeatureInitCallback) {
        this.pushNotificationsManager = this.coreProvider.getPushNotificationsManager();
        if (this.sdkPlusCore.getNetworkState().isConnected()) {
            this.isPushInitInProgress = true;
            this.pushNotificationsManager.init(this.sdkPlusCore, this.sdkPlusPublisherInfo.getPublisherName(), internalFeatureInitCallback);
        } else {
            internalFeatureInitCallback.onFeatureInitFailed(PlusFeature.PUSH_NOTIFICATIONS, (Exception)new NetworkErrorException("No internet connection"));
        }
    }

    @MainThread
    private void onFeatureInitSuccessful(PlusFeature plusFeature) {
        List<InternalFeatureInitCallback> internalCallbacks = this.getFeatureInitCallbacks(plusFeature);
        if (internalCallbacks != null) {
            for (InternalFeatureInitCallback internalFeatureInitCallback : internalCallbacks) {
                internalFeatureInitCallback.onFeatureInitSuccessful(plusFeature);
            }
            internalCallbacks.clear();
        }
        for (SdkPlusInitCallback externalCallback : this.externalCallbacks) {
            externalCallback.onFeatureInitSuccessful(this, plusFeature);
        }
        switch (plusFeature) {
            case SCHEDULED_NOTIFICATIONS: {
                this.isScheduledInitInProgress = false;
                break;
            }
            case PUSH_NOTIFICATIONS: {
                this.isPushInitInProgress = false;
            }
        }
        if (!this.isScheduledInitInProgress && !this.isPushInitInProgress) {
            this.externalCallbacks.clear();
        }
    }

    @MainThread
    private void onFeatureInitFailed(PlusFeature plusFeature, Exception exception) {
        List<InternalFeatureInitCallback> internalCallbacks = this.getFeatureInitCallbacks(plusFeature);
        if (internalCallbacks != null) {
            for (InternalFeatureInitCallback internalFeatureInitCallback : internalCallbacks) {
                internalFeatureInitCallback.onFeatureInitFailed(plusFeature, exception);
            }
            internalCallbacks.clear();
        }
        for (SdkPlusInitCallback externalCallback : this.externalCallbacks) {
            externalCallback.onFeatureInitFailed(plusFeature, exception);
        }
        if (!this.isScheduledInitInProgress && !this.isPushInitInProgress) {
            this.externalCallbacks.clear();
        }
    }

    private void subscribeForSdkPlusCoreInit(final InternalSdkPlusCoreInitCallback coreInitCallback) {
        if (this.sdkPlusCore != null && this.sdkPlusCore.isCoreInitialized()) {
            this.mainThreadExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    coreInitCallback.onSdkPlusCoreInitSuccessful(TaboolaSdkPlus.this.sdkPlusCore);
                }
            });
        } else {
            this.coreInitCallbacks.add(coreInitCallback);
        }
    }

    private void subscribeForFeatureInit(@NonNull PlusFeature plusFeature, final @NonNull InternalFeatureInitCallback callback) {
        switch (plusFeature) {
            case SCHEDULED_NOTIFICATIONS: {
                if (this.scheduledNotificationsManager != null && this.scheduledNotificationsManager.isInitialized()) {
                    this.mainThreadExecutor.execute(new Runnable(){

                        @Override
                        public void run() {
                            callback.onFeatureInitSuccessful(PlusFeature.SCHEDULED_NOTIFICATIONS);
                        }
                    });
                    break;
                }
                this.scheduledInitCallbacks.add(callback);
                break;
            }
            case PUSH_NOTIFICATIONS: {
                if (this.pushNotificationsManager != null && this.pushNotificationsManager.isInitialized()) {
                    this.mainThreadExecutor.execute(new Runnable(){

                        @Override
                        public void run() {
                            callback.onFeatureInitSuccessful(PlusFeature.PUSH_NOTIFICATIONS);
                        }
                    });
                    break;
                }
                this.pushInitCallbacks.add(callback);
            }
        }
    }

    @Nullable
    private List<InternalFeatureInitCallback> getFeatureInitCallbacks(PlusFeature plusFeature) {
        if (plusFeature != null) {
            switch (plusFeature) {
                case SCHEDULED_NOTIFICATIONS: {
                    return this.scheduledInitCallbacks;
                }
                case PUSH_NOTIFICATIONS: {
                    return this.pushInitCallbacks;
                }
            }
        }
        return null;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    static void getSdkPlusCoreAsync(InternalSdkPlusCoreInitCallback callback) {
        TaboolaSdkPlus.getInstanceInternal().subscribeForSdkPlusCoreInit(callback);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    static void getScheduledNotificationManagerAsync(final ScheduledManagerCallback callback) {
        TaboolaSdkPlus.getInstanceInternal().subscribeForFeatureInit(PlusFeature.SCHEDULED_NOTIFICATIONS, new InternalFeatureInitCallback(){

            @Override
            public void onFeatureInitSuccessful(PlusFeature plusFeature) {
                AbsScheduledManager manager = TaboolaSdkPlus.getInstanceInternal().scheduledNotificationsManager;
                callback.onManagerRetrieved(manager);
            }

            @Override
            public void onFeatureInitFailed(PlusFeature plusFeature, Exception exception) {
                callback.onManagerRetrieveFailed(exception);
            }
        });
    }

    static void getPushNotificationManagerAsync(final PushManagerCallback pushManagerCallback) {
        TaboolaSdkPlus.getInstanceInternal().subscribeForFeatureInit(PlusFeature.PUSH_NOTIFICATIONS, new InternalFeatureInitCallback(){

            @Override
            public void onFeatureInitSuccessful(PlusFeature plusFeature) {
                AbsPushManager manager = TaboolaSdkPlus.getInstanceInternal().pushNotificationsManager;
                if (manager != null) {
                    pushManagerCallback.onManagerRetrieved(manager);
                } else {
                    pushManagerCallback.onManagerRetrieveFailed(new Throwable("Fail to get Push manager"));
                }
            }

            @Override
            public void onFeatureInitFailed(PlusFeature plusFeature, Exception exception) {
                pushManagerCallback.onManagerRetrieveFailed(exception);
            }
        });
    }

    @Nullable
    public static TBLScheduledManager getScheduledNotificationManager() {
        AbsScheduledManager manager = TaboolaSdkPlus.getInstanceInternal().scheduledNotificationsManager;
        if (manager != null && manager.isInitialized()) {
            return manager;
        }
        return null;
    }

    @Nullable
    public static TBLPushManager getPushNotificationManager() {
        AbsPushManager manager = TaboolaSdkPlus.getInstanceInternal().pushNotificationsManager;
        if (manager != null && manager.isInitialized()) {
            return manager;
        }
        return null;
    }

    static boolean isFeatureActivated(PlusFeature plusFeature) {
        PlusFeature[] activeFeatures;
        SdkPlusPublisherInfo sdkPlusPublisherInfo = TaboolaSdkPlus.getInstanceInternal().sdkPlusPublisherInfo;
        PlusFeature[] plusFeatureArray = activeFeatures = sdkPlusPublisherInfo != null ? sdkPlusPublisherInfo.getActiveFeatures() : null;
        if (activeFeatures == null) {
            Log.e((String)TAG, (String)"onReceive: couldn't get active features");
            return false;
        }
        List<PlusFeature> activeFeaturesList = Arrays.asList(activeFeatures);
        boolean isFeatureActive = activeFeaturesList.contains((Object)plusFeature);
        Log.d((String)TAG, (String)("isFeatureActivated: " + (Object)((Object)plusFeature) + " is activated during sdk+ init: " + isFeatureActive));
        return isFeatureActive;
    }
}

