/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.plus.notification;

import android.app.job.JobInfo;
import android.app.job.JobParameters;
import android.app.job.JobScheduler;
import android.app.job.JobService;
import android.content.ComponentName;
import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.PersistableBundle;
import android.support.annotation.NonNull;
import android.support.annotation.RequiresApi;
import android.text.TextUtils;
import android.util.Log;
import com.taboola.android.plus.BridgeInternal;
import com.taboola.android.plus.ConfigManager;
import com.taboola.android.plus.TaboolaPlus;
import com.taboola.android.plus.notification.NotificationConfig;
import com.taboola.android.plus.notification.NotificationRefreshCallback;
import com.taboola.android.plus.notification.TBDeviceInfoUtil;
import com.taboola.android.plus.notification.TBNotificationAnalyticsManager;
import com.taboola.android.plus.notification.TBNotificationLocalStore;
import com.taboola.android.plus.notification.TBNotificationManager;
import com.taboola.android.plus.notification.killSwitch.KillSwitchUtil;
import com.taboola.android.plus.shared.ConditionCheckUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@RequiresApi(api=21)
public class TBNotificationRefreshJob
extends JobService {
    private static final String TAG = TBNotificationRefreshJob.class.getSimpleName();
    private static final int JOB_ID = 64879717;
    private static final String BUNDLE_EXTRAS_CATEGORIES = "com.taboola.android.plus.notification.job.extras.categories";
    private static final String BUNDLE_EXTRAS_REFRESH_INTERVAL_MS = "com.taboola.android.plus.notification.job.extras.refreshIntervalMs";
    private static final String CATEGORIES_DELIMITER = ", ";
    private static final long REFRESH_JOB_MINIMUM_INTERVAL_MS = 900000L;

    static void schedulePeriodicRefresh(@NonNull Context context, @NonNull List<String> categories, long refreshIntervalMs) {
        Log.v((String)TAG, (String)("Scheduling periodic refreshNotification with categories: " + categories.toString() + " and interval: " + refreshIntervalMs));
        JobScheduler jobScheduler = (JobScheduler)context.getSystemService("jobscheduler");
        ComponentName componentName = new ComponentName(context, TBNotificationRefreshJob.class);
        long actualRefreshInterval = Math.max(900000L, refreshIntervalMs);
        JobInfo.Builder builder = new JobInfo.Builder(64879717, componentName);
        builder.setPeriodic(actualRefreshInterval);
        builder.setPersisted(true);
        PersistableBundle extras = new PersistableBundle();
        extras.putString(BUNDLE_EXTRAS_CATEGORIES, TextUtils.join((CharSequence)CATEGORIES_DELIMITER, categories));
        extras.putLong(BUNDLE_EXTRAS_REFRESH_INTERVAL_MS, refreshIntervalMs);
        builder.setExtras(extras);
        jobScheduler.schedule(builder.build());
    }

    static void cancelPeriodicRefresh(Context context) {
        Log.v((String)TAG, (String)"Canceling periodic refresh");
        JobScheduler jobScheduler = (JobScheduler)context.getSystemService("jobscheduler");
        jobScheduler.cancel(64879717);
    }

    public boolean onStartJob(final JobParameters params) {
        Log.d((String)TAG, (String)"onStartJob() called");
        final TaboolaPlus.TaboolaPlusRetrieveFailedCallback failedCallback = new TaboolaPlus.TaboolaPlusRetrieveFailedCallback(){

            @Override
            public void onTaboolaPlusRetrieveFailed(Throwable throwable) {
                Log.e((String)TAG, (String)("onStartJob: failed to update content : Taboola Plus restore failed : " + throwable.getMessage()));
                TBNotificationRefreshJob.this.jobFinished(params, false);
            }
        };
        BridgeInternal.restore(new TaboolaPlus.TaboolaPlusRetrievedCallback(){

            @Override
            public void onTaboolaPlusRetrieved(TaboolaPlus taboolaPlus) {
                if (!taboolaPlus.getNotificationManager().didRefreshIntervalPass()) {
                    Log.i((String)TAG, (String)"onStartJob: trying to refreshNotification content before refreshNotification interval have passed");
                    TBNotificationRefreshJob.this.jobFinished(params, false);
                    return;
                }
                taboolaPlus.getNotificationManager().dismissNotification();
                BridgeInternal.reInit(new TaboolaPlus.TaboolaPlusRetrievedCallback(){

                    @Override
                    public void onTaboolaPlusRetrieved(TaboolaPlus taboolaPlus) {
                        TBNotificationRefreshJob.this.onTaboolaPlusRetrieved(taboolaPlus, params);
                    }
                }, failedCallback);
            }
        }, failedCallback);
        return true;
    }

    private void onTaboolaPlusRetrieved(TaboolaPlus taboolaPlus, final JobParameters params) {
        final TBNotificationManager notificationManager = taboolaPlus.getNotificationManager();
        TBNotificationLocalStore localStore = notificationManager.getLocalStore();
        TBNotificationAnalyticsManager analyticsManager = notificationManager.getAnalyticsManager();
        NotificationConfig config = notificationManager.getNotificationConfig();
        TBNotificationManager.updateCurrentEngagementGroup(config, localStore, analyticsManager);
        NotificationConfig.SmartNotificationFrequency.EngagementGroup currentGroup = TBNotificationManager.getCurrentEngagementGroup(config, localStore.getCurrentEngagedGroupName());
        if (!notificationManager.didRefreshIntervalPass()) {
            Log.i((String)TAG, (String)"onStartJob: trying to refreshNotification content before refreshNotification interval have passed");
            this.onNotificationUpdateFinished(notificationManager, params);
            return;
        }
        if (ConditionCheckUtil.isTriggerPerDayMaxCountReached(currentGroup.getMaxNotificationTriggerCountPerDay(), localStore.getCountOfRenderedNotificationsToday())) {
            Log.i((String)TAG, (String)"initialNotificationRefresh: Notification is not shown because of max trigger times per day set in the config");
            this.onNotificationUpdateFinished(notificationManager, params);
            return;
        }
        if (!ConditionCheckUtil.didMinTriggerIntervalPass(localStore.getLastShownNotificationTimestamp(), currentGroup.getMinTriggerIntervalMs(), System.currentTimeMillis())) {
            Log.i((String)TAG, (String)"initialNotificationRefresh: Notification is not shown because of min trigger interval set in the config");
            this.onNotificationUpdateFinished(notificationManager, params);
            return;
        }
        if (ConditionCheckUtil.isBlockedByAllowedTimeWindows(currentGroup.getAllowedIntervals())) {
            Log.i((String)TAG, (String)"renderNotification: Notification is not shown because of allow time windows set in the config");
            this.onNotificationUpdateFinished(notificationManager, params);
            return;
        }
        if (!this.areNetworkRestrictionsMet(notificationManager)) {
            Log.i((String)TAG, (String)"No wifi connection");
            this.onNotificationUpdateFinished(notificationManager, params);
            return;
        }
        ConfigManager.CachedSdkConfigContainer cachedSdkConfig = ConfigManager.getCurrentSdkConfig(this.getApplicationContext());
        if (cachedSdkConfig != null && !TBDeviceInfoUtil.isDeviceSupported(cachedSdkConfig.getSdkPlusConfig().getNotificationConfig())) {
            Log.i((String)TAG, (String)"Notifications is blocked by config on the device");
            this.onNotificationUpdateFinished(notificationManager, params);
            analyticsManager.sendNotificationBlockedByConfig();
            return;
        }
        if (notificationManager.handleNotificationBlockByUser()) {
            Log.i((String)TAG, (String)"onStartJob: not refreshing notification: Notifications are blocked by user");
            this.onNotificationUpdateFinished(notificationManager, params);
            return;
        }
        if (cachedSdkConfig != null && KillSwitchUtil.isNotificationBlockedByFrequentCrashes(this.getApplicationContext(), cachedSdkConfig.getSdkPlusConfig().getNotificationConfig().getKillSwitchConfig().getFrequentCrashBlockConfig())) {
            Log.i((String)TAG, (String)"Notification is blocked by frequent unhandled exceptions");
            this.onNotificationUpdateFinished(notificationManager, params);
            return;
        }
        PersistableBundle extras = params.getExtras();
        String categoriesStr = extras.getString(BUNDLE_EXTRAS_CATEGORIES);
        ArrayList<String> categories = categoriesStr == null ? new ArrayList<String>() : new ArrayList<String>(Arrays.asList(categoriesStr.split(CATEGORIES_DELIMITER)));
        notificationManager.refreshNotification(categories, new NotificationRefreshCallback(){

            @Override
            public void onNotificationRefreshSuccessful() {
                Log.i((String)TAG, (String)"Notification content refreshed successfully!");
                TBNotificationRefreshJob.this.onNotificationUpdateFinished(notificationManager, params);
            }

            @Override
            public void onNotificationRefreshFailed(Throwable t) {
                Log.e((String)TAG, (String)("Failed to refresh Notification content with error: " + t.getMessage()));
                TBNotificationRefreshJob.this.onNotificationUpdateFinished(notificationManager, params);
            }
        });
    }

    private void onNotificationUpdateFinished(TBNotificationManager notificationManager, JobParameters params) {
        int newRefreshIntervalMs;
        PersistableBundle extras = params.getExtras();
        long currentRefreshIntervalMs = extras.getLong(BUNDLE_EXTRAS_REFRESH_INTERVAL_MS);
        if (currentRefreshIntervalMs != (long)(newRefreshIntervalMs = notificationManager.getNotificationConfig().getRefreshIntervalMs())) {
            Log.i((String)TAG, (String)"onNotificationUpdateFinished: notification RefreshInterval has changed. Rescheduling job");
            String categoriesStr = extras.getString(BUNDLE_EXTRAS_CATEGORIES);
            ArrayList<String> categories = new ArrayList<String>(Arrays.asList(categoriesStr.split(CATEGORIES_DELIMITER)));
            notificationManager.getBackgroundManager().schedulePeriodicRefresh(categories, newRefreshIntervalMs);
        }
        this.jobFinished(params, false);
    }

    public boolean onStopJob(JobParameters params) {
        Log.w((String)TAG, (String)"Job stopped by OS");
        return false;
    }

    private boolean areNetworkRestrictionsMet(TBNotificationManager tbNotificationManager) {
        Boolean isWifiOnlyMode = tbNotificationManager.getNotificationConfig().isWifiOnlyMode();
        if (isWifiOnlyMode == null) {
            isWifiOnlyMode = tbNotificationManager.getLocalStore().isWifiOnlyModeRuntimeFlag();
        }
        if (isWifiOnlyMode.booleanValue()) {
            return this.isWifiConnection(this.getApplicationContext());
        }
        return true;
    }

    static boolean isTaskRunning(@NonNull Context context) {
        JobScheduler scheduler = (JobScheduler)context.getSystemService("jobscheduler");
        boolean hasBeenScheduled = false;
        if (scheduler != null) {
            for (JobInfo jobInfo : scheduler.getAllPendingJobs()) {
                if (jobInfo.getId() != 64879717) continue;
                hasBeenScheduled = true;
                break;
            }
        }
        return hasBeenScheduled;
    }

    private boolean isWifiConnection(Context context) {
        ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
        if (cm != null) {
            NetworkInfo info = cm.getActiveNetworkInfo();
            return info != null && info.isConnected() && info.getType() == 1;
        }
        return false;
    }
}

