/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.plus.notification;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.taboola.android.plus.notification.KustoApiService;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

public class KustoApiClient {
    private static final String BASE_URL = "https://cdn.taboola.com";
    private static KustoApiService kustoApiService;

    public static KustoApiService getKustoApiService() {
        if (kustoApiService == null) {
            OkHttpClient client = new OkHttpClient.Builder().readTimeout(60L, TimeUnit.SECONDS).connectTimeout(60L, TimeUnit.SECONDS).addNetworkInterceptor(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Request request = chain.request().newBuilder().build();
                    return chain.proceed(request);
                }
            }).build();
            Gson gson = new GsonBuilder().setLenient().create();
            Retrofit retrofit = new Retrofit.Builder().baseUrl(BASE_URL).client(client).addConverterFactory((Converter.Factory)GsonConverterFactory.create((Gson)gson)).build();
            kustoApiService = (KustoApiService)retrofit.create(KustoApiService.class);
        }
        return kustoApiService;
    }
}

