/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.plus.content;

import android.content.Context;
import com.taboola.android.api.TBPlacement;
import com.taboola.android.plus.content.ContentConfig;
import com.taboola.android.plus.content.GetNewNotificationContentInteractor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class TBContentManager {
    private static final String TAG = TBContentManager.class.getSimpleName();
    private Context applicationContext;

    public TBContentManager(Context applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void getNotificationContent(ContentConfig contentConfig, String placement, List<String> categories, int numberOfItems, int imageWidth, int imageHeight, boolean isAvailable, final OnNotificationContentFetchedCallback callback) {
        new GetNewNotificationContentInteractor(this.applicationContext, contentConfig).execute(placement, categories, numberOfItems, imageWidth, imageHeight, isAvailable, new GetNewNotificationContentInteractor.GetNewNotificationContentCallback(){

            @Override
            public void onContentFetched(Map<String, List<TBPlacement>> content) {
                ArrayList<TBPlacement> allPlacements = new ArrayList<TBPlacement>();
                for (Map.Entry<String, List<TBPlacement>> entry : content.entrySet()) {
                    allPlacements.addAll((Collection<TBPlacement>)entry.getValue());
                }
                callback.onNotificationContentFetched(allPlacements);
            }

            @Override
            public void onContentFailed(Throwable throwable) {
                callback.onNotificationContentFailed(throwable);
            }
        });
    }

    public static interface OnNotificationContentFetchedCallback {
        public void onNotificationContentFetched(List<TBPlacement> var1);

        public void onNotificationContentFailed(Throwable var1);
    }
}

