/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.plus.content;

import android.content.Context;
import android.support.annotation.NonNull;
import android.util.Log;
import com.taboola.android.api.TBPlacement;
import com.taboola.android.api.TBRecommendationRequestCallback;
import com.taboola.android.api.TBRecommendationsResponse;
import com.taboola.android.plus.content.ContentConfig;
import com.taboola.android.plus.content.TBContentLocalStorage;
import com.taboola.android.plus.content.TBContentRemoteStorage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

class GetNewNotificationContentInteractor {
    private static final String TAG = GetNewNotificationContentInteractor.class.getSimpleName();
    private Context applicationContext;
    private ContentConfig contentConfig;
    private Map<String, List<TBPlacement>> newContent = new HashMap<String, List<TBPlacement>>();

    GetNewNotificationContentInteractor(Context applicationContext, ContentConfig contentConfig) {
        this.applicationContext = applicationContext;
        this.contentConfig = contentConfig;
    }

    void execute(String placement, List<String> categories, int numberOfItems, int imageWidth, int imageHeight, boolean isAvailable, final GetNewNotificationContentCallback callback) {
        ArrayList<String> categorizedPlacementNames = new ArrayList<String>();
        for (String categoryName : categories) {
            String categorizedPlacementName = this.contentConfig.getCategorizedPlacementName(placement, categoryName);
            if (categorizedPlacementName.isEmpty()) continue;
            categorizedPlacementNames.add(categorizedPlacementName);
        }
        if (categorizedPlacementNames.isEmpty()) {
            callback.onContentFailed(new Throwable("No categories selected"));
            Log.w((String)TAG, (String)"getNewContent: no valid categories were selected");
            return;
        }
        Map<String, List<String>> finalPlacementNames = GetNewNotificationContentInteractor.getFinalPlacementNames(categorizedPlacementNames, numberOfItems);
        new GetMultipleCategoriesInteractor(this.applicationContext).execute(finalPlacementNames.keySet(), numberOfItems, imageHeight, imageWidth, isAvailable, new GetMultipleCategoriesInteractor.GetMultipleCategoriesInteractorCallback(){

            @Override
            public void onContentFetched(Map<String, List<TBPlacement>> contentFromRemote) {
                GetNewNotificationContentInteractor.this.newContent.putAll(contentFromRemote);
                callback.onContentFetched(GetNewNotificationContentInteractor.this.newContent);
            }

            @Override
            public void onContentFailed(Throwable throwable) {
                callback.onContentFailed(throwable);
            }
        });
    }

    @NonNull
    private static Map<String, List<String>> getFinalPlacementNames(Collection<String> categorizedPlacementNames, int numberOfItems) {
        HashMap<String, List<String>> finalPlacementNames = new HashMap<String, List<String>>();
        for (String categorizedName : categorizedPlacementNames) {
            ArrayList<String> categoryPlacements = new ArrayList<String>(numberOfItems);
            for (int i = 0; i < numberOfItems; ++i) {
                categoryPlacements.add(categorizedName + " " + i);
            }
            finalPlacementNames.put(categorizedName, categoryPlacements);
        }
        return finalPlacementNames;
    }

    static class GetMultipleCategoriesInteractor {
        private Context applicationContext;
        private int requestsToComplete;
        private final Object resultLock = new Object();
        private volatile int completedRequests;
        private volatile Map<String, List<TBPlacement>> requestsResult;
        private volatile boolean hasFailed;

        GetMultipleCategoriesInteractor(Context applicationContext) {
            this.applicationContext = applicationContext;
        }

        void execute(Set<String> categories, int numberOfItems, int imageHeight, int imageWidth, boolean isAvailable, final GetMultipleCategoriesInteractorCallback callback) {
            this.requestsToComplete = categories.size();
            this.completedRequests = 0;
            this.requestsResult = new HashMap<String, List<TBPlacement>>();
            this.hasFailed = false;
            Map finalPlacementNames = GetNewNotificationContentInteractor.getFinalPlacementNames(categories, numberOfItems);
            for (Map.Entry entry : finalPlacementNames.entrySet()) {
                final String categoryName = (String)entry.getKey();
                TBContentRemoteStorage.getNewContent(this.applicationContext, (List)entry.getValue(), 1, imageHeight, imageWidth, isAvailable, new TBRecommendationRequestCallback(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void onRecommendationsFetched(TBRecommendationsResponse response) {
                        Map placementsMap = response.getPlacementsMap();
                        TBContentLocalStorage.cacheContent(GetMultipleCategoriesInteractor.this.applicationContext, placementsMap);
                        ArrayList placementsList = new ArrayList();
                        for (Map.Entry entry1 : placementsMap.entrySet()) {
                            placementsList.add(entry1.getValue());
                        }
                        Object object = GetMultipleCategoriesInteractor.this.resultLock;
                        synchronized (object) {
                            GetMultipleCategoriesInteractor.this.requestsResult.put(categoryName, placementsList);
                            GetMultipleCategoriesInteractor.this.completedRequests++;
                            if (GetMultipleCategoriesInteractor.this.completedRequests == GetMultipleCategoriesInteractor.this.requestsToComplete && !GetMultipleCategoriesInteractor.this.hasFailed) {
                                callback.onContentFetched(GetMultipleCategoriesInteractor.this.requestsResult);
                            }
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void onRecommendationsFailed(Throwable throwable) {
                        Object object = GetMultipleCategoriesInteractor.this.resultLock;
                        synchronized (object) {
                            if (!GetMultipleCategoriesInteractor.this.hasFailed) {
                                GetMultipleCategoriesInteractor.this.hasFailed = true;
                                callback.onContentFailed(throwable);
                            }
                            Log.e((String)TAG, (String)"onContentFailed: ", (Throwable)throwable);
                        }
                    }
                });
            }
        }

        static interface GetMultipleCategoriesInteractorCallback {
            public void onContentFetched(Map<String, List<TBPlacement>> var1);

            public void onContentFailed(Throwable var1);
        }
    }

    static interface GetNewNotificationContentCallback {
        public void onContentFetched(Map<String, List<TBPlacement>> var1);

        public void onContentFailed(Throwable var1);
    }
}

