/*
 * Decompiled with CFR 0.152.
 */
package com.ocamba.hoood.notifications;

import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Color;
import android.media.AudioAttributes;
import android.media.RingtoneManager;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.os.SystemClock;
import android.support.annotation.Nullable;
import android.support.v4.app.NotificationCompat;
import android.support.v4.app.NotificationManagerCompat;
import android.support.v4.media.app.NotificationCompat;
import android.text.TextUtils;
import android.widget.RemoteViews;
import com.ocamba.hoood.OcambaHoood;
import com.ocamba.hoood.OcambaNotificationParser;
import com.ocamba.hoood.OcambaPrefManager;
import com.ocamba.hoood.OcambaRequest;
import com.ocamba.hoood.R;
import com.ocamba.hoood.images.OcambaImageHelper;
import com.ocamba.hoood.notifications.OcambaNotificationActions;
import com.ocamba.hoood.notifications.OcambaNotificationObject;
import com.ocamba.hoood.util.OcambaLogUtils;
import com.ocamba.hoood.util.OcambaUtils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Random;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class OcambaNotificationRenderer {
    public static final String TAG = OcambaNotificationRenderer.class.getSimpleName();
    private Context mApplicationContext;
    private NotificationManager mNotificationManager;
    private Bitmap mIconBitmap;
    private Bitmap mImageBitmap;
    private String sPackageName;
    private Resources sResources;
    private int mMultiMessageCount;

    public OcambaNotificationRenderer(Context context) {
        this.mApplicationContext = context;
        if (this.mApplicationContext != null) {
            this.sResources = this.mApplicationContext.getResources();
            this.sPackageName = OcambaUtils.getAppPackageName(this.mApplicationContext);
        }
    }

    private void buildNotification(NotificationCompat.Builder builder, int notificationId, OcambaNotificationObject ocambaNotificationObject, boolean isMultiMessage) {
        OcambaLogUtils.d(TAG, "buildNotification() [" + isMultiMessage + "]");
        if (this.mApplicationContext != null) {
            this.mNotificationManager = (NotificationManager)this.mApplicationContext.getSystemService("notification");
            if (!isMultiMessage) {
                this.cancel(ocambaNotificationObject, notificationId);
            }
            this.mNotificationManager.notify(notificationId, builder.build());
        }
    }

    public void createMultiMessageNotification(JSONObject jsonObject, OcambaNotificationObject firstNotificationObject, int multiMessageCount) {
        OcambaLogUtils.d(TAG, "createMultiMessageNotification() called with: jsonObject = [" + jsonObject + "]");
        if (!jsonObject.has("p")) {
            OcambaLogUtils.e("JSON doesn't have [p] object!");
            return;
        }
        try {
            this.mMultiMessageCount = multiMessageCount;
            this.renderMultiMessageNotification(this.createNotificationExtrasBundleFromJson(jsonObject), firstNotificationObject, 0);
        }
        catch (JSONException e) {
            e.printStackTrace();
            OcambaRequest.postCrash(e.getMessage());
            OcambaLogUtils.e(TAG, e.getMessage());
        }
    }

    public void renderSingleNotification(OcambaNotificationObject ocambaNotificationObject, boolean isMulti) {
        OcambaLogUtils.d(TAG, "renderSingleNotification() called with: ocambaNotificationObject = [" + ocambaNotificationObject + "]");
        if (!OcambaHoood.notification().isCustomLayout()) {
            int notificationId = ocambaNotificationObject.getNotificationId();
            this.buildNotification(this.notificationBuilder(notificationId, ocambaNotificationObject), notificationId, ocambaNotificationObject, isMulti);
        }
    }

    public void renderMultiMessageNotification(Bundle notificationExtras, int position) {
        this.renderMultiMessageNotification(notificationExtras, null, position);
    }

    private void renderMultiMessageNotification(Bundle notificationExtras, OcambaNotificationObject firstNotificationObject, int position) {
        OcambaLogUtils.d(TAG, "renderMultiMessageNotification() called with: position = [" + position + "]");
        try {
            if (this.mApplicationContext == null) {
                return;
            }
            OcambaNotificationObject ocambaNotificationObject = firstNotificationObject == null ? this.createNotificationObjectFromBundle(notificationExtras, position) : firstNotificationObject;
            NotificationCompat.Builder notificationBuilder = new NotificationCompat.Builder(this.mApplicationContext, this.createNotificationChannel(ocambaNotificationObject)).setAutoCancel(true);
            if (ocambaNotificationObject == null) {
                OcambaLogUtils.e("OcambaNotificationObject not created!");
                return;
            }
            int notificationId = this.getNotificationId(notificationExtras);
            notificationBuilder.setContentIntent(this.getIntentClickAction(0, ocambaNotificationObject));
            notificationBuilder.setDeleteIntent(this.getIntentDeleteAction(notificationId));
            notificationBuilder.setSmallIcon(this.getSmallIcon());
            notificationBuilder.setContentTitle((CharSequence)ocambaNotificationObject.getTitle());
            notificationBuilder.setContentText((CharSequence)ocambaNotificationObject.getDescription());
            notificationBuilder.setColor(this.getTextColor(ocambaNotificationObject.getAppNameColor(), "ocamba_nc_name_color"));
            this.setStyle(ocambaNotificationObject, notificationExtras, notificationBuilder);
            this.buildNotification(notificationBuilder, notificationId, ocambaNotificationObject, true);
        }
        catch (JSONException e) {
            OcambaLogUtils.e(e.getMessage());
            e.printStackTrace();
            OcambaRequest.postCrash(e.toString());
        }
    }

    private OcambaNotificationObject createNotificationObjectFromBundle(Bundle notificationExtras, int position) throws JSONException {
        JSONObject object = new JSONObject(notificationExtras.getString("ocamba_m_m_extras"));
        JSONArray array = object.getJSONArray("p");
        this.mMultiMessageCount = array.length();
        return OcambaNotificationParser.createNotificationObject("p", array.getJSONObject(position));
    }

    private Bundle createNotificationExtrasBundleFromJson(JSONObject jsonObject) throws JSONException {
        Bundle notificationExtras = new Bundle();
        notificationExtras.putInt("ocamba_m_m_index", 0);
        notificationExtras.putString("ocamba_m_m_extras", jsonObject != null ? jsonObject.toString() : "");
        notificationExtras.putInt(".OCAMBA_NOTIFICATION_ID", this.getNotificationId(notificationExtras));
        if (jsonObject != null) {
            this.fetchImages(jsonObject.getJSONArray("p"));
        }
        return notificationExtras;
    }

    private void fetchImages(JSONArray array) throws JSONException {
        for (int i = 0; i < array.length(); ++i) {
            JSONObject o;
            JSONObject object = array.getJSONObject(i);
            if (!object.has("o") || !(o = object.getJSONObject("o")).has("image")) continue;
            OcambaHoood.getOcambaLruImageLoader().getBitmapFromUrl(this.mApplicationContext, o.getString("image"), OcambaImageHelper.MAIN);
        }
    }

    private void setStyle(OcambaNotificationObject notificationObject, Bundle notificationExtras, NotificationCompat.Builder notificationBuilder) {
        if (!notificationObject.getStyle().equals("") && OcambaUtils.hasMediaSessionCompat()) {
            this.setMultiMessageMediaStyle(notificationObject, notificationExtras, notificationBuilder);
        } else {
            notificationBuilder.setStyle((NotificationCompat.Style)this.setMultiMessageStyle(notificationObject, notificationExtras, notificationBuilder));
        }
    }

    private NotificationCompat.DecoratedCustomViewStyle setMultiMessageStyle(OcambaNotificationObject notificationObject, Bundle notificationExtras, NotificationCompat.Builder notificationBuilder) {
        NotificationCompat.DecoratedCustomViewStyle style = new NotificationCompat.DecoratedCustomViewStyle();
        if (this.mApplicationContext != null) {
            int messageIndex = this.getMultiMessageIndex(notificationExtras);
            RemoteViews expandedView = this.createMultiMessageExpandedView(this.mApplicationContext, notificationObject);
            this.setExpandedMultiMessageContent(expandedView, notificationObject, this.getImage(notificationObject.getImage()));
            PendingIntent previousMessagePendingIntent = this.getPendingIntentForMultiMessageAction(this.mApplicationContext, notificationExtras, (messageIndex - 1 + this.mMultiMessageCount) % this.mMultiMessageCount, 1);
            expandedView.setOnClickPendingIntent(R.id.previous_message, previousMessagePendingIntent);
            PendingIntent nextMessagePendingIntent = this.getPendingIntentForMultiMessageAction(this.mApplicationContext, notificationExtras, (messageIndex + 1) % this.mMultiMessageCount, 2);
            expandedView.setOnClickPendingIntent(R.id.next_message, nextMessagePendingIntent);
            notificationBuilder.setCustomBigContentView(expandedView);
            this.setLargeIconIfSupported(this.mApplicationContext, notificationBuilder, notificationObject);
            notificationBuilder.setOnlyAlertOnce(true);
            notificationBuilder.setSound(this.getSound(notificationObject));
            notificationBuilder.setVibrate(this.getVibration(notificationObject));
            this.setMultiMessageArrows(expandedView, notificationObject);
        }
        return style;
    }

    private void setLargeIconIfSupported(Context context, NotificationCompat.Builder notificationBuilder, OcambaNotificationObject notificationObject) {
        if (context != null) {
            RemoteViews collapsedView = this.createMultiMessageCollapsedView(context, notificationObject);
            this.setExpandedMultiMessageContent(collapsedView, notificationObject, this.getIcon(notificationObject.getIcon()));
            this.setMultiMessageIndicatorIcon(collapsedView, notificationObject);
            notificationBuilder.setCustomContentView(collapsedView);
        }
    }

    private void setMultiMessageArrows(RemoteViews remoteViews, OcambaNotificationObject ocambaNotificationObject) {
        try {
            if (ocambaNotificationObject.isLocalResource(ocambaNotificationObject.getMultiMessagePrevious())) {
                remoteViews.setImageViewResource(R.id.previous_message, this.getLocalResource(ocambaNotificationObject.getMultiMessagePrevious(), "drawable"));
            } else {
                Bitmap arrowPreviousBitmap = this.getBitmap(ocambaNotificationObject.getMultiMessagePrevious(), OcambaImageHelper.ICON, false);
                if (arrowPreviousBitmap != null) {
                    remoteViews.setImageViewBitmap(R.id.previous_message, arrowPreviousBitmap);
                } else {
                    remoteViews.setImageViewResource(R.id.previous_message, this.getLocalResource("ocamba_multimessage_arrow_previous", "drawable"));
                }
            }
            if (ocambaNotificationObject.isLocalResource(ocambaNotificationObject.getMultiMessageNext())) {
                remoteViews.setImageViewResource(R.id.next_message, this.getLocalResource(ocambaNotificationObject.getMultiMessageNext(), "drawable"));
            } else {
                Bitmap arrowNextBitmap = this.getBitmap(ocambaNotificationObject.getMultiMessageNext(), OcambaImageHelper.ICON, false);
                if (arrowNextBitmap != null) {
                    remoteViews.setImageViewBitmap(R.id.next_message, arrowNextBitmap);
                } else {
                    remoteViews.setImageViewResource(R.id.next_message, this.getLocalResource("ocamba_multimessage_arrow_next", "drawable"));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setMultiMessageIndicatorIcon(RemoteViews remoteViews, OcambaNotificationObject ocambaNotificationObject) {
        if (ocambaNotificationObject.isLocalResource(ocambaNotificationObject.getMultiMessageIndicator())) {
            remoteViews.setImageViewResource(R.id.mm_icon, this.getLocalResource(ocambaNotificationObject.getMultiMessageIndicator(), "drawable"));
        } else {
            Bitmap multiMessageIndicatorBitmap = this.getBitmap(ocambaNotificationObject.getMultiMessageIndicator(), OcambaImageHelper.ICON, false);
            if (multiMessageIndicatorBitmap != null) {
                remoteViews.setImageViewBitmap(R.id.mm_icon, multiMessageIndicatorBitmap);
            } else {
                remoteViews.setImageViewResource(R.id.mm_icon, this.getLocalResource("ocamba_multimessage_indicator", "drawable"));
            }
        }
    }

    private int getMultiMessageIndex(Bundle notificationExtras) {
        if (!notificationExtras.containsKey("ocamba_m_m_index")) {
            return 0;
        }
        return notificationExtras.getInt("ocamba_m_m_index");
    }

    private void setExpandedMultiMessageContent(RemoteViews multiMessageView, OcambaNotificationObject notificationObject, Bitmap b) {
        String title = notificationObject.getTitle();
        String description = notificationObject.getDescription();
        multiMessageView.setTextViewText(R.id.message_title, (CharSequence)title);
        this.setTextColor(multiMessageView, R.id.message_title, notificationObject.getTitleColor(), "ocamba_nc_title_color");
        multiMessageView.setTextViewText(R.id.message_subtitle, (CharSequence)description);
        this.setTextColor(multiMessageView, R.id.message_subtitle, notificationObject.getDescriptionColor(), "ocamba_nc_text_color");
        if (b == null) {
            multiMessageView.setImageViewResource(R.id.message_big_icon, R.drawable.placeholder);
        } else {
            multiMessageView.setImageViewBitmap(R.id.message_big_icon, b);
        }
    }

    private void setMultiMessageMediaStyle(OcambaNotificationObject notificationObject, Bundle notificationExtras, NotificationCompat.Builder notificationBuilder) {
        int messageIndex = this.getMultiMessageIndex(notificationExtras);
        if (this.mApplicationContext != null) {
            PendingIntent previousMessagePendingIntent = this.getPendingIntentForMultiMessageAction(this.mApplicationContext, notificationExtras, (messageIndex - 1 + this.mMultiMessageCount) % this.mMultiMessageCount, 1);
            PendingIntent nextMessagePendingIntent = this.getPendingIntentForMultiMessageAction(this.mApplicationContext, notificationExtras, (messageIndex + 1) % this.mMultiMessageCount, 2);
            notificationBuilder.setVisibility(1);
            notificationBuilder.addAction(R.drawable.ocamba_multimessage_arrow_previous, (CharSequence)this.mApplicationContext.getString(R.string.ocamba_nc_media_previous), previousMessagePendingIntent);
            notificationBuilder.addAction(R.drawable.ocamba_multimessage_arrow_next, (CharSequence)this.mApplicationContext.getString(R.string.ocamba_nc_media_next), nextMessagePendingIntent);
            notificationBuilder.setStyle((NotificationCompat.Style)new NotificationCompat.MediaStyle().setShowActionsInCompactView(new int[]{0, 1}).setMediaSession(OcambaHoood.getMediaSessionCompat().getSessionToken()));
            notificationBuilder.setLargeIcon(this.getImage(notificationObject.getImage()));
            notificationBuilder.setOnlyAlertOnce(true);
            notificationBuilder.setSound(this.getSound(notificationObject));
            notificationBuilder.setVibrate(this.getVibration(notificationObject));
        }
    }

    private NotificationCompat.Builder notificationBuilder(int notificationId, OcambaNotificationObject ocambaNotificationObject) {
        OcambaLogUtils.d(TAG, "buildNotification() notificationId: " + notificationId);
        RemoteViews collapsedView = this.buildCollapsedView(ocambaNotificationObject);
        RemoteViews expandedView = this.buildExpandedView(ocambaNotificationObject);
        this.colorNotificationIfNeed(collapsedView, expandedView);
        PendingIntent clickIntent = this.getIntentClickAction(notificationId, ocambaNotificationObject);
        PendingIntent deleteIntent = this.getIntentDeleteAction(notificationId);
        NotificationCompat.Builder notification = new NotificationCompat.Builder(this.mApplicationContext, this.createNotificationChannel(ocambaNotificationObject)).setStyle((NotificationCompat.Style)new NotificationCompat.DecoratedCustomViewStyle()).setContentTitle((CharSequence)ocambaNotificationObject.getTitle()).setSmallIcon(this.getSmallIcon()).setAutoCancel(true).setColor(this.getTextColor(ocambaNotificationObject.getAppNameColor(), "ocamba_nc_name_color")).setCustomContentView(collapsedView).setCustomBigContentView(expandedView).setContentIntent(clickIntent).setDeleteIntent(deleteIntent).setOnlyAlertOnce(true).setSound(this.getSound(ocambaNotificationObject)).setVibrate(this.getVibration(ocambaNotificationObject));
        if (ocambaNotificationObject.getActions().length() > 0) {
            try {
                JSONArray actions = new JSONArray(ocambaNotificationObject.getActions());
                for (int i = 0; i < actions.length(); ++i) {
                    String title = actions.getJSONObject(i).has("title") ? actions.getJSONObject(i).getString("title") : "";
                    String action = actions.getJSONObject(i).has("action") ? actions.getJSONObject(i).getString("action") : "";
                    String url = actions.getJSONObject(i).has("url") ? actions.getJSONObject(i).getString("url") : "";
                    notification.addAction(R.drawable.ic_notification_small, (CharSequence)title, this.getPendingIntentForButtonClickAction(notificationId, i, ocambaNotificationObject, action, url));
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        return notification;
    }

    public void createCustomUserNotification(RemoteViews collapsedView, RemoteViews expandedView, OcambaNotificationObject ocambaNotificationObject) {
        OcambaLogUtils.d(TAG, "createCustomUserNotification()");
        int notificationId = ocambaNotificationObject.getNotificationId();
        PendingIntent clickIntent = this.getIntentClickAction(notificationId, ocambaNotificationObject);
        PendingIntent deleteIntent = this.getIntentDeleteAction(notificationId);
        NotificationCompat.Builder builder = new NotificationCompat.Builder(this.mApplicationContext, this.createNotificationChannel(ocambaNotificationObject)).setSmallIcon(this.getSmallIcon()).setStyle((NotificationCompat.Style)new NotificationCompat.DecoratedCustomViewStyle()).setContentTitle((CharSequence)ocambaNotificationObject.getTitle()).setContentIntent(clickIntent).setDeleteIntent(deleteIntent).setAutoCancel(true).setCustomContentView(collapsedView).setOnlyAlertOnce(true).setCustomBigContentView(expandedView).setSound(this.getSound(ocambaNotificationObject)).setVibrate(this.getVibration(ocambaNotificationObject));
        this.buildNotification(builder, notificationId, ocambaNotificationObject, false);
    }

    private RemoteViews buildCollapsedView(OcambaNotificationObject ocambaNotificationObject) {
        OcambaLogUtils.d(TAG, "buildCollapsedView()");
        RemoteViews collapsedLayout = this.createSingleMessageCollapsedView(ocambaNotificationObject);
        if (ocambaNotificationObject.getIcon().length() > 0) {
            collapsedLayout.setImageViewBitmap(R.id.nc_icon, this.getIcon(ocambaNotificationObject.getIcon()));
        } else {
            collapsedLayout.setViewVisibility(R.id.nc_icon, 8);
        }
        if (ocambaNotificationObject.getTitle().length() > 0) {
            this.setTextColor(collapsedLayout, R.id.nc_title, ocambaNotificationObject.getTitleColor(), "ocamba_nc_title_color");
            collapsedLayout.setTextViewText(R.id.nc_title, (CharSequence)ocambaNotificationObject.getTitle());
        } else {
            collapsedLayout.setViewVisibility(R.id.nc_title, 8);
        }
        if (ocambaNotificationObject.getDescription().length() > 0) {
            this.setTextColor(collapsedLayout, R.id.nc_text, ocambaNotificationObject.getDescriptionColor(), "ocamba_nc_text_color");
            collapsedLayout.setTextViewText(R.id.nc_text, (CharSequence)ocambaNotificationObject.getDescription());
        } else {
            collapsedLayout.setViewVisibility(R.id.nc_text, 8);
        }
        return collapsedLayout;
    }

    private RemoteViews buildExpandedView(OcambaNotificationObject ocambaNotificationObject) {
        OcambaLogUtils.d(TAG, "buildExpandedView()");
        RemoteViews expandedLayout = this.createSingleMessageExpandView(ocambaNotificationObject);
        if (ocambaNotificationObject.getIcon().length() > 0) {
            expandedLayout.setImageViewBitmap(R.id.nc_icon, this.getIcon(ocambaNotificationObject.getIcon()));
        } else {
            expandedLayout.setViewVisibility(R.id.nc_icon, 8);
        }
        if (ocambaNotificationObject.getTitle().length() > 0) {
            this.setTextColor(expandedLayout, R.id.nc_title, ocambaNotificationObject.getTitleColor(), "ocamba_nc_title_color");
            expandedLayout.setTextViewText(R.id.nc_title, (CharSequence)ocambaNotificationObject.getTitle());
        } else {
            expandedLayout.setViewVisibility(R.id.nc_title, 8);
        }
        if (ocambaNotificationObject.getDescription().length() > 0) {
            this.setTextColor(expandedLayout, R.id.nc_text, ocambaNotificationObject.getDescriptionColor(), "ocamba_nc_text_color");
            expandedLayout.setTextViewText(R.id.nc_text, (CharSequence)ocambaNotificationObject.getDescription());
        } else {
            expandedLayout.setViewVisibility(R.id.nc_text, 8);
        }
        if (ocambaNotificationObject.getImage().length() > 0) {
            expandedLayout.setImageViewBitmap(R.id.nc_banner, this.getImage(ocambaNotificationObject.getImage()));
        } else {
            expandedLayout.setViewVisibility(R.id.nc_banner, 8);
        }
        return expandedLayout;
    }

    private RemoteViews createMultiMessageCollapsedView(Context context, OcambaNotificationObject notificationObject) {
        int layoutType = notificationObject.getCLayout();
        int collapsedLayoutId = layoutType == 1 ? R.layout.multi_notify_collapsed_1 : (layoutType == 2 ? R.layout.multi_notify_collapsed_2 : R.layout.multi_notify_collapsed_0);
        return new RemoteViews(context.getPackageName(), collapsedLayoutId);
    }

    private RemoteViews createMultiMessageExpandedView(Context context, OcambaNotificationObject notificationObject) {
        int layoutType = notificationObject.getELayout();
        int expandedLayoutId = layoutType == 1 ? R.layout.multi_notify_expanded_1 : (layoutType == 2 ? R.layout.multi_notify_expanded_2 : R.layout.multi_notify_expanded_0);
        return new RemoteViews(context.getPackageName(), expandedLayoutId);
    }

    private RemoteViews createSingleMessageCollapsedView(OcambaNotificationObject ocambaNotificationObject) {
        int layoutType = ocambaNotificationObject.getCLayout();
        int collapsedLayoutId = layoutType == 1 ? R.layout.single_notify_collapsed_1 : (layoutType == 2 ? R.layout.single_notify_collapsed_2 : R.layout.single_notify_collapsed_0);
        return new RemoteViews(this.sPackageName, collapsedLayoutId);
    }

    private RemoteViews createSingleMessageExpandView(OcambaNotificationObject ocambaNotificationObject) {
        int layoutType = ocambaNotificationObject.getELayout();
        int expandedLayoutId = layoutType == 1 ? R.layout.single_notify_expanded_1 : (layoutType == 2 ? R.layout.single_notify_expanded_2 : (layoutType == 3 ? R.layout.single_notify_expanded_3 : R.layout.single_notify_expanded_0));
        return new RemoteViews(this.sPackageName, expandedLayoutId);
    }

    private String createNotificationChannel(OcambaNotificationObject ocambaNotificationObject) {
        OcambaLogUtils.d(TAG, "createNotificationChannel()");
        if (this.mApplicationContext != null) {
            if (Build.VERSION.SDK_INT >= 26) {
                boolean isSilent = ocambaNotificationObject.getSilent() == 1;
                NotificationManager manager = (NotificationManager)this.mApplicationContext.getSystemService(NotificationManager.class);
                NotificationChannel channel = manager.getNotificationChannel(isSilent ? this.sPackageName + ".ocamba.notification.channel.id.silent" : this.sPackageName + ".ocamba.notification.channel.id");
                if (channel != null) {
                    return channel.getId();
                }
                channel = new NotificationChannel(isSilent ? this.sPackageName + ".ocamba.notification.channel.id.silent" : this.sPackageName + ".ocamba.notification.channel.id", (CharSequence)(isSilent ? "Ocamba Push Silent" : "Ocamba Push"), 3);
                channel.setDescription(isSilent ? "Ocamba push notification silent channel" : "Ocamba push notification channel");
                AudioAttributes attributes = new AudioAttributes.Builder().setUsage(5).build();
                channel.enableVibration(!isSilent);
                channel.setVibrationPattern(this.getVibration(ocambaNotificationObject));
                channel.setSound(this.getSound(ocambaNotificationObject), attributes);
                channel.setShowBadge(!OcambaHoood.getBuilder().isBadgeDisabled());
                NotificationManager notificationManager = (NotificationManager)this.mApplicationContext.getSystemService(NotificationManager.class);
                notificationManager.createNotificationChannel(channel);
                return channel.getId();
            }
            return this.sPackageName + ".ocamba.notification.channel.id";
        }
        return ".ocamba.notification.channel.id";
    }

    private void colorNotificationIfNeed(RemoteViews collapseView, RemoteViews expandedView) {
        OcambaLogUtils.d(TAG, "colorNotificationIfNeed()");
        if (Build.VERSION.SDK_INT <= 21) {
            collapseView.setTextColor(R.id.nc_title, this.sResources.getColor(R.color.nc_color_title));
            collapseView.setTextColor(R.id.nc_text, this.sResources.getColor(R.color.nc_color_text));
            expandedView.setTextColor(R.id.nc_title, this.sResources.getColor(R.color.nc_color_title));
            expandedView.setTextColor(R.id.nc_text, this.sResources.getColor(R.color.nc_color_text));
        }
    }

    private PendingIntent getIntentClickAction(int notificationId, OcambaNotificationObject notificationObject) {
        OcambaLogUtils.d(TAG, "getIntentClickAction()");
        if (this.mApplicationContext != null) {
            Intent clickIntent = new Intent(this.mApplicationContext, OcambaNotificationActions.class);
            clickIntent.setAction(OcambaUtils.getPackage(this.mApplicationContext) + ".OCAMBA_NOTIFICATION_ACTION_CLICK");
            clickIntent.putExtra("ocamba_object", (Parcelable)notificationObject);
            return PendingIntent.getBroadcast((Context)this.mApplicationContext, (int)(notificationId == 0 ? new Random().nextInt() : notificationId), (Intent)clickIntent, (int)0);
        }
        return null;
    }

    private PendingIntent getPendingIntentForButtonClickAction(int notificationId, int index, OcambaNotificationObject ocambaNotificationObject, String singleAction, String url) {
        OcambaLogUtils.d(TAG, "getPendingIntentForButtonClickAction() called with: notificationId = [" + notificationId + "], index = [" + index + "], singleAction = [" + singleAction + "], url = [" + url + "]");
        if (this.mApplicationContext != null) {
            Intent clickIntent = new Intent(this.mApplicationContext, OcambaNotificationActions.class);
            String action = index == 0 ? ".OCAMBA_NOTIFICATION_BUTTON_ACTION_YES" : (index == 1 ? ".OCAMBA_NOTIFICATION_BUTTON_ACTION_NO" : ".OCAMBA_NOTIFICATION_BUTTON_ACTION_CUSTOM");
            clickIntent.setAction(OcambaUtils.getPackage(this.mApplicationContext) + action);
            clickIntent.putExtra(".OCAMBA_NOTIFICATION_ID", notificationId);
            if (index == 0) {
                clickIntent.putExtra("ocamba_object", (Parcelable)ocambaNotificationObject);
            }
            clickIntent.putExtra("actions", singleAction);
            clickIntent.putExtra("url", url);
            return PendingIntent.getBroadcast((Context)this.mApplicationContext, (int)notificationId, (Intent)clickIntent, (int)0);
        }
        return null;
    }

    private PendingIntent getIntentDeleteAction(int notificationId) {
        OcambaLogUtils.d(TAG, "getIntentDeleteAction()");
        if (this.mApplicationContext != null) {
            Intent clickIntent = new Intent(this.mApplicationContext, OcambaNotificationActions.class);
            clickIntent.setAction(OcambaUtils.getPackage(this.mApplicationContext) + ".OCAMBA_NOTIFICATION_ACTION_DELETE");
            return PendingIntent.getBroadcast((Context)this.mApplicationContext, (int)notificationId, (Intent)clickIntent, (int)0);
        }
        return null;
    }

    private PendingIntent getPendingIntentForMultiMessageAction(Context context, Bundle extras, int page, int direction) {
        if (this.mApplicationContext != null) {
            Intent clickIntent = new Intent(OcambaUtils.getPackage(this.mApplicationContext) + ".OCAMBA_NOTIFICATION_ACTION_MULTI_MESSAGE").setClass(context, OcambaNotificationActions.class);
            extras.putInt("ocamba_m_m_direction", direction);
            extras.putInt("ocamba_m_m_index", page);
            clickIntent.putExtra("ocamba_m_m_extras", extras);
            return PendingIntent.getBroadcast((Context)context, (int)new Random().nextInt(), (Intent)clickIntent, (int)0x40000000);
        }
        return null;
    }

    private int getNotificationId(Bundle notificationExtras) {
        if (notificationExtras.containsKey(".OCAMBA_NOTIFICATION_ID")) {
            return notificationExtras.getInt(".OCAMBA_NOTIFICATION_ID");
        }
        return (int)SystemClock.uptimeMillis();
    }

    private Uri getSound(OcambaNotificationObject ocambaNotificationObject) {
        if (ocambaNotificationObject.getSilent() == 1) {
            return null;
        }
        int soundResource = this.getLocalResource(ocambaNotificationObject.getSound(), "raw");
        if (soundResource == 0) {
            return RingtoneManager.getDefaultUri((int)2);
        }
        return Uri.parse((String)("android.resource://" + this.sPackageName + "/" + soundResource));
    }

    private long[] getVibration(OcambaNotificationObject ocambaNotificationObject) {
        if (ocambaNotificationObject.getSilent() == 0) {
            return ocambaNotificationObject.getVibration();
        }
        return null;
    }

    private Bitmap getIcon(String icon) {
        if (this.mApplicationContext != null) {
            if (this.mIconBitmap != null) {
                return this.mIconBitmap;
            }
            this.mIconBitmap = this.getBitmap(icon, OcambaImageHelper.ICON);
            return this.mIconBitmap;
        }
        return null;
    }

    private Bitmap getImage(String image) {
        if (this.mApplicationContext != null) {
            if (this.mImageBitmap != null) {
                return this.mImageBitmap;
            }
            this.mImageBitmap = this.getBitmap(image, OcambaImageHelper.MAIN);
            return this.mImageBitmap;
        }
        return null;
    }

    private Bitmap getBitmap(String url, int type) {
        return this.getBitmap(url, type, true);
    }

    private Bitmap getBitmap(String url, int type, boolean returnPlaceholder) {
        if (this.mApplicationContext == null || url.equals("")) {
            return null;
        }
        Bitmap bitmap = OcambaHoood.getOcambaLruImageLoader().getBitmapFromUrl(this.mApplicationContext, url, type);
        return bitmap != null ? bitmap : (returnPlaceholder ? BitmapFactory.decodeResource((Resources)this.mApplicationContext.getResources(), (int)R.drawable.placeholder) : null);
    }

    private void setTextColor(RemoteViews customView, int viewId, String customColorHex, String defaultColorResourceName) {
        if (customColorHex.equals("") || customColorHex.length() == 0 || !customColorHex.startsWith("#")) {
            int colorId = this.sResources.getIdentifier(defaultColorResourceName, "color", this.sPackageName);
            if (colorId != 0) {
                customView.setTextColor(viewId, this.sResources.getColor(colorId));
            }
        } else {
            customView.setTextColor(viewId, Color.parseColor((String)customColorHex));
        }
    }

    private int getTextColor(String customColorHex, String defaultColorResourceName) {
        if (customColorHex.equals("") || customColorHex.length() == 0 || !customColorHex.startsWith("#")) {
            int colorId = this.sResources.getIdentifier(defaultColorResourceName, "color", this.sPackageName);
            if (colorId != 0) {
                return this.sResources.getColor(colorId);
            }
        } else {
            return Color.parseColor((String)customColorHex);
        }
        return 0;
    }

    private int getSmallIcon() {
        return this.getLocalResource("ocamba_nc_icon", "drawable");
    }

    private int getLocalResource(String name, String identifier) {
        int resource = this.sResources.getIdentifier(name, identifier, this.sPackageName);
        if (resource == 0 && !identifier.equals("raw")) {
            if (name.startsWith("ocamba_multimessage_indicator")) {
                resource = R.drawable.ocamba_multimessage_indicator;
            } else if (name.startsWith("ocamba_multimessage_arrow_next")) {
                resource = R.drawable.ocamba_multimessage_arrow_next;
            } else if (name.startsWith("ocamba_multimessage_arrow_previous")) {
                resource = R.drawable.ocamba_multimessage_arrow_previous;
            } else if (name.startsWith("ocamba_nc_icon")) {
                resource = this.getLocalResource("ic_launcher_background", "drawable");
            } else if (name.startsWith("ic_launcher_background")) {
                resource = R.drawable.ic_notification_small;
            }
        }
        return resource;
    }

    private void cancel(OcambaNotificationObject ocambaNotificationObject, int notificationId) {
        OcambaLogUtils.d(TAG, "cancel() called with: ocambaNotificationObject notificationId = [" + notificationId + "]");
        if (ocambaNotificationObject != null && !ocambaNotificationObject.getTag().equals("")) {
            HashMap<String, String> notificationList = new HashMap<String, String>();
            try {
                if (!OcambaPrefManager.getStoredNotifications().equals("")) {
                    JSONObject notificationMap = new JSONObject(OcambaPrefManager.getStoredNotifications());
                    Iterator notification = notificationMap.keys();
                    OcambaLogUtils.i(TAG, "Notification Tag: " + ocambaNotificationObject.getTag());
                    while (notification.hasNext()) {
                        String storedId = (String)notification.next();
                        String storedTag = String.valueOf(notificationMap.get(storedId));
                        OcambaLogUtils.d(TAG, "store id: " + storedId);
                        OcambaLogUtils.d(TAG, "store tag: " + storedTag);
                        if (ocambaNotificationObject.getTag().equals(storedTag)) {
                            this.mNotificationManager.cancel(Integer.valueOf(storedId).intValue());
                            notificationList.remove(storedId);
                            OcambaUtils.setBadgeCount(this.mApplicationContext, OcambaPrefManager.getNotificationCount() - 1);
                            continue;
                        }
                        notificationList.put(storedId, storedTag);
                    }
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            notificationList.put(String.valueOf(notificationId), ocambaNotificationObject.getTag());
            OcambaPrefManager.setNotificationsToStore(new JSONObject(notificationList).toString());
        }
    }

    public static boolean canShowNotifications(Context context) {
        return OcambaNotificationRenderer.isNotificationChannelEnabled(context, OcambaUtils.getAppPackageName(context) + ".ocamba.notification.channel.id") && OcambaNotificationRenderer.areNotificationsEnabled(context);
    }

    private static boolean isNotificationChannelEnabled(Context context, @Nullable String channelId) {
        if (Build.VERSION.SDK_INT >= 26) {
            if (!TextUtils.isEmpty((CharSequence)channelId)) {
                NotificationManager manager = (NotificationManager)context.getSystemService("notification");
                NotificationChannel channel = manager.getNotificationChannel(channelId);
                if (channel == null) {
                    return true;
                }
                return channel.getImportance() != 0;
            }
            return false;
        }
        return NotificationManagerCompat.from((Context)context).areNotificationsEnabled();
    }

    private static boolean areNotificationsEnabled(Context context) {
        return NotificationManagerCompat.from((Context)context).areNotificationsEnabled();
    }
}

