/*
 * Decompiled with CFR 0.152.
 */
package com.ocamba.hoood.notifications;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.support.v4.app.NotificationManagerCompat;
import android.webkit.URLUtil;
import com.ocamba.hoood.OcambaHoood;
import com.ocamba.hoood.OcambaPrefManager;
import com.ocamba.hoood.OcambaRequest;
import com.ocamba.hoood.notifications.OcambaNotificationObject;
import com.ocamba.hoood.notifications.OcambaNotificationRenderer;
import com.ocamba.hoood.util.OcambaLogUtils;
import com.ocamba.hoood.util.OcambaUtils;

public class OcambaNotificationActions
extends BroadcastReceiver {
    public static final String TAG = OcambaNotificationActions.class.getSimpleName();

    public void onReceive(Context context, Intent intent) {
        try {
            String action = OcambaUtils.notification(context, intent);
            if (action == null) {
                OcambaLogUtils.w(TAG, "Intent action not defined");
                return;
            }
            int notificationId = intent.getIntExtra(".OCAMBA_NOTIFICATION_ID", 0);
            OcambaUtils.setBadgeCount(context, OcambaPrefManager.getNotificationCount() - 1);
            OcambaLogUtils.d(TAG, String.format("Received intent with action %s", action));
            switch (action) {
                case ".OCAMBA_NOTIFICATION_ACTION_CLICK": {
                    this.getClickTracker(intent);
                    if (!OcambaHoood.notification().isCustomActionButtons()) {
                        this.openBrowser(context, intent);
                    }
                    OcambaUtils.sendNotificationClicked(context, (OcambaNotificationObject)intent.getParcelableExtra("ocamba_object"));
                    break;
                }
                case ".OCAMBA_NOTIFICATION_ACTION_DELETE": {
                    OcambaUtils.sendNotificationDismissed(context);
                    break;
                }
                case ".OCAMBA_NOTIFICATION_BUTTON_ACTION_CUSTOM": 
                case ".OCAMBA_NOTIFICATION_BUTTON_ACTION_NO": {
                    this.closeNotification(context, notificationId);
                    if (!OcambaHoood.notification().isCustomActionButtons()) {
                        String actionUrl = intent.getStringExtra("url");
                        if (actionUrl != null && actionUrl.length() > 0 && URLUtil.isValidUrl((String)actionUrl)) {
                            this.openBrowser(context, actionUrl);
                        }
                        OcambaUtils.sendNotificationDismissed(context);
                        break;
                    }
                    OcambaUtils.sendOcambaActionButtons(context, intent.getStringExtra("actions"));
                    break;
                }
                case ".OCAMBA_NOTIFICATION_BUTTON_ACTION_YES": {
                    this.closeNotification(context, notificationId);
                    this.getClickTracker(intent);
                    if (!OcambaHoood.notification().isCustomActionButtons()) {
                        String actionUrl = intent.getStringExtra("url");
                        if (actionUrl != null && actionUrl.length() > 0 && URLUtil.isValidUrl((String)actionUrl)) {
                            this.openBrowser(context, actionUrl);
                        } else {
                            this.openBrowser(context, intent);
                        }
                        OcambaUtils.sendNotificationClicked(context, (OcambaNotificationObject)intent.getParcelableExtra("ocamba_object"));
                        break;
                    }
                    OcambaUtils.sendOcambaActionButtons(context, intent.getStringExtra("actions"));
                    break;
                }
                case ".OCAMBA_NOTIFICATION_ACTION_MULTI_MESSAGE": {
                    if (intent.getExtras() == null) {
                        OcambaLogUtils.e(TAG, "Received intent doesn't have extras!");
                        return;
                    }
                    Bundle notificationsExtras = intent.getExtras().getBundle("ocamba_m_m_extras");
                    if (notificationsExtras == null) {
                        OcambaLogUtils.e(TAG, "Received intent doesn't have set [ocamba_m_m_extras] value");
                        return;
                    }
                    int multiMessagePage = notificationsExtras.getInt("ocamba_m_m_index");
                    new OcambaNotificationRenderer(context).renderMultiMessageNotification(notificationsExtras, multiMessagePage);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void openBrowser(Context context, Intent intent) {
        OcambaNotificationObject notificationObject = (OcambaNotificationObject)intent.getParcelableExtra("ocamba_object");
        if (notificationObject == null) {
            OcambaLogUtils.e(TAG, "openBrowser notificationObject is NULL!");
            return;
        }
        String browserUrl = notificationObject.getUrl();
        OcambaLogUtils.d(TAG, "browserUrl: " + browserUrl);
        if (browserUrl != null && browserUrl.length() > 0 && URLUtil.isValidUrl((String)browserUrl)) {
            this.openBrowser(context, browserUrl);
        }
    }

    private void openBrowser(Context context, String browserUrl) {
        Intent browserIntent = new Intent("android.intent.action.VIEW");
        browserIntent.setData(Uri.parse((String)browserUrl));
        browserIntent.addFlags(0x10000000);
        context.startActivity(browserIntent);
    }

    private void getClickTracker(Intent intent) {
        OcambaNotificationObject notificationObject = (OcambaNotificationObject)intent.getParcelableExtra("ocamba_object");
        if (notificationObject == null || notificationObject.getClickTrackerArray() == null) {
            OcambaLogUtils.e(TAG, "getTrackerObj notificationObject is NULL!");
            return;
        }
        for (int i = 0; i < notificationObject.getClickTrackerArray().size(); ++i) {
            String clickTracker = notificationObject.getClickTrackerArray().get(i);
            OcambaLogUtils.i(TAG, "Click tracker: " + clickTracker);
            if (clickTracker == null || clickTracker.length() <= 0 || !URLUtil.isValidUrl((String)clickTracker)) continue;
            OcambaRequest.getTracker(clickTracker);
        }
    }

    private void closeNotification(Context context, int notificationId) {
        OcambaLogUtils.d(TAG, "closeNotification() called with: context = [" + context + "], notificationId = [" + notificationId + "]");
        if (notificationId != 0) {
            NotificationManagerCompat.from((Context)context).cancel(notificationId);
        }
    }
}

