/*
 * Decompiled with CFR 0.152.
 */
package com.ocamba.hoood.geo;

import android.support.annotation.NonNull;
import com.google.android.gms.location.Geofence;
import com.ocamba.hoood.geo.OcambaGeofenceLatLng;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public class OcambaGeofence {
    private final String mId;
    private final double mLatitude;
    private final double mLongitude;
    private final float mRadius;
    private long mExpirationDuration;
    private int mTransitionType;
    private ArrayList<String> mPolygon;

    public OcambaGeofence(String geofenceId, double latitude, double longitude, float radius, long expiration, int transition) {
        this.mId = geofenceId;
        this.mLatitude = latitude;
        this.mLongitude = longitude;
        this.mRadius = radius;
        this.mExpirationDuration = expiration;
        this.mTransitionType = transition;
    }

    public OcambaGeofence(String geofenceId, double latitude, double longitude, float radius, long expiration, int transition, ArrayList<String> polygon) {
        this.mId = geofenceId;
        this.mLatitude = latitude;
        this.mLongitude = longitude;
        this.mRadius = radius;
        this.mExpirationDuration = expiration;
        this.mTransitionType = transition;
        this.mPolygon = polygon;
    }

    public String getId() {
        return this.mId;
    }

    public double getLatitude() {
        return this.mLatitude;
    }

    public double getLongitude() {
        return this.mLongitude;
    }

    public float getRadius() {
        return this.mRadius;
    }

    public long getExpirationDuration() {
        return this.mExpirationDuration;
    }

    public int getTransitionType() {
        return this.mTransitionType;
    }

    public ArrayList<String> getPolygon() {
        return this.mPolygon;
    }

    public void setPolygon(ArrayList<String> mPolygon) {
        this.mPolygon = mPolygon;
    }

    public Set<String> getPolygonSet() {
        return new HashSet<String>(this.mPolygon);
    }

    public ArrayList<OcambaGeofenceLatLng> getPolygonLatLng() {
        if (this.mPolygon == null) {
            return new ArrayList<OcambaGeofenceLatLng>();
        }
        ArrayList<OcambaGeofenceLatLng> latLngPoints = new ArrayList<OcambaGeofenceLatLng>(this.mPolygon.size());
        for (String point : this.mPolygon) {
            String[] coordinates = point.split("\\s*,\\s*");
            String latitude = coordinates[0];
            String longitude = coordinates[1];
            latLngPoints.add(new OcambaGeofenceLatLng(Double.valueOf(latitude), Double.valueOf(longitude)));
        }
        return latLngPoints;
    }

    public boolean isPolygon() {
        return this.mPolygon != null && this.mPolygon.size() > 0;
    }

    public Geofence toGeofence() {
        return new Geofence.Builder().setRequestId(this.mId).setTransitionTypes(this.mTransitionType).setCircularRegion(this.mLatitude, this.mLongitude, this.mRadius).setExpirationDuration(this.mExpirationDuration).build();
    }

    @NonNull
    public String toString() {
        return "id = " + this.mId + ", c = [" + this.mLatitude + "," + this.mLongitude + "], r = [" + this.mRadius + "m], ed = [" + this.mExpirationDuration + "], p = [" + this.mPolygon + "]";
    }
}

