/*
 * Decompiled with CFR 0.152.
 */
package com.ocamba.hoood;

import android.content.Context;
import android.content.SharedPreferences;
import java.util.HashSet;
import java.util.Set;

public class OcambaPrefManager {
    private static Context mContext;
    private static final String FIRST_LAUNCH = "ocamba_first_launch";
    private static final String UTM = "ocamba_utm";
    private static final String PUSH_INIT = "ocamba_push_init";
    private static final String TOKEN = "ocamba_token";
    private static final String COUNT_REQUESTS = "ocamba_count_requests";
    private static final String UNIQUE_ID = "ocamba_unique_id";
    private static final String STORED_NOTIFICATIONS = "ocamba_stored_notifications";
    private static String COUNT_NOTIFICATIONS;
    private static String LOCATION_TIME;
    private static String APP_VERSION;
    private static final String TRACKER_MAP = "ocamba_tracker_map";

    static void setSharedPreferences(Context context) {
        mContext = context;
    }

    protected static SharedPreferences getSharedPreferences() {
        if (mContext == null) {
            return null;
        }
        return mContext.getSharedPreferences("ocamba_shared_preferences", 0);
    }

    public static void setAppFirstLaunch() {
        SharedPreferences shared = OcambaPrefManager.getSharedPreferences();
        if (shared != null) {
            shared.edit().putBoolean(FIRST_LAUNCH, false).apply();
        }
    }

    public static boolean isAppFirstLaunch() {
        SharedPreferences shared = OcambaPrefManager.getSharedPreferences();
        if (shared != null) {
            return shared.getBoolean(FIRST_LAUNCH, true);
        }
        return true;
    }

    public static void setUtm(String utm) {
        SharedPreferences shared = OcambaPrefManager.getSharedPreferences();
        if (shared != null) {
            shared.edit().putString(UTM, utm).apply();
        }
    }

    public static String getUtm() {
        SharedPreferences shared = OcambaPrefManager.getSharedPreferences();
        if (shared != null) {
            return shared.getString(UTM, "");
        }
        return "";
    }

    public static void setToken(String trackerMap) {
        SharedPreferences shared = OcambaPrefManager.getSharedPreferences();
        if (shared != null) {
            shared.edit().putString(TOKEN, trackerMap).apply();
        }
    }

    public static String getToken() {
        SharedPreferences shared = OcambaPrefManager.getSharedPreferences();
        if (shared != null) {
            return shared.getString(TOKEN, "");
        }
        return "";
    }

    public static void setPushInitialized(boolean status) {
        SharedPreferences shared = OcambaPrefManager.getSharedPreferences();
        if (shared != null) {
            shared.edit().putBoolean(PUSH_INIT, status).apply();
        }
    }

    public static boolean isPushInitialized() {
        SharedPreferences shared = OcambaPrefManager.getSharedPreferences();
        if (shared != null) {
            return shared.getBoolean(PUSH_INIT, false);
        }
        return false;
    }

    public static void setCountRequests(int count) {
        SharedPreferences shared = OcambaPrefManager.getSharedPreferences();
        if (shared != null) {
            shared.edit().putInt(COUNT_REQUESTS, count).apply();
        }
    }

    public static int getCountRequests() {
        SharedPreferences shared = OcambaPrefManager.getSharedPreferences();
        if (shared != null) {
            return shared.getInt(COUNT_REQUESTS, 0);
        }
        return 0;
    }

    public static void setUniqueId(String uniqueId) {
        SharedPreferences shared = OcambaPrefManager.getSharedPreferences();
        if (shared != null) {
            shared.edit().putString(UNIQUE_ID, uniqueId).apply();
        }
    }

    public static String getUniqueId() {
        SharedPreferences shared = OcambaPrefManager.getSharedPreferences();
        if (shared != null) {
            return shared.getString(UNIQUE_ID, "");
        }
        return "";
    }

    public static void setNotificationsToStore(String notificationList) {
        SharedPreferences shared = OcambaPrefManager.getSharedPreferences();
        if (shared != null) {
            shared.edit().putString(STORED_NOTIFICATIONS, notificationList).apply();
        }
    }

    public static String getStoredNotifications() {
        SharedPreferences shared = OcambaPrefManager.getSharedPreferences();
        if (shared != null) {
            return shared.getString(STORED_NOTIFICATIONS, "");
        }
        return "";
    }

    public static void setNotificationCount(int count) {
        SharedPreferences shared = OcambaPrefManager.getSharedPreferences();
        if (shared != null) {
            shared.edit().putInt(COUNT_NOTIFICATIONS, count).apply();
        }
    }

    public static int getNotificationCount() {
        SharedPreferences shared = OcambaPrefManager.getSharedPreferences();
        if (shared != null) {
            return shared.getInt(COUNT_NOTIFICATIONS, 0);
        }
        return 0;
    }

    public static void setLocationTime(long time) {
        SharedPreferences shared = OcambaPrefManager.getSharedPreferences();
        if (shared != null) {
            shared.edit().putLong(LOCATION_TIME, time).apply();
        }
    }

    public static long getLocationTime() {
        SharedPreferences shared = OcambaPrefManager.getSharedPreferences();
        if (shared != null) {
            return shared.getLong(LOCATION_TIME, 0L);
        }
        return 0L;
    }

    public static void setAppVersion(String uniqueId) {
        SharedPreferences shared = OcambaPrefManager.getSharedPreferences();
        if (shared != null) {
            shared.edit().putString(APP_VERSION, uniqueId).apply();
        }
    }

    public static String getAppVersion() {
        SharedPreferences shared = OcambaPrefManager.getSharedPreferences();
        if (shared != null) {
            return shared.getString(APP_VERSION, "");
        }
        return "";
    }

    public static void setTrackerMap(String trackerMap) {
        SharedPreferences shared = OcambaPrefManager.getSharedPreferences();
        if (shared != null) {
            shared.edit().putString(TRACKER_MAP, trackerMap).apply();
        }
    }

    public static String getTrackerMap() {
        SharedPreferences shared = OcambaPrefManager.getSharedPreferences();
        if (shared != null) {
            return shared.getString(TRACKER_MAP, "");
        }
        return "";
    }

    protected static void setGeofenceOrBeaconIds(String key, Set<String> set) {
        SharedPreferences shared = OcambaPrefManager.getSharedPreferences();
        if (shared != null) {
            if (set.size() > 0) {
                shared.edit().putStringSet(key, set).apply();
            } else {
                shared.edit().remove(key).apply();
            }
        }
    }

    protected static void removeGeofenceOrBeaconId(String key, String value) {
        Set<String> currentValues = OcambaPrefManager.getGeofenceOrBeaconId(key);
        currentValues.remove(value);
        OcambaPrefManager.setGeofenceOrBeaconIds(key, currentValues);
    }

    protected static Set<String> getGeofenceOrBeaconId(String key) {
        SharedPreferences shared = OcambaPrefManager.getSharedPreferences();
        if (shared != null) {
            return shared.getStringSet(key, new HashSet());
        }
        return new HashSet<String>();
    }

    protected static String getGeofenceOrBeaconFieldKey(String keyPrefix, String id2, String fieldName) {
        return keyPrefix + "_" + id2 + "_" + fieldName;
    }

    static {
        COUNT_NOTIFICATIONS = "ocamba_count_notifications";
        LOCATION_TIME = "ocamba_location_time";
        APP_VERSION = "ocamba_app_version";
    }
}

