package com.taboola.android.infra.utilities;

import android.os.Handler;
import android.os.Looper;

public class UiExecutor extends AbstractExecutor {

    private final Handler handler = new Handler(Looper.getMainLooper());

    @Override
    public void execute(Runnable command) {
        handler.post(command);
    }

    @Override
    public boolean canExecuteSynchronously() {
        return isThisUiThread();
    }

}
