package com.taboola.android.infra.utilities;

import java.util.concurrent.Executor;
import java.util.concurrent.Executors;

public class BackgroundExecutor extends AbstractExecutor {
    private final Executor executor = Executors.newCachedThreadPool();

    @Override
    public void execute(Runnable command) {
        executor.execute(command);
    }

    @Override
    public boolean canExecuteSynchronously() {
        return !isThisUiThread();
    }
}
