package com.taboola.android.infra.persistence;

import android.content.SharedPreferences;

import androidx.annotation.NonNull;

/**
 * Created by ronk on 2017-02-13.
 */
public class StringPersistentResource extends  AbstractPersistentResource<String> {

    public StringPersistentResource(Builder<String> builder) {
        super(builder);
    }

    @Override
    protected String getStoredValue() {
        return getSharedPreferences().getString(getStorageKey(), "");
    }

    @Override
    protected void storeValue(@NonNull SharedPreferences.Editor editor, String value) {
        editor.putString(getStorageKey(), value);
    }


}
