package com.taboola.android.infra.persistence;

import android.content.SharedPreferences;

import androidx.annotation.NonNull;

import java.util.Collections;
import java.util.Set;

/**
 * Created by ronk on 2017-02-13.
 */
public class SetPersistentResource extends AbstractPersistentResource<Set<String>> {

    public SetPersistentResource(Builder<Set<String>> builder) {
        super(builder);
    }

    @Override
    protected Set<String> getStoredValue() {
        return getSharedPreferences().getStringSet(getStorageKey(), Collections.emptySet());
    }

    @Override
    protected void storeValue(@NonNull SharedPreferences.Editor editor, Set<String> value) {
        editor.putStringSet(getStorageKey(), value);
    }

}
