/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android;

import android.content.Context;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewTreeObserver;
import android.webkit.WebView;
import com.taboola.android.OnScrollChangedListenerImpl;
import com.taboola.android.js.TaboolaJs;
import com.taboola.android.listeners.ScrollToTopListener;
import com.taboola.android.utils.SdkDetailsHelper;

public class TaboolaWebView
extends WebView {
    private static final String TAG = TaboolaWebView.class.getSimpleName();
    private static final float OFFSET_DELTA_X = 1.4f;
    private static final int MIN_DISTANCE = 120;
    private float mOldPointX = 0.0f;
    private float mOldPointY = 0.0f;
    private float mDeltaY;
    private final int[] mViewLocation = new int[2];
    private int mTopScrollview = -1;
    protected boolean mShouldInterceptScroll = false;
    protected boolean mEnableHorizontalScroll = false;
    private boolean mScrolledToTop;
    protected boolean mProgressBarEnabled = true;
    private boolean mIsFirstTimeReachedEnd = true;
    protected boolean mIsOnline = true;
    private ScrollToTopListener mScrollTopListener;
    private SimpleOnGestureListener mGestureDetectorListener = new SimpleOnGestureListener();
    private GestureDetector mGestureDetector = new GestureDetector(this.getContext(), (GestureDetector.OnGestureListener)this.mGestureDetectorListener);
    private ViewTreeObserver.OnScrollChangedListener onScrollChangedListener;
    protected View mScrollviewParent;
    private OnScrollChangedListenerImpl mParentOnScrollChangedListenerImpl;
    private boolean mLastClickDownWasOnCarousel;

    public TaboolaWebView(Context context) {
        super(context);
    }

    public TaboolaWebView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public TaboolaWebView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    public boolean isScrolledToTop() {
        return this.mScrolledToTop;
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.mScrollviewParent == null) {
            this.mScrollviewParent = SdkDetailsHelper.getParentScrollView((View)this);
        }
        if (this.mScrollviewParent != null) {
            int[] loc = new int[2];
            this.mScrollviewParent.getLocationOnScreen(loc);
            this.mTopScrollview = loc[1];
            if (this.mShouldInterceptScroll && this.mProgressBarEnabled && this.mIsOnline) {
                this.initParentViewScrollChangeListener();
                if (this.onScrollChangedListener == null) {
                    this.onScrollChangedListener = new ViewTreeObserver.OnScrollChangedListener(){

                        public void onScrollChanged() {
                            if (TaboolaWebView.this.mScrollviewParent != null && !TaboolaWebView.this.mScrollviewParent.canScrollVertically(1) && (TaboolaWebView.this.isScrolledToTop() || TaboolaWebView.this.mIsFirstTimeReachedEnd)) {
                                TaboolaWebView.this.mIsFirstTimeReachedEnd = false;
                                if (TaboolaWebView.this.mShouldInterceptScroll) {
                                    TaboolaWebView.this.showProgressBarJS();
                                }
                            }
                        }
                    };
                }
                this.mParentOnScrollChangedListenerImpl.addListener(this.onScrollChangedListener);
            }
        }
        if (SdkDetailsHelper.shouldRemoveFocus((View)this)) {
            this.setFocusable(false);
        }
    }

    private void initParentViewScrollChangeListener() {
        if (this.mParentOnScrollChangedListenerImpl == null) {
            this.mParentOnScrollChangedListenerImpl = new OnScrollChangedListenerImpl(this.mScrollviewParent);
        }
    }

    protected void onDetachedFromWindow() {
        if (this.mParentOnScrollChangedListenerImpl != null) {
            this.mParentOnScrollChangedListenerImpl.removeListener(this.onScrollChangedListener);
            this.onScrollChangedListener = null;
        }
        this.mScrollviewParent = null;
        super.onDetachedFromWindow();
    }

    protected void clearDependencies() {
        this.mGestureDetector = null;
        this.mGestureDetectorListener = null;
        this.onScrollChangedListener = null;
        if (this.mParentOnScrollChangedListenerImpl != null) {
            this.mParentOnScrollChangedListenerImpl.clear();
            this.mParentOnScrollChangedListenerImpl = null;
        }
    }

    private void showProgressBarJS() {
        TaboolaJs.getInstance().showProgressBar(this);
    }

    protected void onScrollChanged(int scrollX, int scrollY, int oldScrollX, int oldScrollY) {
        this.mScrolledToTop = this.getScrollY() == 0;
        int deltaY = scrollY - oldScrollY;
        if (this.mScrolledToTop && deltaY <= 0 && this.mScrollTopListener != null) {
            this.mScrollTopListener.onTaboolaWidgetOnTop();
        }
        super.onScrollChanged(scrollX, scrollY, oldScrollX, oldScrollY);
    }

    public void registerScrollToTopListener(ScrollToTopListener scrollListener) {
        this.mScrollTopListener = scrollListener;
    }

    public void unregisterScrollToTopListener() {
        this.mScrollTopListener = null;
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.isScrollInterceptionEnabled() && this.isWidgetAtScreenTop()) {
            boolean horizontalScrolling = false;
            if (this.mEnableHorizontalScroll) {
                this.mGestureDetector.onTouchEvent(event);
            }
            switch (event.getAction()) {
                case 0: {
                    this.mOldPointY = event.getY();
                    this.mOldPointX = event.getX();
                    break;
                }
                case 2: {
                    this.mDeltaY = this.mOldPointY - event.getY();
                    if (!this.mEnableHorizontalScroll) break;
                    horizontalScrolling = this.isHorizontalScrolling(event);
                    break;
                }
                case 3: {
                    if (!this.mEnableHorizontalScroll) break;
                    this.mLastClickDownWasOnCarousel = false;
                    break;
                }
                case 1: {
                    if (this.mEnableHorizontalScroll) {
                        this.requestDisallowInterceptTouchEvent(true);
                        this.mLastClickDownWasOnCarousel = false;
                    }
                    return super.onTouchEvent(event);
                }
                default: {
                    return super.onTouchEvent(event);
                }
            }
            if (horizontalScrolling) {
                if (this.mLastClickDownWasOnCarousel) {
                    this.requestDisallowInterceptTouchEvent(true);
                } else {
                    this.requestDisallowInterceptTouchEvent(false);
                }
            } else if (!this.canScrollVertically(-1) && this.mDeltaY < 0.0f) {
                this.requestDisallowInterceptTouchEvent(false);
            } else {
                this.requestDisallowInterceptTouchEvent(true);
            }
        }
        return super.onTouchEvent(event);
    }

    private boolean isScrollInterceptionEnabled() {
        return this.mShouldInterceptScroll && this.mTopScrollview > -1;
    }

    private boolean isHorizontalScrolling(MotionEvent event) {
        float absDeltaX = Math.abs(this.mOldPointX - event.getX());
        return this.mGestureDetectorListener.isHorizontalSwipeDetected() && absDeltaX > 120.0f && absDeltaX >= Math.abs(this.mDeltaY) * 1.4f;
    }

    private boolean isWidgetAtScreenTop() {
        this.getLocationOnScreen(this.mViewLocation);
        return this.mViewLocation[1] <= this.mTopScrollview;
    }

    public void carouselTouchStart() {
        this.mLastClickDownWasOnCarousel = true;
    }

    private static class SimpleOnGestureListener
    extends GestureDetector.SimpleOnGestureListener {
        private boolean mHorizontalSwipeDetected;

        private SimpleOnGestureListener() {
        }

        public boolean onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
            if (e1 == null || e2 == null) {
                return false;
            }
            float angle = (float)Math.toDegrees(Math.atan2(e1.getY() - e2.getY(), e2.getX() - e1.getX()));
            this.mHorizontalSwipeDetected = angle > -45.0f && angle <= 45.0f || angle >= 135.0f && angle < 180.0f || angle < -135.0f && angle > -180.0f;
            return false;
        }

        boolean isHorizontalSwipeDetected() {
            return this.mHorizontalSwipeDetected;
        }
    }
}

