/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.js;

import android.content.Context;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.webkit.WebView;
import com.taboola.android.api.TaboolaOnClickListener;
import com.taboola.android.global_components.TaboolaContextManager;
import com.taboola.android.global_components.advertisingid.AdvertisingIdInfo;
import com.taboola.android.global_components.configuration.ConfigManager;
import com.taboola.android.global_components.configuration.PropertyResolver;
import com.taboola.android.global_components.monitor.MonitorHelper;
import com.taboola.android.global_components.network.NetworkManager;
import com.taboola.android.integration_verifier.IntegrationVerifier;
import com.taboola.android.integration_verifier.requests.VerificationRequest;
import com.taboola.android.integration_verifier.testing.TestIDs;
import com.taboola.android.integration_verifier.testing.tests.publisher_config.PublisherConfigParams_JS;
import com.taboola.android.integration_verifier.utility.IVLogger;
import com.taboola.android.js.JsInitDataObserver;
import com.taboola.android.js.OnResizeListener;
import com.taboola.android.js.WebViewManager;
import com.taboola.android.listeners.TaboolaUpdateContentListener;
import com.taboola.android.utils.ExtraProperty;
import com.taboola.android.utils.IntegrationVerifierUtils;
import com.taboola.android.utils.Logger;
import com.taboola.android.utils.OnClickHelper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class TaboolaWebParent {
    private static final String TAG = TaboolaWebParent.class.getSimpleName();
    public static final String PLACEMENT_TAG_DIVIDER = "##";
    public static final String INJECTED_OBJECT_NAME = "taboolaNative";
    Context mApplicationContext = TaboolaContextManager.getInstance().getApplicationContext();
    IntegrationVerifier mIntegrationVerifier;
    NetworkManager mNetworkManager;
    ConfigManager mConfigManager;
    OnClickHelper mOnClickHelper = new OnClickHelper();
    MonitorHelper mMonitorHelper;
    AdvertisingIdInfo mAdvertisingIdInfo;
    boolean mIsCalledFromStdInit;

    TaboolaWebParent() {
    }

    void verifyOnConstruction(@NonNull Context applicationContext, boolean isCalledFromStdInit) {
        int integrationType = isCalledFromStdInit ? 1 : 2;
        Bundle integrationVerifierBundle = new Bundle();
        integrationVerifierBundle.putString("Sdk_version_verification_key", "2.3.7-50815-16");
        integrationVerifierBundle.putInt("integration_verifier_key_integrationType", integrationType);
        integrationVerifierBundle.putStringArrayList("permissionsVerification_key_permissions_list", (ArrayList)new ArrayList<String>(){
            {
                this.add("android.permission.INTERNET");
                this.add("android.permission.ACCESS_NETWORK_STATE");
            }
        });
        integrationVerifierBundle.putInt("integration_verifier_key_integrationType", integrationType);
        this.mIntegrationVerifier.verify(new VerificationRequest(applicationContext, integrationVerifierBundle, new TestIDs(9, 2, 3, 4, 5)));
    }

    void getPlacementFromWebView(WebViewManager webViewManager) {
        if (webViewManager == null) {
            return;
        }
        webViewManager.addJsInitDataObserver(new JsInitDataObserver(){

            @Override
            public void onData(String dataJsonString) {
                try {
                    JSONObject placementJsonObject;
                    JSONObject dataJsonObject = new JSONObject(dataJsonString);
                    JSONArray placementsJsonArrayObject = dataJsonObject.optJSONArray("placements");
                    String publisher = dataJsonObject.optString("config_publisher");
                    TaboolaWebParent.this.setPublisher(publisher);
                    if (placementsJsonArrayObject != null && placementsJsonArrayObject.length() > 0 && (placementJsonObject = placementsJsonArrayObject.optJSONObject(0)) != null) {
                        TaboolaWebParent.this.setPlacement(placementJsonObject.optString("config_placement"));
                    }
                }
                catch (JSONException e) {
                    Logger.e(TAG, "TaboolaJs | getPlacementFromWebView | JSONException = " + e.getLocalizedMessage());
                }
            }
        });
    }

    private void setPlacement(String placement) {
        if (!TextUtils.isEmpty((CharSequence)placement) && !this.mIsCalledFromStdInit) {
            boolean shouldAllowNonOrganicClickOverride = this.mConfigManager.getConfigValue(placement, "allowNonOrganicClickOverride", this.mOnClickHelper.shouldAllowNonOrganicClickOverride());
            this.mOnClickHelper.setShouldAllowNonOrganicClickOverride(shouldAllowNonOrganicClickOverride);
            this.mConfigManager.set(placement, "allowNonOrganicClickOverride", shouldAllowNonOrganicClickOverride);
            String forceClickOnPackageProperty = PropertyResolver.resolve(ExtraProperty.FEATURE_FORCE_CLICK_ON_APP);
            String forceClickOnPackage = this.mConfigManager.getConfigValue(placement, forceClickOnPackageProperty, this.mOnClickHelper.getForceClickOnPackage());
            this.mOnClickHelper.setForceClickOnPackage(forceClickOnPackage);
            this.mConfigManager.set(placement, forceClickOnPackageProperty, forceClickOnPackage);
        }
    }

    private void setPublisher(String publisher) {
        if (!TextUtils.isEmpty((CharSequence)publisher)) {
            this.mConfigManager.setConfigDataFromRemoteWithPublisher(publisher);
        }
    }

    void getInitDataFromWebView(WebViewManager webViewManager) {
        if (webViewManager == null) {
            IVLogger.log("TaboolaJs | getInitDataFromWebView | WebView is not registered.");
        } else {
            webViewManager.addJsInitDataObserver(new JsInitDataObserver(){

                @Override
                public void onData(String dataJsonString) {
                    IVLogger.log("TaboolaJs | getInitDataFromWebView | onJsInitDataAvailable | dataJsonString = " + dataJsonString);
                    try {
                        JSONObject dataJsonObject = new JSONObject(dataJsonString);
                        JSONArray placementsJsonArrayObject = dataJsonObject.getJSONArray("placements");
                        int placementsArrayLength = placementsJsonArrayObject.length();
                        if (placementsArrayLength == 0) {
                            TaboolaWebParent.this.verifyPublisherConfiguration("Stub", "Stub", null, "Stub", "Stub", "Stub");
                        } else {
                            TaboolaWebParent.this.mIntegrationVerifier.getSessionData().setPublisherId(placementsJsonArrayObject.getJSONObject(0).optString("config_publisher"));
                            for (int i = 0; i < placementsArrayLength; ++i) {
                                JSONObject placementJsonObject = placementsJsonArrayObject.getJSONObject(i);
                                TaboolaWebParent.this.verifyPublisherConfiguration(placementJsonObject.optString("config_mode"), placementJsonObject.optString("config_container"), placementJsonObject.optString("config_placement"), placementJsonObject.optString("config_target_type"), dataJsonObject.optString("config_publisher"), dataJsonObject.optString("config_page_type"));
                            }
                        }
                        Bundle crawlUrlBundle = new Bundle();
                        crawlUrlBundle.putString("crawlingUrlTest_key_crawling_url", dataJsonObject.optString("config_pageurl"));
                        crawlUrlBundle.putInt("integration_verifier_key_integrationType", 2);
                        TaboolaWebParent.this.mIntegrationVerifier.verify(new VerificationRequest(TaboolaWebParent.this.mApplicationContext, crawlUrlBundle, new TestIDs(8)));
                    }
                    catch (JSONException e) {
                        IVLogger.log("TaboolaJs | getInitDataFromWebView | JSONException = " + e.getLocalizedMessage());
                    }
                }
            });
        }
    }

    private void verifyPublisherConfiguration(String mode, String container, String placement, String targetType, String publisher, String pageType) {
        Bundle verifyJsParamsBundle = new Bundle();
        verifyJsParamsBundle.putSerializable("publisherConfigurationTest_key_configuration_params", (Serializable)new PublisherConfigParams_JS(mode, container, placement, targetType, publisher, pageType));
        verifyJsParamsBundle.putInt("integration_verifier_key_integrationType", 2);
        this.mIntegrationVerifier.verify(new VerificationRequest(verifyJsParamsBundle, new TestIDs(6, 7)));
    }

    void fetchContent(WebViewManager webViewManager) {
        if (webViewManager == null) {
            Logger.e(TAG, "fetchContent: WebView is not registered", new Exception());
        } else {
            webViewManager.fetchContent();
        }
    }

    void showProgressBar(WebViewManager webViewManager) {
        if (webViewManager != null) {
            webViewManager.showProgressBar();
        } else {
            Logger.e(TAG, "showProgressBar: WebView is not registered", new Exception());
        }
    }

    public void scrollToTop(WebViewManager webViewManager, WebView webView) {
        if (webViewManager == null) {
            Logger.e(TAG, "scrollToTop: WebView is not registered", new Exception());
            return;
        }
        webView.scrollTo(0, 0);
        webViewManager.scrollToTop();
    }

    void notifyUpdateHeight(WebViewManager webViewManager, @NonNull WebView webView) {
        if (webView == null || webView.getContext() == null) {
            Logger.e(TAG, "notifyUpdateHeight, WebView is not attached ", new Exception());
            return;
        }
        if (webViewManager == null) {
            Logger.e(TAG, "notifyUpdateHeight: WebView is not registered", new Exception());
        } else {
            webViewManager.notifyUpdateHeight();
        }
    }

    Object setExtraProperties(@NonNull Map<String, String> extraProperties) {
        IntegrationVerifierUtils.verifyExtraProperties(this.mIntegrationVerifier, this.mIsCalledFromStdInit ? 1 : 2, extraProperties);
        for (String key : extraProperties.keySet()) {
            String value = extraProperties.get(key);
            ExtraProperty extraProperty = ExtraProperty.getExtraProperty(key);
            switch (extraProperty) {
                case UNRECOGNIZABLE: {
                    Logger.e(TAG, "setExtraProperties got unrecognized property. key = " + key);
                    break;
                }
                case ALLOW_NON_ORGANIC_OVERRIDE_PROP: {
                    this.mOnClickHelper.setShouldAllowNonOrganicClickOverride(this.mConfigManager.getConfigValue(key, Boolean.parseBoolean(value)));
                    this.mConfigManager.set(key, value);
                    break;
                }
                case FEATURE_FORCE_CLICK_ON_APP: {
                    this.mOnClickHelper.setForceClickOnPackage(this.mConfigManager.getConfigValue(key, value));
                    this.mConfigManager.set(key, value);
                }
            }
        }
        return this;
    }

    public Object setExtraProperties(WebViewManager webViewManager, @NonNull Map<String, String> extraProperties, String placement) {
        if (webViewManager != null) {
            for (Map.Entry<String, String> entry : extraProperties.entrySet()) {
                String value = this.mConfigManager.getConfigValue(placement, entry.getKey(), entry.getValue());
                entry.setValue(value);
                this.mConfigManager.set(placement, entry.getKey(), entry.getValue());
            }
            webViewManager.setExtraProperties(extraProperties);
        } else {
            Logger.e(TAG, "setExtraProperties: WebView is not registered");
        }
        return this;
    }

    void clear() {
        if (IntegrationVerifier.isEnabled()) {
            this.mIntegrationVerifier.getTestsManager().getMethodCallOrderTracker().clearTrackedMethods(this.mIsCalledFromStdInit ? 1 : 2);
            this.mIntegrationVerifier.clearStatusReport();
        }
        this.mMonitorHelper.stop(this.mApplicationContext);
    }

    Object setUserId(WebViewManager webViewManager, String userId) {
        if (!TextUtils.isEmpty((CharSequence)userId)) {
            HashMap<String, String> tempMap = new HashMap<String, String>(1);
            tempMap.put("unified_id", userId);
            this.setExtraProperties(webViewManager, tempMap, null);
        }
        return this;
    }

    public void updateContent(WebViewManager webViewManager, TaboolaUpdateContentListener onUpdateContentListener) {
        String logMsg;
        String string = logMsg = onUpdateContentListener != null ? "updateContent " : "TaboolaUpdateContentListener was removed";
        if (webViewManager != null) {
            webViewManager.setOnUpdateContentListener(onUpdateContentListener);
            if (onUpdateContentListener != null) {
                webViewManager.updateContent();
            }
            Logger.d(TAG, logMsg);
        } else {
            Logger.e(TAG, "updateContent : webView not found!");
        }
    }

    public void setTag(WebViewManager webViewManager, String tag) {
        if (TextUtils.isEmpty((CharSequence)tag)) {
            Logger.e(TAG, "setTag: was set with empty tag");
            return;
        }
        if (webViewManager != null) {
            webViewManager.setTag(tag);
        } else {
            Logger.e(TAG, "webViewManager is null, setTag: WebView is not registered", new Exception());
        }
    }

    void initializeFeatures() {
        boolean shouldAllowNonOrganicClickOverride = this.mConfigManager.getConfigValue("allowNonOrganicClickOverride", this.mOnClickHelper.shouldAllowNonOrganicClickOverride());
        this.mOnClickHelper.setShouldAllowNonOrganicClickOverride(shouldAllowNonOrganicClickOverride);
        String forceClickOnPackage = this.mConfigManager.getConfigValue(PropertyResolver.resolve(ExtraProperty.FEATURE_FORCE_CLICK_ON_APP), this.mOnClickHelper.getForceClickOnPackage());
        this.mOnClickHelper.setForceClickOnPackage(forceClickOnPackage);
    }

    void setOnResizeListener(WebViewManager webViewManager, @Nullable OnResizeListener onResizeListener) {
        if (webViewManager != null) {
            webViewManager.setOnResizeListener(onResizeListener);
        } else {
            Logger.e(TAG, "setOnResizeListener: WebView is not registered");
        }
    }

    public void setOnClickListener(WebViewManager webViewManager, @Nullable TaboolaOnClickListener onClickListener) {
        Logger.d(TAG, onClickListener != null ? "setOnClickListener " : "TaboolaOnClickListener was removed");
        if (webViewManager != null) {
            webViewManager.setOnClickListener(onClickListener);
        } else {
            Logger.e(TAG, "setOnClickListener: WebView is not registered");
        }
    }
}

