/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.js;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import android.text.TextUtils;
import android.util.Pair;
import android.webkit.WebResourceRequest;
import android.webkit.WebResourceResponse;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.taboola.android.global_components.monitor.MonitorHelper;
import com.taboola.android.global_components.monitor.TBMobileLoaderChange;
import com.taboola.android.global_components.monitor.TBOnlineTemplateChange;
import com.taboola.android.global_components.monitor.TBUrlParamsChange;
import com.taboola.android.js.TaboolaJs;
import com.taboola.android.utils.Logger;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class MonitorWebViewClient
extends WebViewClient {
    private static final String MOBILE_LOADER_JS = "mobile-loader.js";
    private static final String ONLINE_TEMPLATE_JS = "https://cdn.taboola.com/shared/templateJS.html";
    private static final String TRC_PREFIX_HTTPS = "https://trc.taboola.com";
    private static final String TRC_PREFIX_HTTP = "http://trc.taboola.com";
    private static final String GET_RECOMMENDATION_REQUEST_PATTERN = "http://trc.taboola.com/.*/trc/3/json";
    private static final String GET_RECOMMENDATION_REQUEST_PATTERN_HTTPS = "https://trc.taboola.com/.*/trc/3/json";
    private MonitorHelper mMonitorHelper;

    MonitorWebViewClient(MonitorHelper monitorHelper) {
        this.mMonitorHelper = monitorHelper;
    }

    @Nullable
    public WebResourceResponse shouldInterceptRequest(WebView view, String url) {
        Pair<WebResourceResponse, URL> pair;
        WebResourceResponse webResourceResponse = null;
        TBMobileLoaderChange mobileLoaderChange = (TBMobileLoaderChange)this.mMonitorHelper.getFeature(1);
        TBOnlineTemplateChange onlineTemplateChange = (TBOnlineTemplateChange)this.mMonitorHelper.getFeature(6);
        TBUrlParamsChange paramsChange = (TBUrlParamsChange)this.mMonitorHelper.getFeature(3);
        if (mobileLoaderChange != null && MonitorWebViewClient.needHandleLoaderUrl(url)) {
            try {
                pair = TextUtils.isEmpty((CharSequence)mobileLoaderChange.getMobileLoaderUrl()) ? null : this.getWebResourceResponse(new URL(mobileLoaderChange.getMobileLoaderUrl()));
                if (pair != null) {
                    webResourceResponse = (WebResourceResponse)pair.first;
                    url = ((URL)pair.second).toString();
                }
            }
            catch (Exception e) {
                Logger.e(TaboolaJs.TAG, e.getMessage());
            }
        }
        if (onlineTemplateChange != null && MonitorWebViewClient.needHandleOnlineTemplateUrl(url)) {
            try {
                pair = TextUtils.isEmpty((CharSequence)onlineTemplateChange.getOnlineTemplateUrl()) ? null : this.getWebResourceResponse(new URL(onlineTemplateChange.getOnlineTemplateUrl()));
                if (pair != null) {
                    webResourceResponse = (WebResourceResponse)pair.first;
                    url = ((URL)pair.second).toString();
                }
            }
            catch (Exception e) {
                Logger.e(TaboolaJs.TAG, e.getMessage());
            }
        }
        if (webResourceResponse == null && paramsChange != null && MonitorWebViewClient.needToAddUrlParams(url)) {
            try {
                pair = this.handleUrlParams(url, paramsChange);
                if (pair != null) {
                    webResourceResponse = (WebResourceResponse)pair.first;
                    url = ((URL)pair.second).toString();
                }
            }
            catch (Exception e) {
                Logger.e(TaboolaJs.TAG, e.getMessage());
            }
        }
        if (MonitorWebViewClient.needToSendToMonitor(url)) {
            try {
                String urlAfterDecode = URLDecoder.decode(url, "UTF-8");
                this.mMonitorHelper.sendUrlToMonitor(new Date().getTime(), urlAfterDecode);
            }
            catch (Exception e) {
                Logger.e(TaboolaJs.TAG, e.getMessage());
            }
        }
        if (webResourceResponse != null) {
            return webResourceResponse;
        }
        return super.shouldInterceptRequest(view, url);
    }

    private Pair<WebResourceResponse, URL> handleUrlParams(String url, TBUrlParamsChange paramsChange) throws URISyntaxException, IOException {
        if (paramsChange == null || TextUtils.isEmpty((CharSequence)paramsChange.getParams())) {
            return null;
        }
        URI newUrl = MonitorWebViewClient.appendQueryToUri(url, paramsChange.getParams());
        return this.getWebResourceResponse(new URL(newUrl.toString()));
    }

    private static URI appendQueryToUri(String uri, String appendQuery) throws URISyntaxException {
        URI oldUri = new URI(uri);
        String newQuery = oldUri.getQuery();
        newQuery = newQuery == null ? appendQuery : newQuery + "&" + appendQuery;
        return new URI(oldUri.getScheme(), oldUri.getAuthority(), oldUri.getPath(), newQuery, oldUri.getFragment());
    }

    @NonNull
    private Pair<WebResourceResponse, URL> getWebResourceResponse(URL url) throws IOException {
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.connect();
        BufferedInputStream inputStream = new BufferedInputStream(conn.getInputStream());
        WebResourceResponse response = new WebResourceResponse("text/html", "UTF-8", (InputStream)inputStream);
        return new Pair((Object)response, (Object)url);
    }

    @RequiresApi(api=21)
    @Nullable
    public WebResourceResponse shouldInterceptRequest(WebView view, WebResourceRequest request) {
        return this.shouldInterceptRequest(view, request.getUrl().toString());
    }

    private static boolean needHandleLoaderUrl(String url) {
        return url.endsWith(MOBILE_LOADER_JS);
    }

    private static boolean needHandleOnlineTemplateUrl(String url) {
        return url.startsWith(ONLINE_TEMPLATE_JS);
    }

    private static boolean needToAddUrlParams(String url) {
        Pattern pattern = Pattern.compile("https://trc.taboola.com/.*/trc/3/json|http://trc.taboola.com/.*/trc/3/json");
        Matcher matcher = pattern.matcher(url);
        return matcher.lookingAt();
    }

    private static boolean needToSendToMonitor(String url) {
        return url.startsWith(TRC_PREFIX_HTTPS) || url.startsWith(TRC_PREFIX_HTTP);
    }
}

