/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.global_components.monitor;

import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.text.TextUtils;
import android.util.SparseArray;
import com.taboola.android.global_components.monitor.MonitorHelper;
import com.taboola.android.global_components.monitor.TBSdkFeature;

class SdkMonitorHandler
extends Handler {
    private MonitorHelper mMonitorHelper;

    public SdkMonitorHandler(MonitorHelper monitorHelper) {
        this.mMonitorHelper = monitorHelper;
    }

    public void handleMessage(Message msg) {
        Bundle data = msg.getData();
        switch (msg.what) {
            case 232: {
                try {
                    String sdkFeaturesString = data.getString("MONITOR_FEATURE_SET_LIST");
                    if (TextUtils.isEmpty((CharSequence)sdkFeaturesString)) break;
                    SparseArray<TBSdkFeature> sdkFeatures = TBSdkFeature.parseSdkFeatures(sdkFeaturesString);
                    this.mMonitorHelper.setSdkFeatures(sdkFeatures);
                    break;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

