/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.global_components.monitor;

import android.content.Context;
import android.graphics.Point;
import android.os.Handler;
import android.os.Looper;
import android.os.Messenger;
import android.support.annotation.Nullable;
import android.util.SparseArray;
import com.taboola.android.MonitorManager;
import com.taboola.android.global_components.monitor.SdkMonitorHandler;
import com.taboola.android.global_components.monitor.TBNetworkMonitoring;
import com.taboola.android.global_components.monitor.TBSdkFeature;
import com.taboola.android.global_components.monitor.TBSimCodeChange;
import com.taboola.android.global_components.monitor.TBSuspendMonitor;
import com.taboola.android.global_components.monitor.TBWidgetLayoutParamsChange;
import com.taboola.android.js.WebViewManager;
import com.taboola.android.utils.Logger;
import com.taboola.android.utils.MonitorUtils;
import com.taboola.android.utils.SdkDetailsHelper;
import java.net.URLDecoder;
import java.util.Date;
import java.util.HashMap;

public class MonitorHelper {
    private static final String TAG = MonitorHelper.class.getSimpleName();
    private Boolean mIsSdkMonitorInstalled;
    private MonitorManager mSdkMonitorManager = null;
    private Messenger mMonitorMessenger;
    private SparseArray<TBSdkFeature> mSdkFeatures;
    private Handler mHandler;

    public void start(Context applicationContext, String sdkDetailsJSON) {
        if (this.mIsSdkMonitorInstalled == null) {
            this.mIsSdkMonitorInstalled = MonitorUtils.isSdkMonitorInstalled(applicationContext);
            if (this.mIsSdkMonitorInstalled.booleanValue()) {
                this.mSdkMonitorManager = MonitorManager.getInstance(SdkDetailsHelper.getApplicationName(applicationContext));
                this.mSdkMonitorManager.bindService(applicationContext);
                Logger.setSdkMonitorManager(this.mSdkMonitorManager);
                if (this.mHandler == null) {
                    this.mHandler = new Handler(Looper.getMainLooper());
                }
                if (this.mMonitorMessenger == null) {
                    this.mMonitorMessenger = new Messenger((Handler)new SdkMonitorHandler(this));
                }
            }
        }
        if (this.mIsSdkMonitorInstalled.booleanValue()) {
            this.mSdkMonitorManager.sendGetFeatureSet(this.mMonitorMessenger, sdkDetailsJSON);
        }
    }

    public void stop(Context applicationContext) {
        if (applicationContext == null) {
            Logger.e(TAG, "Monitor cannot work with null contexet.");
            return;
        }
        if (this.mHandler != null) {
            this.mHandler.removeCallbacksAndMessages(null);
            this.mHandler = null;
        }
        if (this.mIsSdkMonitorInstalled != null && this.mIsSdkMonitorInstalled.booleanValue() && this.mSdkMonitorManager != null) {
            this.mIsSdkMonitorInstalled = null;
            this.mSdkMonitorManager.unbindService(applicationContext);
            Logger.setSdkMonitorManager(null);
            this.mSdkMonitorManager = null;
            this.mMonitorMessenger = null;
            if (this.mSdkFeatures != null) {
                this.mSdkFeatures.clear();
            }
        }
    }

    public Boolean isSdkMonitorEnabled() {
        return this.mIsSdkMonitorInstalled != null && this.mIsSdkMonitorInstalled != false && !this.isSdkMonitorSuspended();
    }

    public MonitorManager getSdkMonitorManager() {
        return this.mSdkMonitorManager;
    }

    public void setSdkFeatures(SparseArray<TBSdkFeature> sdkFeatures) {
        this.mSdkFeatures = sdkFeatures;
        SdkDetailsHelper.verifyIfNeededToChangeSimCode((TBSimCodeChange)this.getFeature(5));
        if (this.isSdkMonitorEnabled().booleanValue()) {
            Logger.setSdkMonitorLevelActive();
        }
    }

    public boolean isSdkMonitorSuspended() {
        TBSuspendMonitor suspendMonitor = (TBSuspendMonitor)this.getFeature(2);
        return suspendMonitor != null && suspendMonitor.isShouldSuspend();
    }

    public boolean isShouldMonitorNetwork() {
        TBNetworkMonitoring networkMonitoring = (TBNetworkMonitoring)this.getFeature(4);
        return networkMonitoring == null || networkMonitoring.isShouldMonitor();
    }

    private boolean isMissingSdkFeatures() {
        return this.mSdkFeatures == null || this.mSdkFeatures.size() == 0;
    }

    @Nullable
    public <T extends TBSdkFeature> T getFeature(Integer key) {
        if (this.isMissingSdkFeatures()) {
            return null;
        }
        TBSdkFeature sdkFeature = (TBSdkFeature)this.mSdkFeatures.get(key.intValue());
        return (T)sdkFeature;
    }

    public void sendUrlToMonitor(String url) {
        try {
            String urlAfterDecode = URLDecoder.decode(url, "UTF-8");
            this.mSdkMonitorManager.sendNetworkCall(new Date().getTime(), urlAfterDecode);
        }
        catch (Exception e) {
            Logger.e(TAG, e.getMessage());
        }
    }

    public Point getWidgetMonitorSize() {
        TBWidgetLayoutParamsChange paramsChange = (TBWidgetLayoutParamsChange)this.getFeature(7);
        if (paramsChange != null) {
            return new Point(paramsChange.getWidth(), paramsChange.getHeight());
        }
        return null;
    }

    public void sendUrlToMonitor(final long timestamp, final String url) {
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                MonitorHelper.this.mSdkMonitorManager.sendNetworkCall(timestamp, url);
            }
        });
    }

    public void sendFetchContentParamsToMonitor(WebViewManager webViewManager, String placement, HashMap<String, String> parameters) {
        if (this.isSdkMonitorEnabled().booleanValue() && webViewManager != null) {
            webViewManager.prepareAndSendParamsToMonitor(placement, parameters);
        }
    }

    public void sendWebPlacementFetchContent(final String placementId, final String placementType, final String placementName, final HashMap<String, String> parameters) {
        if (this.isSdkMonitorEnabled().booleanValue()) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    MonitorHelper.this.mSdkMonitorManager.sendWebPlacementFetchContent(placementId, placementType, placementName, parameters);
                }
            });
        }
    }

    public void reportDeviceDataToMonitor(String deviceData) {
        if (this.isSdkMonitorEnabled().booleanValue()) {
            this.mSdkMonitorManager.sendGetFeatureSet(this.mMonitorMessenger, deviceData);
        }
    }
}

