/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.global_components;

import android.content.Context;
import android.net.Uri;
import android.support.annotation.Nullable;
import com.squareup.picasso.Picasso;
import com.taboola.android.api.TBImageErrorListener;
import com.taboola.android.listeners.TaboolaNativeListener;
import com.taboola.android.utils.Logger;

public class PicassoHelper {
    private static final String TAG = PicassoHelper.class.getSimpleName();
    private TaboolaNativeListener mTaboolaNativeListener;
    public static PicassoHelper sInstance;
    private Picasso mPicasso;
    private TBImageErrorListener mTBImageErrorListener;

    public static PicassoHelper getInstance() {
        if (sInstance == null) {
            sInstance = new PicassoHelper();
        }
        return sInstance;
    }

    private PicassoHelper() {
    }

    public void createPicasso(Context appCtx) {
        if (this.mPicasso == null) {
            Picasso.Builder builder = new Picasso.Builder(appCtx);
            builder.listener(new Picasso.Listener(){

                public void onImageLoadFailed(Picasso picasso, Uri uri, Exception e) {
                    Logger.e(TAG, "Fail to load image url: " + uri.toString(), e);
                    if (PicassoHelper.this.mTBImageErrorListener != null) {
                        PicassoHelper.this.mTBImageErrorListener.onImageLoadFailed(uri, e);
                    }
                    if (PicassoHelper.this.mTaboolaNativeListener != null) {
                        PicassoHelper.this.mTaboolaNativeListener.onImageLoadFailed(uri, e);
                    }
                }
            });
            this.mPicasso = builder.build();
        }
    }

    @Nullable
    public Picasso getPicasso() {
        return this.mPicasso;
    }

    public void setImageErrorListener(TBImageErrorListener tbImageErrorListener) {
        this.mTBImageErrorListener = tbImageErrorListener;
    }

    public void clearListeners() {
        this.mTBImageErrorListener = null;
        this.mTaboolaNativeListener = null;
    }

    public void setTaboolaNativeListener(TaboolaNativeListener taboolaNativeListener) {
        this.mTaboolaNativeListener = taboolaNativeListener;
    }
}

