/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.api;

import android.util.Log;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.taboola.android.api.TBPlacement;
import com.taboola.android.api.TBPublisherApi;
import com.taboola.android.api.TBRecommendationItem;
import com.taboola.android.api.TBRecommendationsResponse;
import com.taboola.android.api.TBTrackingPixel;
import com.taboola.android.utils.Logger;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class TypeAdapterTBRecommendationResponse {
    private static final String THUMBNAIL = "thumbnail";
    private static final String DESCRIPTION = "description";
    private static final String NAME = "name";
    private static final String BRANDING = "branding";
    private static final String ORIGIN = "origin";
    private static final String URL = "url";
    private static final String ID = "id";
    private static final String PIXELS = "pixels";
    private static final String SESSION = "session";
    private static final String TAG = TypeAdapterTBRecommendationResponse.class.getSimpleName();

    public TBRecommendationsResponse deserializeTBRecommendationsResponse(TBPublisherApi TBPublisherApi2, String publisherId, boolean overrideImageLoad, boolean isEnabledFullRawDataResponse, boolean isEnabledRawDataResponse, String jsonString) {
        JsonElement gsonDescriptor = new JsonParser().parse(jsonString);
        return new RecommendationResponseAdapter(TBPublisherApi2, publisherId, overrideImageLoad, isEnabledFullRawDataResponse, isEnabledRawDataResponse).deserialize(gsonDescriptor);
    }

    private static class RecommendationItemAdapter
    implements JsonDeserializer<TBRecommendationItem> {
        private final TBPublisherApi mTBPublisherApi;
        private final String mPublisherId;
        private Gson mGson;
        private boolean mOverrideImageLoad;
        private boolean mIsEnabledFullRawDataResponse;
        private boolean mIsEnabledRawDataResponse;

        RecommendationItemAdapter(TBPublisherApi TBPublisherApi2, String publisherId, boolean overrideImageLoad, boolean isEnabledFullRawDataResponse, boolean isEnabledRawDataResponse) {
            this.mTBPublisherApi = TBPublisherApi2;
            this.mPublisherId = publisherId;
            this.mOverrideImageLoad = overrideImageLoad;
            this.mIsEnabledFullRawDataResponse = isEnabledFullRawDataResponse;
            this.mIsEnabledRawDataResponse = isEnabledRawDataResponse;
            this.mGson = new GsonBuilder().excludeFieldsWithoutExposeAnnotation().create();
        }

        public TBRecommendationItem deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            TBRecommendationItem tbRecommendationItem = (TBRecommendationItem)this.mGson.fromJson(json, TBRecommendationItem.class);
            tbRecommendationItem.setPublisherId(this.mPublisherId);
            tbRecommendationItem.setTBPublisherApiInstance(this.mTBPublisherApi);
            JsonObject jsonObject = json.getAsJsonObject();
            JsonArray asJsonArray = jsonObject.getAsJsonArray(TypeAdapterTBRecommendationResponse.PIXELS);
            if (asJsonArray != null) {
                try {
                    HashMap<String, List<String>> trackingPixelMap = new HashMap<String, List<String>>();
                    for (JsonElement jsonTrackingPixelElement : asJsonArray) {
                        final TBTrackingPixel pixel = (TBTrackingPixel)this.mGson.fromJson(jsonTrackingPixelElement, TBTrackingPixel.class);
                        if (trackingPixelMap.containsKey(pixel.getEvent())) {
                            List<String> urls = trackingPixelMap.get(pixel.getEvent());
                            urls.add(pixel.getUrl());
                            trackingPixelMap.put(pixel.getEvent(), urls);
                            continue;
                        }
                        trackingPixelMap.put(pixel.getEvent(), (List<String>)new ArrayList<String>(){
                            {
                                this.add(pixel.getUrl());
                            }
                        });
                    }
                    tbRecommendationItem.setTrackingPixelMap(trackingPixelMap);
                }
                catch (Exception e) {
                    Logger.e("TaboolaApi", "TBRecommendationItem deserialize error: " + e.getLocalizedMessage());
                }
            }
            if (!this.mIsEnabledFullRawDataResponse) {
                HashSet<String> privateKeys = new HashSet<String>();
                privateKeys.add(TypeAdapterTBRecommendationResponse.ORIGIN);
                privateKeys.add(TypeAdapterTBRecommendationResponse.URL);
                privateKeys.add(TypeAdapterTBRecommendationResponse.ID);
                privateKeys.add(TypeAdapterTBRecommendationResponse.PIXELS);
                for (String privateKey : privateKeys) {
                    jsonObject.remove(privateKey);
                }
            }
            if (!this.mIsEnabledRawDataResponse && !this.mIsEnabledFullRawDataResponse) {
                HashSet<String> rawDataKeys = new HashSet<String>();
                if (!this.mOverrideImageLoad) {
                    rawDataKeys.add(TypeAdapterTBRecommendationResponse.THUMBNAIL);
                }
                rawDataKeys.add(TypeAdapterTBRecommendationResponse.DESCRIPTION);
                rawDataKeys.add(TypeAdapterTBRecommendationResponse.NAME);
                rawDataKeys.add(TypeAdapterTBRecommendationResponse.BRANDING);
                for (String rawDataKey : rawDataKeys) {
                    jsonObject.remove(rawDataKey);
                }
            }
            HashMap<String, String> extraDataMap = new HashMap<String, String>();
            for (Map.Entry elementJson : jsonObject.entrySet()) {
                JsonElement value = (JsonElement)elementJson.getValue();
                if (value == null) {
                    Log.d((String)TAG, (String)"Deserialize: Value is null.");
                    continue;
                }
                if (value.isJsonObject() || value.isJsonPrimitive()) {
                    extraDataMap.put((String)elementJson.getKey(), value.getAsString());
                    continue;
                }
                if (value.isJsonArray()) {
                    extraDataMap.put((String)elementJson.getKey(), value.toString());
                    continue;
                }
                Logger.e(TAG, "Deserialize: Unrecognized value in recommendations response json.");
            }
            tbRecommendationItem.setExtraDataMap(extraDataMap);
            return tbRecommendationItem;
        }
    }

    public static class RecommendationResponseAdapter {
        private final String mPublisherId;
        private final TBPublisherApi mTBPublisherApi;
        private Gson mGson;

        public RecommendationResponseAdapter(TBPublisherApi TBPublisherApi2, String publisherId, boolean overrideImageLoad, boolean isEnabledFullRawDataResponse, boolean isEnabledRawDataResponse) {
            this.mTBPublisherApi = TBPublisherApi2;
            this.mPublisherId = publisherId;
            this.mGson = new GsonBuilder().excludeFieldsWithoutExposeAnnotation().registerTypeAdapter(TBRecommendationItem.class, (Object)new RecommendationItemAdapter(this.mTBPublisherApi, this.mPublisherId, overrideImageLoad, isEnabledFullRawDataResponse, isEnabledRawDataResponse)).create();
        }

        public TBRecommendationsResponse deserialize(JsonElement json) {
            Logger.d("TaboolaApi", "response json : " + json);
            TBRecommendationsResponse response = new TBRecommendationsResponse();
            HashMap<String, TBPlacement> placementMap = new HashMap<String, TBPlacement>();
            for (Map.Entry elementJson : json.getAsJsonObject().entrySet()) {
                if (((String)elementJson.getKey()).equalsIgnoreCase(TypeAdapterTBRecommendationResponse.SESSION)) {
                    String session = ((JsonElement)elementJson.getValue()).getAsString();
                    response.setSession(session);
                    continue;
                }
                TBPlacement placement = (TBPlacement)this.mGson.fromJson((JsonElement)elementJson.getValue(), TBPlacement.class);
                placement.setTBPublisherApi(this.mTBPublisherApi);
                placement.setPublisherId(this.mPublisherId);
                for (TBRecommendationItem item : placement.getItems()) {
                    item.setPlacement(placement);
                }
                placementMap.put((String)elementJson.getKey(), placement);
            }
            response.setPlacementsMap(placementMap);
            return response;
        }
    }
}

