/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android;

import android.content.Context;
import android.support.annotation.ColorInt;
import android.support.annotation.Keep;
import android.text.TextUtils;
import com.taboola.android.PublisherInfo;
import com.taboola.android.TaboolaHybrid;
import com.taboola.android.global_components.advertisingid.AdvertisingIdInfo;
import com.taboola.android.global_components.configuration.ConfigManager;
import com.taboola.android.global_components.monitor.MonitorHelper;
import com.taboola.android.global_components.network.NetworkManager;
import com.taboola.android.integration_verifier.IntegrationVerifier;
import com.taboola.android.listeners.TaboolaHybridListener;
import com.taboola.android.utils.Logger;
import java.util.HashMap;

@Keep
public class TaboolaHybridBuilder {
    private static final String TAG = TaboolaHybridBuilder.class.getSimpleName();
    private static final int PROGRESS_COLOR_NOT_SET = -1;
    private static final float PROGRESS_BAR_DURATION_NOT_SET = -1.0f;
    private IntegrationVerifier mIntegrationVerifier;
    private MonitorHelper mMonitorHelper;
    private NetworkManager mNetworkManager;
    private ConfigManager mConfigManager;
    private Context mContext;
    private String mPageUrl;
    private String mPageType;
    private PublisherInfo mPublisherInfo;
    AdvertisingIdInfo mAdvertisingIdInfo;
    private boolean mProgressBarEnabled;
    private int mProgressColor = -1;
    private float mProgressBarDuration = -1.0f;
    private String mOptionalWidgetStyle;
    private boolean mAutoResizeHeight = true;
    private boolean mAutoResizeHeightWasSetByPublisher = false;
    private String mMediatedVia;
    private String mUserId;
    private String mTargetType = "mix";
    private String mPageId = "auto";
    private HashMap<String, String> mExtraProperties;
    private String mPublisher;
    private String mTag;

    TaboolaHybridBuilder(Context context, IntegrationVerifier integrationVerifier, NetworkManager networkManager, ConfigManager configManager, PublisherInfo publisherInfo, AdvertisingIdInfo advertisingIdInfo, MonitorHelper monitorHelper) {
        this.mIntegrationVerifier = integrationVerifier;
        this.mNetworkManager = networkManager;
        this.mConfigManager = configManager;
        this.mPublisherInfo = publisherInfo;
        this.mAdvertisingIdInfo = advertisingIdInfo;
        this.mMonitorHelper = monitorHelper;
        this.mContext = context;
    }

    public TaboolaHybridBuilder setPageUrl(String pageUrl) {
        this.mPageUrl = pageUrl;
        return this;
    }

    public TaboolaHybridBuilder setPageType(String pageType) {
        this.mPageType = pageType;
        return this;
    }

    public TaboolaHybridBuilder setProgressBarEnabled(boolean progressBarEnabled) {
        this.mProgressBarEnabled = progressBarEnabled;
        return this;
    }

    public TaboolaHybridBuilder setProgressBarColor(@ColorInt int progressColor) {
        this.mProgressColor = progressColor;
        return this;
    }

    public TaboolaHybridBuilder setProgressBarDuration(float progressBarDuration) {
        this.mProgressBarDuration = progressBarDuration;
        return this;
    }

    public TaboolaHybridBuilder setOptionalWidgetStyle(String optionalWidgetStyle) {
        this.mOptionalWidgetStyle = optionalWidgetStyle;
        return this;
    }

    public TaboolaHybridBuilder setAutoResizeHeight(boolean autoResizeHeight) {
        this.mAutoResizeHeight = autoResizeHeight;
        this.mAutoResizeHeightWasSetByPublisher = true;
        return this;
    }

    public TaboolaHybridBuilder setMediatedVia(String mediatedVia) {
        this.mMediatedVia = mediatedVia;
        return this;
    }

    public TaboolaHybridBuilder setUserId(String userId) {
        this.mUserId = userId;
        return this;
    }

    public TaboolaHybridBuilder setTargetType(String targetType) {
        this.mTargetType = targetType;
        return this;
    }

    public TaboolaHybridBuilder setPageId(String pageId) {
        this.mPageId = pageId;
        return this;
    }

    public TaboolaHybridBuilder setExtraProperties(HashMap<String, String> extraProperties) {
        this.mExtraProperties = extraProperties;
        return this;
    }

    public TaboolaHybridBuilder setPublisher(String publisher) {
        this.mPublisher = publisher;
        return this;
    }

    public TaboolaHybridBuilder setTag(String tag) {
        this.mTag = tag;
        return this;
    }

    public TaboolaHybrid build(String placement, String mode, int placementType, TaboolaHybridListener taboolaHybridListener) {
        if (taboolaHybridListener == null) {
            Logger.e(TAG, "taboolaHybridListener is null, did you forget");
        }
        TaboolaHybrid taboolaHybrid = new TaboolaHybrid(this.mContext, taboolaHybridListener, this.mIntegrationVerifier, this.mNetworkManager, this.mConfigManager, this.mPublisherInfo, this.mAdvertisingIdInfo, this.mMonitorHelper);
        taboolaHybrid.setPlacementType(placementType);
        taboolaHybrid.setPageUrl(this.mPageUrl);
        taboolaHybrid.setPageType(this.mPageType);
        taboolaHybrid.setPlacement(placement);
        taboolaHybrid.setMode(mode);
        taboolaHybrid.setProgressBarEnabled(this.mProgressBarEnabled);
        if (this.mProgressColor != -1) {
            taboolaHybrid.setProgressBarColor(this.mProgressColor);
        }
        if (this.mProgressBarDuration != -1.0f) {
            taboolaHybrid.setProgressBarDuration(this.mProgressBarDuration);
        }
        if (!TextUtils.isEmpty((CharSequence)this.mOptionalWidgetStyle)) {
            taboolaHybrid.setOptionalWidgetStyle(this.mOptionalWidgetStyle);
        }
        if (this.mAutoResizeHeightWasSetByPublisher) {
            taboolaHybrid.setAutoResizeHeight(this.mAutoResizeHeight);
        }
        if (!TextUtils.isEmpty((CharSequence)this.mMediatedVia)) {
            taboolaHybrid.setMediatedVia(this.mMediatedVia);
        }
        if (!TextUtils.isEmpty((CharSequence)this.mUserId)) {
            taboolaHybrid.setUserId(this.mUserId);
        }
        if (!TextUtils.isEmpty((CharSequence)this.mTargetType)) {
            taboolaHybrid.setTargetType(this.mTargetType);
        }
        if (!TextUtils.isEmpty((CharSequence)this.mPageId)) {
            taboolaHybrid.setPageId(this.mPageId);
        }
        if (this.mExtraProperties != null) {
            taboolaHybrid.setExtraProperties(this.mExtraProperties);
        }
        if (!TextUtils.isEmpty((CharSequence)this.mPublisher)) {
            taboolaHybrid.setPublisher(this.mPublisher);
        }
        if (!TextUtils.isEmpty((CharSequence)this.mTag)) {
            taboolaHybrid.setTag(this.mTag);
        }
        switch (placementType) {
            case 0: {
                taboolaHybrid.setInterceptScroll(false);
                taboolaHybrid.setProgressBarEnabled(false);
                break;
            }
            case 1: {
                taboolaHybrid.setInterceptScroll(true);
                taboolaHybrid.setProgressBarEnabled(true);
                break;
            }
            case 2: {
                taboolaHybrid.setInterceptScroll(true);
                taboolaHybrid.setProgressBarEnabled(true);
                if (!this.mAutoResizeHeightWasSetByPublisher) break;
                Logger.e(TAG, "Feed type widget does not allow calling setAutoResizeHeight(), changing value to false");
                taboolaHybrid.setAutoResizeHeight(false);
                break;
            }
        }
        return taboolaHybrid;
    }
}

