/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Build;
import android.os.Handler;
import android.support.annotation.ColorInt;
import android.support.annotation.Keep;
import android.support.annotation.NonNull;
import android.util.AttributeSet;
import android.webkit.CookieManager;
import com.taboola.android.ITaboolaImpl;
import com.taboola.android.PublisherInfo;
import com.taboola.android.Taboola;
import com.taboola.android.TaboolaHybridParent;
import com.taboola.android.global_components.advertisingid.AdvertisingIdInfo;
import com.taboola.android.global_components.configuration.ConfigManager;
import com.taboola.android.global_components.monitor.MonitorHelper;
import com.taboola.android.global_components.network.NetworkManager;
import com.taboola.android.integration_verifier.IntegrationVerifier;
import com.taboola.android.js.TaboolaWeb;
import com.taboola.android.js.TaboolaWebBuilder;
import com.taboola.android.listeners.TaboolaHybridListener;
import com.taboola.android.listeners.TaboolaUpdateContentListener;
import com.taboola.android.listeners.TaboolaWebListener;
import com.taboola.android.utils.Logger;
import com.taboola.android.utils.SdkDetailsHelper;
import com.taboola.android.utils.VisibilityUtil;
import java.util.HashMap;

@Keep
public class TaboolaHybrid
extends TaboolaHybridParent {
    private static final String TAG = TaboolaHybrid.class.getSimpleName();
    private TaboolaWeb mTaboolaWeb;
    private NetworkManager mNetworkManager;
    private ConfigManager mConfigManager;
    private int mPlacementType;

    TaboolaHybrid(Context context, TaboolaHybridListener taboolaHybridListener, IntegrationVerifier integrationVerifier, NetworkManager networkManager, ConfigManager configManager, PublisherInfo publisherInfo, AdvertisingIdInfo advertisingIdInfo, MonitorHelper monitorHelper) {
        super(context);
        this.mIntegrationVerifier = integrationVerifier;
        this.mMonitorHelper = monitorHelper;
        this.mNetworkManager = networkManager;
        this.mConfigManager = configManager;
        this.mPublisherInfo = publisherInfo;
        this.mAdvertisingIdInfo = advertisingIdInfo;
        this.mTaboolaHybridListener = taboolaHybridListener;
        this.initWidgetSettings();
        this.initTaboolaJS();
    }

    public TaboolaHybrid(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.constructXMLCommon(context, attrs);
    }

    public TaboolaHybrid(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.constructXMLCommon(context, attrs);
    }

    private void constructXMLCommon(Context context, AttributeSet attrs) {
        this.getGlobalComponentsStatically();
        this.initWidgetSettings();
        this.initTaboolaJS();
        this.parseXmlAttributes(context, attrs);
        Logger.d(TAG, "initialized basic components");
    }

    private void getGlobalComponentsStatically() {
        ITaboolaImpl taboolaImpl = Taboola.getTaboolaImpl();
        this.mPublisherInfo = taboolaImpl.getPublisherInfo();
        this.mAdvertisingIdInfo = taboolaImpl.getAdvertisingIdInfo();
        this.mIntegrationVerifier = taboolaImpl.getIntegrationVerifier();
        this.mMonitorHelper = taboolaImpl.getMonitorHelper();
        this.mNetworkManager = taboolaImpl.getNetworkManager();
        this.mConfigManager = taboolaImpl.loadAndGetConfigManager();
    }

    @SuppressLint(value={"SetJavaScriptEnabled"})
    protected void initTaboolaJS() {
        CookieManager.getInstance().setAcceptCookie(true);
        this.updateScrollBehaviour();
        this.mTaboolaWeb = new TaboolaWebBuilder(this.mIntegrationVerifier, this.mNetworkManager, this.mConfigManager, this.mAdvertisingIdInfo, this.mMonitorHelper, true).build(this, new TaboolaWebListener(){

            @Override
            public boolean onItemClick(String placementName, String itemId, String clickUrl, boolean isOrganic) {
                if (TaboolaHybrid.this.mTaboolaHybridListener != null) {
                    return TaboolaHybrid.this.mTaboolaHybridListener.onItemClick(placementName, itemId, clickUrl, isOrganic);
                }
                return true;
            }

            @Override
            public void onUpdateContentCompleted() {
                if (TaboolaHybrid.this.mTaboolaHybridListener != null) {
                    TaboolaHybrid.this.mTaboolaHybridListener.onUpdateContentCompleted();
                }
            }

            @Override
            public void onEvent(int actionType, String data) {
                if (TaboolaHybrid.this.mTaboolaHybridListener != null) {
                    TaboolaHybrid.this.mTaboolaHybridListener.onEvent(actionType, data);
                }
            }

            @Override
            public void onRenderSuccessful(String placementName, int height) {
                if (Build.VERSION.SDK_INT <= 19) {
                    TaboolaHybrid.this.startInvalidationOnScrollEvents(TaboolaHybrid.this);
                    new Handler().postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            TaboolaHybrid.this.invalidateWebView(TaboolaHybrid.this);
                        }
                    }, 3000L);
                }
                Logger.d(TAG, "onRenderSuccessful: " + placementName);
                TaboolaHybrid.this.dispatchLoadSuccessful();
            }

            @Override
            public void onRenderFailed(String placementName, String errorMessage) {
                Logger.e(TAG, "onRenderFailed: " + placementName + " " + errorMessage);
                TaboolaHybrid.this.dispatchLoadFailed(errorMessage);
            }

            @Override
            public void onResize(String placementName, int height) {
                int heightPx = VisibilityUtil.convertCssPixelToPixel(height);
                TaboolaHybrid.this.resizeWidget(TaboolaHybrid.this.mTaboolaWeb, TaboolaHybrid.this.mTaboolaWeb.getWebViewManager(), heightPx);
                if (TaboolaHybrid.this.mTaboolaHybridListener != null) {
                    TaboolaHybrid.this.mTaboolaHybridListener.onResize(height);
                }
            }

            @Override
            public void onOrientationChange(int height) {
                int heightPx = VisibilityUtil.convertCssPixelToPixel(height);
                TaboolaHybrid.this.onOrientationChange(heightPx);
            }
        });
    }

    protected void onOrientationChange(int heightPx) {
        super.onOrientationChange(this.mTaboolaWeb, this.mTaboolaWeb.getWebViewManager(), heightPx);
    }

    @Override
    protected void clearTaboolaWebInstance() {
        if (this.mTaboolaWeb != null) {
            this.mTaboolaWeb.clear();
            this.mTaboolaWeb = null;
        }
    }

    @Override
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.mPlacementType == 2) {
            this.getLayoutParams().height = SdkDetailsHelper.getDisplayHeight(this.getContext()) * 2;
        }
    }

    @Override
    public void notifyUpdateHeight() {
        this.mTaboolaWeb.notifyUpdateHeight();
    }

    public TaboolaHybrid fetchContent() {
        super.fetchContent(this.mTaboolaWeb, this.mTaboolaWeb.getWebViewManager());
        return this;
    }

    public TaboolaHybrid refresh() {
        super.refresh(this.mTaboolaWeb, this.mTaboolaWeb.getWebViewManager());
        return this;
    }

    public TaboolaHybrid reset() {
        super.reset();
        return this;
    }

    @Override
    public void showProgressBar() {
        this.mTaboolaWeb.showProgressBar();
    }

    TaboolaHybrid setAutoResizeHeight(boolean shouldAutoResizeHeight) {
        super.setAutoResizeHeight(shouldAutoResizeHeight);
        return this;
    }

    @Override
    public boolean isAutoResizeHeight() {
        return super.isAutoResizeHeight();
    }

    TaboolaHybrid setScrollEnabled(boolean isScrollEnabled) {
        super.setScrollEnabled(isScrollEnabled);
        return this;
    }

    @Override
    public boolean isScrollEnabled() {
        return super.isScrollEnabled();
    }

    public TaboolaHybrid setOptionalWidgetStyle(String newCSSStyle) {
        super.setOptionalWidgetStyle(newCSSStyle);
        return this;
    }

    @Override
    public String getOptionalWidgetStyle() {
        return super.getOptionalWidgetStyle();
    }

    public TaboolaHybrid setMediatedVia(String mediatedVia) {
        super.setMediatedVia(mediatedVia);
        return this;
    }

    @Override
    public void setInterceptScroll(boolean bIntercept) {
        super.setInterceptScroll(bIntercept);
    }

    @Override
    public String getPublisher() {
        return super.getPublisher();
    }

    public TaboolaHybrid setPublisher(String newPub) {
        super.setPublisher(newPub);
        return this;
    }

    public TaboolaHybrid setViewId(String viewID) {
        super.setViewId(viewID);
        return this;
    }

    public TaboolaHybrid setTag(@NonNull String tag) {
        this.mTaboolaWeb.setTag(tag);
        return this;
    }

    @Override
    public String getMode() {
        return super.getMode();
    }

    public TaboolaHybrid setMode(String newMode) {
        super.setMode(newMode);
        return this;
    }

    @Override
    public String getPlacement() {
        return super.getPlacement();
    }

    public TaboolaHybrid setPlacement(String newPlacement) {
        super.setPlacement(newPlacement);
        return this;
    }

    @Override
    public String getPageType() {
        return super.getPageType();
    }

    public TaboolaHybrid setPageType(String newPageType) {
        super.setPageType(newPageType);
        return this;
    }

    @Override
    public String getTargetType() {
        return super.getTargetType();
    }

    public TaboolaHybrid setTargetType(String newTargetType) {
        super.setTargetType(newTargetType);
        return this;
    }

    @Override
    public String getPageUrl() {
        return super.getPageUrl();
    }

    public TaboolaHybrid setPageUrl(String newPageUrl) {
        super.setPageUrl(newPageUrl);
        return this;
    }

    @Override
    public String getPageId() {
        return this.mPageId;
    }

    public TaboolaHybrid setPageId(String newPageId) {
        super.setPageId(newPageId);
        return this;
    }

    public TaboolaHybrid setProgressBarEnabled(boolean isEnabled) {
        super.setProgressBarEnabled(isEnabled);
        return this;
    }

    public TaboolaHybrid setProgressBarColor(@ColorInt int progressColor) {
        super.setProgressBarColor(progressColor);
        return this;
    }

    public TaboolaHybrid setProgressBarDuration(float duration) {
        super.setProgressBarDuration(duration);
        return this;
    }

    @Override
    @Deprecated
    public boolean isItemClickEnabled() {
        return super.isItemClickEnabled();
    }

    @Override
    @Deprecated
    public void setItemClickEnabled(boolean isItemClickEnabled) {
        super.setFocusableInTouchMode(isItemClickEnabled);
    }

    public int getTextZoom() {
        return this.getSettings().getTextZoom();
    }

    public TaboolaHybrid setTextZoom(int textZoom) {
        this.getSettings().setTextZoom(textZoom);
        return this;
    }

    public TaboolaHybrid setExtraProperties(HashMap<String, String> extraProperties) {
        super.setExtraProperties(extraProperties);
        return this;
    }

    @Deprecated
    public TaboolaHybrid setOptionalPageCommands(HashMap<String, String> arrCommands) {
        super.setOptionalPageCommands(arrCommands);
        return this;
    }

    @Deprecated
    public TaboolaHybrid setOptionalModeCommands(HashMap<String, String> arrCommands) {
        super.pushCommands(arrCommands);
        return this;
    }

    @Override
    @Deprecated
    public void pushCommands(HashMap<String, String> arrCommands) {
        super.pushCommands(arrCommands);
    }

    public TaboolaHybrid setAction(int actionType, String data) {
        super.setAction(actionType, data);
        return this;
    }

    public TaboolaHybrid setUserId(String userId) {
        this.mUserId = userId;
        this.mTaboolaWeb.setUserId(userId);
        return this;
    }

    public void setTaboolaListener(TaboolaHybridListener taboolaHybridListener) {
        this.mTaboolaHybridListener = taboolaHybridListener;
    }

    @Override
    public void updateContent(TaboolaUpdateContentListener updateContentListener) {
        this.mTaboolaWeb.updateContent(updateContentListener);
    }

    public void updateAction(int actionType, String actionString) {
        this.mTaboolaWeb.updatePassedAction(actionType, actionString);
    }

    public void setPlacementType(int placementType) {
        this.mPlacementType = placementType;
    }
}

