/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.global_components.gueh;

import android.content.Context;
import android.support.annotation.Keep;
import com.taboola.android.global_components.gueh.SDKExceptionHandler;
import com.taboola.android.global_components.gueh.TaboolaExceptionHandler;
import com.taboola.android.global_components.network.NetworkManager;
import com.taboola.android.utils.Logger;
import java.util.ArrayList;

public abstract class GlobalUncaughtExceptionHandler {
    @Keep
    protected static final String TAG = GlobalUncaughtExceptionHandler.class.getSimpleName();
    private Thread.UncaughtExceptionHandler mTaboolaGenericExceptionHandler;
    protected Thread.UncaughtExceptionHandler mAndroidDefaultHandler;
    protected Throwable mLastThrownException;
    protected ArrayList<TaboolaExceptionHandler> mTaboolaExceptionHandlerList;
    private boolean mIsEnabled;

    public GlobalUncaughtExceptionHandler(NetworkManager networkManager, Context context) {
        this.mIsEnabled = false;
        this.mTaboolaExceptionHandlerList = new ArrayList();
        this.registerExceptionHandler(new SDKExceptionHandler(context, networkManager));
        this.mTaboolaGenericExceptionHandler = this.getGUEHBehaviour();
    }

    protected abstract Thread.UncaughtExceptionHandler getGUEHBehaviour();

    public void registerExceptionHandler(TaboolaExceptionHandler taboolaExceptionHandler) {
        this.mTaboolaExceptionHandlerList.add(taboolaExceptionHandler);
    }

    protected boolean checkSameException(Throwable ex, Throwable lastThrownException) {
        if (ex != null && ex.getLocalizedMessage() != null && lastThrownException != null && lastThrownException.getLocalizedMessage() != null) {
            Logger.d(TAG, "Incoming exception is the same as last one thrown in this session. Suspecting cycle, not handling.");
            return ex.getLocalizedMessage().equals(lastThrownException.getLocalizedMessage());
        }
        return false;
    }

    public GlobalUncaughtExceptionHandler(Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
        this.mTaboolaGenericExceptionHandler = uncaughtExceptionHandler;
    }

    public GlobalUncaughtExceptionHandler start() {
        Thread.UncaughtExceptionHandler currentUncaughtExceptionHandler = Thread.getDefaultUncaughtExceptionHandler();
        if (this.checkRedundantStart(currentUncaughtExceptionHandler)) {
            Logger.e(TAG, "GlobalUncaughtExceptionHandler | start | redundantStart detected, not setting GUEH.");
            return this;
        }
        this.mAndroidDefaultHandler = currentUncaughtExceptionHandler;
        Thread.setDefaultUncaughtExceptionHandler(this.mTaboolaGenericExceptionHandler);
        this.mIsEnabled = true;
        return this;
    }

    private boolean checkRedundantStart(Thread.UncaughtExceptionHandler currentUncaughtExceptionHandler) {
        if (currentUncaughtExceptionHandler != null && currentUncaughtExceptionHandler.toString().contains(TAG)) {
            Logger.d(TAG, "GlobalUncaughtExceptionHandler | start | GUEH.start() found current handler to be GUEH, avoiding looping error.");
            return true;
        }
        return false;
    }

    public void stop() {
        Thread.setDefaultUncaughtExceptionHandler(this.mAndroidDefaultHandler);
        this.mIsEnabled = false;
    }

    public void toggle(boolean enableGUEH) {
        if (enableGUEH && !this.mIsEnabled) {
            this.start();
        } else if (!enableGUEH && this.mIsEnabled) {
            this.stop();
        }
    }

    public boolean isEnabled() {
        return this.mIsEnabled;
    }
}

