/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.global_components.network;

import android.content.Context;
import android.support.annotation.Keep;
import com.taboola.android.global_components.network.handlers.BintrayHandler;
import com.taboola.android.global_components.network.handlers.EventsManagerHandler;
import com.taboola.android.global_components.network.handlers.KibanaHandler;
import com.taboola.android.global_components.network.handlers.KustoHandler;
import com.taboola.android.global_components.network.handlers.TrackingHandler;
import com.taboola.lightnetwork.LightNetwork;
import com.taboola.lightnetwork.State;
import com.taboola.lightnetwork.protocols.http.HttpManager;

@Keep
public class NetworkManager {
    private final LightNetwork mLightNetwork;
    private final KibanaHandler mKibanaHandler;
    private final BintrayHandler mBintrayHandler;
    private final TrackingHandler mTrackingHandler;
    private final EventsManagerHandler mEventsManagerHandler;
    private final KustoHandler mKustoHandler;

    public NetworkManager(Context context) {
        this(context, new KibanaHandler(), new BintrayHandler(), new TrackingHandler(), new EventsManagerHandler(), new KustoHandler());
    }

    public NetworkManager(Context context, KibanaHandler kibanaHandler, BintrayHandler bintrayHandler, TrackingHandler trackingHandler, EventsManagerHandler eventsManagerHandler, KustoHandler kustoHandler) {
        this.mLightNetwork = new LightNetwork(context);
        this.mKibanaHandler = kibanaHandler;
        this.mBintrayHandler = bintrayHandler;
        this.mTrackingHandler = trackingHandler;
        this.mEventsManagerHandler = eventsManagerHandler;
        this.mKustoHandler = kustoHandler;
        HttpManager httpManager = this.mLightNetwork.getHttpManager();
        this.mKibanaHandler.setHttpManager(httpManager);
        this.mBintrayHandler.setHttpManager(httpManager);
        this.mTrackingHandler.setHttpManager(httpManager);
        this.mEventsManagerHandler.setHttpManager(httpManager);
        this.mKustoHandler.setHttpManager(httpManager);
    }

    public HttpManager getHttpManager() {
        return this.mLightNetwork.getHttpManager();
    }

    public State getState() {
        return this.mLightNetwork.getState();
    }

    public KibanaHandler getKibanaHandler() {
        return this.mKibanaHandler;
    }

    public BintrayHandler getBintrayHandler() {
        return this.mBintrayHandler;
    }

    public TrackingHandler getTrackingHandler() {
        return this.mTrackingHandler;
    }

    public EventsManagerHandler getEventsManagerHandler() {
        return this.mEventsManagerHandler;
    }

    public KustoHandler getKustoHandler() {
        return this.mKustoHandler;
    }
}

