/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.global_components.network.requests.kusto;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.text.TextUtils;
import com.taboola.android.Taboola;
import com.taboola.android.global_components.advertisingid.AdvertisingIdInfo;
import com.taboola.android.utils.JSONUtils;
import com.taboola.android.utils.SdkDetailsHelper;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class KustoRequest {
    private static final String SDK_VERSION = "sdk_version";
    private static final String APP_NAME = "app";
    private static final String APP_VERSION = "app_version";
    private static final String APP_ID = "appid";
    private static final String DEVICE_MODEL = "model";
    private static final String OS = "os_name";
    private static final String OS_VERSION = "os_version";
    private static final String ANDROID = "Android";
    private static final String DEVICE_ID = "device_id";
    private static final String EVENT_TYPE = "event_type";
    private static final String TIME = "time";
    private static final String DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    private final Context mContext;

    public KustoRequest(Context context) {
        this.mContext = context;
    }

    public JSONObject getJsonBody() throws JSONException, PackageManager.NameNotFoundException {
        JSONObject jsonReportBody = new JSONObject();
        String deviceId = null;
        AdvertisingIdInfo advertisingIdInfo = Taboola.getTaboolaImpl().getAdvertisingIdInfo();
        if (advertisingIdInfo != null) {
            deviceId = advertisingIdInfo.getAdvertisingId();
        }
        jsonReportBody.put(DEVICE_ID, JSONUtils.getJsonNullIfNeeded(deviceId));
        jsonReportBody.put(EVENT_TYPE, (Object)this.getEventType());
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT, Locale.US);
        jsonReportBody.put(TIME, (Object)sdf.format(new Date(System.currentTimeMillis())));
        PackageInfo packageInfo = SdkDetailsHelper.getPackageInfo(this.mContext);
        jsonReportBody.put(APP_VERSION, JSONUtils.getJsonNullIfNeeded(packageInfo.versionName));
        jsonReportBody.put(APP_ID, JSONUtils.getJsonNullIfNeeded(packageInfo.packageName));
        jsonReportBody.put(SDK_VERSION, (Object)"2.3.5-50243-8");
        jsonReportBody.put(APP_NAME, (Object)TextUtils.htmlEncode((String)SdkDetailsHelper.getApplicationName(this.mContext)));
        jsonReportBody.put(DEVICE_MODEL, (Object)TextUtils.htmlEncode((String)SdkDetailsHelper.getDeviceName()));
        jsonReportBody.put(OS, (Object)ANDROID);
        jsonReportBody.put(OS_VERSION, (Object)Build.VERSION.RELEASE);
        return jsonReportBody;
    }

    abstract String getEventType();

    abstract String getTag();
}

