/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.lightnetwork.protocols.http;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import com.taboola.lightnetwork.utils.SharedPrefUtil;
import java.net.HttpURLConnection;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CookiesTracker {
    private static final String TAG = CookiesTracker.class.getSimpleName();
    private static final String HEADER_DELIMITER = ";";
    private Context mApplicationContext;

    CookiesTracker(Context context) {
        this.mApplicationContext = context;
    }

    public synchronized void setCookiesInRequest(HttpURLConnection connection, String trackHeadersByGroup) {
        HashMap<String, String> taboolaHeaderFields;
        if (trackHeadersByGroup != null && (taboolaHeaderFields = SharedPrefUtil.getTrackHeadersMap(this.mApplicationContext, trackHeadersByGroup)) != null) {
            Log.d((String)TAG, (String)("Url = " + connection.getURL() + ", trackHeadersByGroup = " + trackHeadersByGroup + ", setHeadersInRequest: " + Arrays.toString(taboolaHeaderFields.entrySet().toArray())));
            this.addHeaderMapToRequest(connection, taboolaHeaderFields);
        }
    }

    private void addHeaderMapToRequest(HttpURLConnection connection, Map<String, String> headers) {
        for (Map.Entry<String, String> header : headers.entrySet()) {
            connection.setRequestProperty(header.getKey(), header.getValue());
        }
    }

    public synchronized void getCookiesFromResponse(HttpURLConnection connection, String trackHeadersKey, String trackHeadersByGroup) {
        if (trackHeadersKey != null && trackHeadersByGroup != null) {
            Map<String, List<String>> headerFields = connection.getHeaderFields();
            HashMap<String, String> taboolaHeaderFields = new HashMap<String, String>();
            for (Map.Entry<String, List<String>> entry : headerFields.entrySet()) {
                String key = entry.getKey();
                if (key == null || !key.toLowerCase().contains(trackHeadersKey)) continue;
                try {
                    taboolaHeaderFields.put(key, TextUtils.join((CharSequence)HEADER_DELIMITER, (Iterable)entry.getValue()));
                    Log.d((String)TAG, (String)("getHeadersFromResponse: " + Arrays.toString(taboolaHeaderFields.entrySet().toArray())));
                }
                catch (Exception e) {
                    Log.e((String)TAG, (String)("Problem parsing headers. Error: " + e.getLocalizedMessage()), (Throwable)e);
                }
            }
            Log.d((String)TAG, (String)("Url = " + connection.getURL() + ", trackHeadersByGroup = " + trackHeadersByGroup + ", getHeadersFromResponse: " + Arrays.toString(taboolaHeaderFields.entrySet().toArray())));
            SharedPrefUtil.setTrackHeadersMap(this.mApplicationContext, taboolaHeaderFields, trackHeadersByGroup);
        }
    }
}

