/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.utils;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageManager;
import android.os.Handler;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Parcel;
import android.os.RemoteException;
import android.support.annotation.Nullable;
import com.taboola.android.utils.Logger;
import java.io.IOException;
import java.util.concurrent.LinkedBlockingQueue;

public final class AdvertisingIdClient {
    private static final String TAG = AdvertisingIdClient.class.getSimpleName();
    private static String sGaidFromMemory;
    private static boolean sIsLimitedAdTrackingEnabled;

    @Deprecated
    public static String getCachedAdvertisingId(Context context) {
        return AdvertisingIdClient.getAdvertisingIdFromMemory();
    }

    public static String getAdvertisingIdFromMemory() {
        return sGaidFromMemory;
    }

    public static boolean isLimitedAdTrackingEnabled() {
        return sIsLimitedAdTrackingEnabled;
    }

    public static void updateCachedAdvertisingIdAsync(final Context context) {
        Logger.d(TAG, "updateCachedAdvertisingIdAsync :: called");
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    AdInfo adInfo = AdvertisingIdClient.getAdvertisingIdInfo(context);
                    String advertisingId = adInfo.getId();
                    Logger.d(TAG, "updateCachedAdvertisingIdAsync :: advertisingId = " + advertisingId);
                    sGaidFromMemory = advertisingId;
                    sIsLimitedAdTrackingEnabled = adInfo.isLimitAdTrackingEnabled();
                    if (sIsLimitedAdTrackingEnabled) {
                        Logger.d(TAG, "updateCachedAdvertisingIdAsync :: sLimitAdTrackingEnabled() == true. Mark user as opt_out");
                    }
                }
                catch (Exception e) {
                    Logger.d(TAG, "updateCachedAdvertisingIdAsync :: failed");
                    Logger.e(TAG, "updateCachedAdvertisingIdAsync :: failed", e);
                }
            }
        }).start();
    }

    public static void updateAdvertisingIdAsync(final Context context, final @Nullable AdvertisingIdCallback callback) {
        Logger.d(TAG, "updateAdvertisingIdAsync :: called");
        new Thread(new Runnable(){

            @Override
            public void run() {
                Handler mainHandler = new Handler(context.getMainLooper());
                try {
                    AdInfo adInfo = AdvertisingIdClient.getAdvertisingIdInfo(context);
                    final String advertisingId = adInfo.getId();
                    Logger.d(TAG, "updateAdvertisingIdAsync :: advertisingId = " + advertisingId);
                    sGaidFromMemory = advertisingId;
                    sIsLimitedAdTrackingEnabled = adInfo.isLimitAdTrackingEnabled();
                    mainHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            if (callback != null) {
                                callback.onIdRetrieved(advertisingId);
                            }
                        }
                    });
                }
                catch (Exception e) {
                    Logger.d(TAG, "updateAdvertisingIdAsync :: failed");
                    Logger.e(TAG, "updateAdvertisingIdAsync :: failed", e);
                    mainHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            if (callback != null) {
                                callback.onIdUnavailable();
                            }
                        }
                    });
                }
            }
        }).start();
    }

    public static AdInfo getAdvertisingIdInfo(Context context) throws Exception {
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new IllegalStateException("Cannot be called from the main thread");
        }
        try {
            PackageManager pm = context.getPackageManager();
            pm.getPackageInfo("com.android.vending", 0);
        }
        catch (Exception e) {
            Logger.e(TAG, "Failed to get AdvertisingIdInfo", e);
            throw e;
        }
        AdvertisingConnection connection = new AdvertisingConnection();
        Intent intent = new Intent("com.google.android.gms.ads.identifier.service.START");
        intent.setPackage("com.google.android.gms");
        if (context.bindService(intent, (ServiceConnection)connection, 1)) {
            try {
                AdvertisingInterface adInterface = new AdvertisingInterface(connection.getBinder());
                AdInfo adInfo = new AdInfo(adInterface.getId(), adInterface.isLimitAdTrackingEnabled(true));
                return adInfo;
            }
            catch (Exception exception) {
                Logger.e(TAG, "Failed ot get AdvertisingIdInfo", exception);
                throw exception;
            }
            finally {
                context.unbindService((ServiceConnection)connection);
            }
        }
        Logger.e(TAG, "bindService fail");
        throw new IOException("Google Play connection failed");
    }

    private static final class AdvertisingInterface
    implements IInterface {
        private IBinder binder;

        public AdvertisingInterface(IBinder pBinder) {
            this.binder = pBinder;
        }

        public IBinder asBinder() {
            return this.binder;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String getId() throws RemoteException {
            String id;
            Parcel data = Parcel.obtain();
            Parcel reply = Parcel.obtain();
            try {
                data.writeInterfaceToken("com.google.android.gms.ads.identifier.internal.IAdvertisingIdService");
                this.binder.transact(1, data, reply, 0);
                reply.readException();
                id = reply.readString();
            }
            finally {
                reply.recycle();
                data.recycle();
            }
            return id;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isLimitAdTrackingEnabled(boolean paramBoolean) throws RemoteException {
            boolean limitAdTracking;
            Parcel data = Parcel.obtain();
            Parcel reply = Parcel.obtain();
            try {
                data.writeInterfaceToken("com.google.android.gms.ads.identifier.internal.IAdvertisingIdService");
                data.writeInt(paramBoolean ? 1 : 0);
                this.binder.transact(2, data, reply, 0);
                reply.readException();
                limitAdTracking = 0 != reply.readInt();
            }
            finally {
                reply.recycle();
                data.recycle();
            }
            return limitAdTracking;
        }
    }

    private static final class AdvertisingConnection
    implements ServiceConnection {
        boolean retrieved = false;
        private final LinkedBlockingQueue<IBinder> queue = new LinkedBlockingQueue(1);

        private AdvertisingConnection() {
        }

        public void onServiceConnected(ComponentName name, IBinder service) {
            try {
                this.queue.put(service);
            }
            catch (InterruptedException localInterruptedException) {
                Logger.e(TAG, "AdvertisingConnection | OnServiceConnected ", localInterruptedException);
            }
        }

        public void onServiceDisconnected(ComponentName name) {
        }

        public IBinder getBinder() throws InterruptedException {
            if (this.retrieved) {
                throw new IllegalStateException();
            }
            this.retrieved = true;
            return this.queue.take();
        }
    }

    public static final class AdInfo {
        private final String advertisingId;
        private final boolean limitAdTrackingEnabled;

        AdInfo(String advertisingId, boolean limitAdTrackingEnabled) {
            this.advertisingId = advertisingId;
            this.limitAdTrackingEnabled = limitAdTrackingEnabled;
        }

        public String getId() {
            return this.advertisingId;
        }

        public boolean isLimitAdTrackingEnabled() {
            return this.limitAdTrackingEnabled;
        }
    }

    public static interface AdvertisingIdCallback {
        public void onIdRetrieved(String var1);

        public void onIdUnavailable();
    }
}

