/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.integration_verifier.testing.tests;

import android.content.Context;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.taboola.android.integration_verifier.testing.VerificationTest;
import com.taboola.android.integration_verifier.testing.output_connector.VerificationOutputTarget;
import com.taboola.android.integration_verifier.testing.output_connector.VerificationOutputTargets;
import com.taboola.android.integration_verifier.testing.tests.extra_property_values.ExtraPropertyTester;
import com.taboola.android.integration_verifier.utility.IntegrationTypeNameParser;

public class ExtraPropertiesVerificationTest
extends VerificationTest {
    private static final String TEST_NAME = "ExtraPropertiesVerification";
    private static final String EMPTY_KEY_ERROR = "Got an empty or null key, should never happen.";
    private static final String EMPTY_VALUE_ERROR = "The key (%s) has an empty value assigned.";
    private static final String UNKNOWN_KEY_ERROR = "The key (%s) is unknown.";
    private static final String ILLEGAL_VALUE_ERROR = "The key (%s) cannot be assigned with the value (%s).";
    private static final String EXTRA_PROPERTIES_BUNDLE_NULL_ERROR = "ExtraProperties Bundle should never null.";
    private String errorMsg;

    public ExtraPropertiesVerificationTest(int id, boolean isMandatory) {
        super(id, isMandatory);
    }

    @Override
    public void execute(@Nullable Context context, @Nullable Bundle bundle, @NonNull VerificationTest.TestResults testResults) {
        if (this.propertiesVerified(bundle)) {
            testResults.onSuccess();
        } else {
            testResults.onFail(this.isMandatory());
        }
    }

    private boolean propertiesVerified(Bundle bundle) {
        if (bundle == null) {
            this.errorMsg = EXTRA_PROPERTIES_BUNDLE_NULL_ERROR;
            return false;
        }
        ExtraPropertyTester extraPropertyTester = new ExtraPropertyTester();
        for (String bundleKey : bundle.keySet()) {
            if (bundleKey.equals("integration_verifier_key_integrationType")) continue;
            if (TextUtils.isEmpty((CharSequence)bundleKey)) {
                this.errorMsg = EMPTY_KEY_ERROR;
                return false;
            }
            String bundleValue = bundle.getString(bundleKey);
            if (TextUtils.isEmpty((CharSequence)bundleValue)) {
                this.errorMsg = String.format(EMPTY_VALUE_ERROR, bundleKey);
                return false;
            }
            if (!extraPropertyTester.isKeyKnown(bundleKey)) {
                this.errorMsg = String.format(UNKNOWN_KEY_ERROR, bundleKey);
                return false;
            }
            if (extraPropertyTester.isValueInAcceptableRange(bundleKey, bundleValue)) continue;
            this.errorMsg = String.format(ILLEGAL_VALUE_ERROR, bundleKey, bundleValue);
            return false;
        }
        return true;
    }

    @Override
    public VerificationOutputTargets getVerificationOutputTargets(@Nullable Bundle bundle) {
        VerificationOutputTargets verificationOutputTargets = new VerificationOutputTargets(new VerificationOutputTarget[0]);
        Bundle consoleBundle = new Bundle();
        consoleBundle.putString("consoleOutput_key_log_error_string", this.errorMsg);
        verificationOutputTargets.add(new VerificationOutputTarget(2, consoleBundle));
        verificationOutputTargets.add(new VerificationOutputTarget(3, this.getKibanaBundle(IntegrationTypeNameParser.getNameFor(bundle.getInt("integration_verifier_key_integrationType")), TEST_NAME, this.errorMsg)));
        return verificationOutputTargets;
    }
}

