/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.global_components.gueh.impl;

import android.content.Context;
import com.taboola.android.global_components.gueh.GlobalUncaughtExceptionHandler;
import com.taboola.android.global_components.gueh.TaboolaExceptionHandler;
import com.taboola.android.global_components.network.NetworkManager;
import com.taboola.android.utils.Logger;

public abstract class BaseGuehImpl
extends GlobalUncaughtExceptionHandler {
    public BaseGuehImpl(NetworkManager networkManager, Context context) {
        super(networkManager, context);
    }

    @Override
    protected Thread.UncaughtExceptionHandler getGUEHBehaviour() {
        return new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread thread, Throwable throwable) {
                if (throwable == null) {
                    BaseGuehImpl.this.mAndroidDefaultHandler.uncaughtException(thread, throwable);
                    return;
                }
                if (BaseGuehImpl.this.checkSameException(throwable, BaseGuehImpl.this.mLastThrownException)) {
                    Logger.d(TAG, "taboolaExceptionHandler | GUEH.start() found current handler to be GUEH, avoiding looping error.");
                    System.exit(0);
                }
                BaseGuehImpl.this.mLastThrownException = throwable;
                for (TaboolaExceptionHandler taboolaExceptionHandler : BaseGuehImpl.this.mTaboolaExceptionHandlerList) {
                    if (!taboolaExceptionHandler.isHandling(throwable)) continue;
                    taboolaExceptionHandler.handle(throwable);
                }
                if (BaseGuehImpl.this.shouldReturnEventToSystem()) {
                    Logger.d(TAG, "Returning the following exception to prior exception handler: " + throwable.getLocalizedMessage());
                    BaseGuehImpl.this.mAndroidDefaultHandler.uncaughtException(thread, throwable);
                } else {
                    System.exit(0);
                }
            }
        };
    }

    protected abstract boolean shouldReturnEventToSystem();

    public BaseGuehImpl(Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
        super(uncaughtExceptionHandler);
    }
}

