/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.global_components.eventsmanager.events;

import android.content.Context;
import android.os.Build;
import android.support.annotation.Keep;
import android.text.TextUtils;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.taboola.android.global_components.TaboolaContextManager;
import com.taboola.android.global_components.eventsmanager.EventType;
import com.taboola.android.global_components.eventsmanager.events.TaboolaEvent;
import com.taboola.android.global_components.network.NetworkManager;
import com.taboola.android.utils.AdvertisingIdClient;
import com.taboola.android.utils.Logger;
import com.taboola.android.utils.SdkDetailsHelper;
import com.taboola.lightnetwork.protocols.http.HttpError;
import com.taboola.lightnetwork.protocols.http.HttpManager;
import com.taboola.lightnetwork.protocols.http.HttpResponse;
import java.lang.reflect.Type;
import java.sql.Timestamp;
import java.util.Locale;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

@Keep
public class TaboolaMobileEvent
extends TaboolaEvent {
    private static final String TAG = TaboolaMobileEvent.class.getSimpleName();
    private static final String DEFAULT_APP_TYPE = "mobile";
    private static final int EVENT_STR_MAX_LEN = 20;
    private static final String JSON_KEY_SESSION_ID = "sessionId";
    private static final String JSON_KEY_RESPONSE_ID = "responseId";
    private static final String JSON_KEY_API_KEY = "apiKey";
    private static final String JSON_KEY_APP_TYPE_KEY = "appType";
    private static final String JSON_KEY_DATA = "data";
    private static final String CONFIG_VARIANT = "configVariant";
    private static final String CONFIG_DEF_VALUE = "general_msdk";
    private static final String EVENT_TYPE = "eventType";
    private static final String TIME = "time";
    private String mSessionId;
    private String mResponseId;
    private String mPublisherId;
    private String mApiKey;
    private String mAppType = "mobile";
    private Map<String, String> mData;
    private Gson mGson = new Gson();

    public TaboolaMobileEvent(Map<String, String> data) {
        this(DEFAULT_APP_TYPE, data);
    }

    public TaboolaMobileEvent(@EventType String eventType, Map<String, String> data) {
        super(eventType);
        this.setData(data);
    }

    @Override
    public boolean isValid() {
        String eventType = this.mData.get(EVENT_TYPE);
        String configVariant = this.mData.get(CONFIG_VARIANT);
        return !TextUtils.isEmpty((CharSequence)this.mPublisherId) && !TextUtils.isEmpty((CharSequence)eventType) && eventType.length() < 20 && !TextUtils.isEmpty((CharSequence)configVariant) && configVariant.length() < 20;
    }

    @Override
    public void extendedSendEvent(NetworkManager networkManager, final TaboolaEvent.SendEventCallback sendEventCallback) {
        networkManager.getEventsManagerHandler().reportMobileEvent(new HttpManager.NetworkResponse(){

            @Override
            public void onResponse(HttpResponse response) {
                sendEventCallback.onSuccess();
            }

            @Override
            public void onError(HttpError error) {
                Logger.d("eventsmanager", "TaboolaMobileEvent | extendedSend()| error: " + error.toString());
                sendEventCallback.onFailure();
            }
        }, this);
    }

    public void setSessionId(String sessionId) {
        this.mSessionId = sessionId;
    }

    public String getSessionId() {
        return this.mSessionId;
    }

    public void setResponseId(String responseId) {
        this.mResponseId = responseId;
    }

    public String getResponseId() {
        return this.mResponseId;
    }

    public void setPublisherId(String publisherId) {
        this.mPublisherId = publisherId;
        this.mData.put("publisher", this.mPublisherId);
    }

    public String getPublisherId() {
        return this.mPublisherId;
    }

    public void setApiKey(String apiKey) {
        this.mApiKey = apiKey;
    }

    public String getApiKey() {
        return this.mApiKey;
    }

    public String getAppType() {
        return this.mAppType;
    }

    public void setAppType(String appType) {
        this.mAppType = appType;
    }

    public Map<String, String> getData() {
        return this.mData;
    }

    public void setData(Map<String, String> data) {
        this.mData = data;
        if (TextUtils.equals((CharSequence)"Generic", (CharSequence)this.getType()) && data.containsKey("extraParam")) {
            this.setType(data.remove("extraParam"));
        }
        data.put(EVENT_TYPE, this.getType());
        this.validateConfigVariant(data);
        this.validateTime(data);
        this.addExtraData();
    }

    private void addExtraData() {
        Context context = TaboolaContextManager.getInstance().getApplicationContext();
        this.mData.put("device_id", AdvertisingIdClient.getAdvertisingIdFromMemory());
        this.mData.put("os_version", Build.VERSION.RELEASE);
        this.mData.put("os_name", "Android");
        this.mData.put("device_manufacturer", Build.MANUFACTURER);
        this.mData.put("language", Locale.getDefault().getDisplayLanguage(Locale.US));
        this.mData.put("device_model", SdkDetailsHelper.getDeviceName());
        if (context != null) {
            this.mData.put("app_version", SdkDetailsHelper.getAppVersion(context));
            this.mData.put("carrier", SdkDetailsHelper.getCarrier(context));
        }
        this.mData.put("sdk_version", "2.3.5-50243-5");
    }

    private void validateTime(Map<String, String> data) {
        long timeStamp = 0L;
        String time = data.get(TIME);
        if (!TextUtils.isEmpty((CharSequence)time)) {
            try {
                timeStamp = Timestamp.valueOf(time).getTime();
            }
            catch (Exception e) {
                Logger.e("time is not valid", e.getMessage());
            }
        }
        if (timeStamp == 0L) {
            data.put(TIME, new Timestamp(System.currentTimeMillis()).toString());
        }
    }

    private void validateConfigVariant(Map<String, String> data) {
        if (data.containsKey(CONFIG_VARIANT)) {
            String configVariant = data.get(CONFIG_VARIANT);
            if (TextUtils.isEmpty((CharSequence)configVariant) || configVariant.length() >= 20) {
                Logger.e(TAG, "configVariant is not valid");
            }
        } else {
            data.put(CONFIG_VARIANT, CONFIG_DEF_VALUE);
        }
    }

    public String getDataAsString() {
        return this.mGson.toJson(this.mData);
    }

    @Override
    public JSONObject extendedToJson(JSONObject jsonObject) throws JSONException {
        jsonObject.put(JSON_KEY_SESSION_ID, (Object)this.mSessionId);
        jsonObject.put(JSON_KEY_RESPONSE_ID, (Object)this.mResponseId);
        jsonObject.put(JSON_KEY_API_KEY, (Object)this.mApiKey);
        jsonObject.put(JSON_KEY_APP_TYPE_KEY, (Object)this.mAppType);
        jsonObject.put(JSON_KEY_DATA, (Object)this.mGson.toJson(this.mData));
        return jsonObject;
    }

    @Override
    public TaboolaEvent extendedFromJson(JSONObject jsonObject) {
        this.mSessionId = jsonObject.optString(JSON_KEY_SESSION_ID);
        this.mResponseId = jsonObject.optString(JSON_KEY_RESPONSE_ID);
        this.mApiKey = jsonObject.optString(JSON_KEY_API_KEY);
        this.mAppType = jsonObject.optString(JSON_KEY_APP_TYPE_KEY);
        String dataString = jsonObject.optString(JSON_KEY_DATA);
        Type dataMapType = new TypeToken<Map<String, String>>(){}.getType();
        this.mData = (Map)this.mGson.fromJson(dataString, dataMapType);
        return this;
    }
}

