/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android;

import android.content.Context;
import android.support.annotation.NonNull;
import com.taboola.android.INTEGRATION_TYPE;
import com.taboola.android.ITaboolaImpl;
import com.taboola.android.PublisherInfo;
import com.taboola.android.TaboolaInterfaceComponent;
import com.taboola.android.TaboolaWidget;
import com.taboola.android.api.TaboolaApi;
import com.taboola.android.global_components.configuration.ConfigManager;
import com.taboola.android.global_components.eventsmanager.EventsManager;
import com.taboola.android.global_components.eventsmanager.SessionInfo;
import com.taboola.android.global_components.eventsmanager.events.TaboolaEvent;
import com.taboola.android.global_components.eventsmanager.events.TaboolaMobileEvent;
import com.taboola.android.global_components.gueh.GlobalUncaughtExceptionHandler;
import com.taboola.android.global_components.gueh.TaboolaExceptionHandler;
import com.taboola.android.global_components.network.NetworkManager;
import com.taboola.android.integration_verifier.IntegrationVerifier;
import com.taboola.android.js.TaboolaJs;
import com.taboola.android.utils.ExtraProperty;
import com.taboola.android.utils.IntegrationVerifierUtils;
import com.taboola.android.utils.Logger;
import java.util.ArrayList;
import java.util.Map;

class TaboolaImpl
implements ITaboolaImpl {
    private static final String TAG = TaboolaImpl.class.getSimpleName();
    private NetworkManager mNetworkManager;
    private GlobalUncaughtExceptionHandler mGlobalExceptionHandler;
    private IntegrationVerifier mIntegrationVerifier;
    private EventsManager mEventsManager;
    private PublisherInfo mPublisherInfo;
    private Context mContext;
    private ConfigManager mConfigManager;

    TaboolaImpl() {
        Logger.d(TAG, "TaboolaImpl constructed.");
    }

    @Override
    public void internalGlobalInit(Context context) {
        Logger.d(TAG, "TaboolaImpl | init called..");
        this.mContext = context;
        this.mNetworkManager = new NetworkManager(context);
        this.mEventsManager = new EventsManager(context, this.mNetworkManager);
        this.mIntegrationVerifier = new IntegrationVerifier(this.mNetworkManager);
        this.mGlobalExceptionHandler = new GlobalUncaughtExceptionHandler(this.mNetworkManager, this.mContext).start();
        this.mConfigManager = new ConfigManager(this.mNetworkManager, this.mGlobalExceptionHandler, this.mEventsManager);
    }

    @Override
    public int getImplementationId() {
        return 0;
    }

    @Override
    public void init(PublisherInfo publisherInfo) {
        this.mPublisherInfo = publisherInfo;
    }

    @Override
    public TaboolaInterfaceComponent getComponent(@INTEGRATION_TYPE int integrationType) {
        switch (integrationType) {
            case 1: {
                return new TaboolaWidget(this.mContext);
            }
            case 2: {
                return TaboolaJs.getInstance();
            }
            case 3: {
                return TaboolaApi.getInstance();
            }
        }
        throw new RuntimeException("Must be of type extending TaboolaInterfaceComponent.");
    }

    @Override
    public EventsManager getEventsManager() {
        return this.mEventsManager;
    }

    @Override
    public void reportTaboolaEvent(SessionInfo sessionInfo, TaboolaEvent ... events) {
        if (events != null) {
            ArrayList<TaboolaMobileEvent> taboolaMobileEvents = new ArrayList<TaboolaMobileEvent>();
            for (int i = 0; i < events.length; ++i) {
                if (events[i] instanceof TaboolaMobileEvent) {
                    taboolaMobileEvents.add((TaboolaMobileEvent)events[i]);
                    continue;
                }
                Logger.e(TAG, "Taboola event type is unrecognizable.");
            }
            if (!taboolaMobileEvents.isEmpty()) {
                this.mEventsManager.reportTaboolaMobileEvent(this.mPublisherInfo, sessionInfo, taboolaMobileEvents.toArray(new TaboolaMobileEvent[0]));
            }
        }
    }

    @Override
    public void registerTaboolaExceptionHandler(TaboolaExceptionHandler taboolaExceptionHandler) {
        if (this.mGlobalExceptionHandler != null) {
            this.mGlobalExceptionHandler.registerExceptionHandler(taboolaExceptionHandler);
        } else {
            Logger.d(TAG, "registerTaboolaExceptionHandler | not registering handler, mGlobalExceptionHandler is null.");
        }
    }

    @Override
    public void setExtraProperties(@NonNull Map<String, String> extraProperties) {
        IntegrationVerifierUtils.verifyExtraProperties(this.mIntegrationVerifier, 0, extraProperties);
        for (String key : extraProperties.keySet()) {
            String value = extraProperties.get(key);
            ExtraProperty extraProperty = ExtraProperty.getExtraProperty(key);
            switch (extraProperty) {
                case SET_GUEH: {
                    if (this.mGlobalExceptionHandler != null) {
                        this.mGlobalExceptionHandler.toggle(Boolean.parseBoolean(value));
                        break;
                    }
                    Logger.e(TAG, "Trying to enable/disable GUEH before initialization. mGlobalExceptionHandler = null.");
                    break;
                }
                case EVENTS_MANAGER_ENABLE: {
                    if (this.mEventsManager == null) break;
                    this.mEventsManager.toggleEventsManager(Boolean.parseBoolean(value));
                    break;
                }
                case EVENTS_MANAGER_MAX_QUEUE_SIZE: {
                    if (this.mEventsManager == null) break;
                    this.mEventsManager.setsQueueMaxSize(Integer.valueOf(value));
                }
            }
        }
    }

    @Override
    public void verifyIntegration(boolean stopOnMandatoryFail) {
        this.mIntegrationVerifier.verifyIntegration(this.mContext, stopOnMandatoryFail);
    }

    @Override
    public NetworkManager getNetworkManager() {
        return this.mNetworkManager;
    }

    @Override
    public IntegrationVerifier getIntegrationVerifier() {
        return this.mIntegrationVerifier;
    }

    @Override
    public ConfigManager loadAndGetConfigManager() {
        this.mConfigManager.loadConfig();
        return this.mConfigManager;
    }

    @Override
    public boolean isKillSwitchEnabled(String placement) {
        if (this.mConfigManager != null) {
            return this.mConfigManager.getConfigValue(placement, "killSwitch", false);
        }
        return false;
    }
}

