/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.lightnetwork.protocols.http;

import com.taboola.lightnetwork.protocols.http.CookiesTracker;
import com.taboola.lightnetwork.protocols.http.HeadersManager;
import com.taboola.lightnetwork.protocols.http.HttpManager;
import com.taboola.lightnetwork.protocols.http.HttpRequest;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.util.Map;
import org.json.JSONObject;

class HttpPost
extends HttpRequest {
    private JSONObject mJsonBody;

    public HttpPost(HeadersManager headersManager, CookiesTracker cookiesTracker, int configuredTimeout) {
        super(configuredTimeout, headersManager, cookiesTracker);
    }

    void post(String url, JSONObject jsonBody, Map<String, String> requestHeaders, String trackHeadersKey, String trackHeadersByGroup, HttpManager.NetworkResponse networkResponse) {
        this.mUrl = url;
        this.mJsonBody = jsonBody;
        this.mRequestHeaders = requestHeaders;
        this.mTrackHeadersByGroup = trackHeadersByGroup;
        this.mTrackHeadersKey = trackHeadersKey;
        this.performRequsetOnBackgroundThread(networkResponse);
    }

    @Override
    void protocolSpecificConnectionSetup(HttpURLConnection httpUrlConnection) throws IOException {
        httpUrlConnection.setRequestMethod("POST");
        httpUrlConnection.setDoInput(true);
        httpUrlConnection.setDoOutput(true);
        this.addJsonBody(httpUrlConnection);
    }

    private void addJsonBody(HttpURLConnection httpUrlConnection) throws IOException {
        if (this.mJsonBody != null && this.mJsonBody.length() > 0) {
            DataOutputStream writer = new DataOutputStream(httpUrlConnection.getOutputStream());
            writer.writeBytes(this.mJsonBody.toString());
            writer.flush();
            writer.close();
        }
    }
}

