/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.lightnetwork.dynamic_url;

import com.taboola.lightnetwork.dynamic_url.DynamicRequest;
import com.taboola.lightnetwork.protocols.http.HttpManager;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

public class NetworkExecutable {
    private static final String TAG = NetworkExecutable.class.getSimpleName();
    private HttpManager mHttpManager;
    private String mBaseUrl;

    public NetworkExecutable(HttpManager httpManager) {
        this(httpManager, null);
    }

    public NetworkExecutable(HttpManager httpManager, String baseUrl) {
        this.mHttpManager = httpManager;
        this.mBaseUrl = baseUrl;
    }

    public <T> T create(Class<T> interfaceClass) {
        return (T)Proxy.newProxyInstance(interfaceClass.getClassLoader(), new Class[]{interfaceClass}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (method.getDeclaringClass() == Object.class) {
                    return method.invoke((Object)this, args);
                }
                return new DynamicRequest(NetworkExecutable.this.mHttpManager, method, NetworkExecutable.this.mBaseUrl, args);
            }
        });
    }
}

