/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.integration_verifier.testing.tests;

import android.content.Context;
import android.os.Bundle;
import android.os.Process;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.taboola.android.global_components.network.NetworkManager;
import com.taboola.android.integration_verifier.testing.VerificationTest;
import com.taboola.android.integration_verifier.testing.output_connector.VerificationOutputTarget;
import com.taboola.android.integration_verifier.testing.output_connector.VerificationOutputTargets;
import com.taboola.android.integration_verifier.utility.IVLogger;
import com.taboola.android.integration_verifier.utility.IntegrationTypeNameParser;
import com.taboola.lightnetwork.protocols.http.HttpError;
import com.taboola.lightnetwork.protocols.http.HttpManager;
import com.taboola.lightnetwork.protocols.http.HttpResponse;
import org.json.JSONException;
import org.json.JSONObject;

public class SdkVersionVerificationTest
extends VerificationTest {
    private static final String TEST_NAME = "SdkVersionVerification";
    private static final String ON_FAIL_ERROR_MESSAGE = "SdkVersionVerificationTest | Local SDK Version (%s) is different from online SDK version (%s). Are you using the latest SDK Version?";
    private static final String INTERNET_PERMISSION = "android.permission.INTERNET";
    public static final String VERSION_VERIFICATION_KEY = "Sdk_version_verification_key";
    private NetworkManager networkManager;
    private String localVersion;
    private String onlineVersion;

    public SdkVersionVerificationTest(int id, boolean isMandatory, NetworkManager networkManager) {
        super(id, isMandatory);
        this.networkManager = networkManager;
    }

    @Override
    public void execute(@Nullable Context context, @Nullable Bundle bundle, @NonNull VerificationTest.TestResults testResults) {
        if (context == null || context.checkPermission(INTERNET_PERMISSION, Process.myPid(), Process.myUid()) != 0) {
            IVLogger.log("SdkVersionVerificationTest | execute | context is null");
            testResults.onUnavailable();
            return;
        }
        this.localVersion = bundle.getString(VERSION_VERIFICATION_KEY);
        this.isSdkVersionTheLatestPublished(this.localVersion, testResults);
    }

    private void isSdkVersionTheLatestPublished(final String localVersion, final VerificationTest.TestResults testResults) {
        IVLogger.log("SdkVersionVerificationTest | isSdkVersionTheLatestPublished | Starting network call..");
        this.networkManager.getBintrayHandler().getLatestSdkVersion(new HttpManager.NetworkResponse(){

            @Override
            public void onResponse(HttpResponse response) {
                IVLogger.log("SdkVersionVerificationTest | isSdkVersionTheLatestPublished | Network response = " + response);
                if (!TextUtils.isEmpty((CharSequence)response.mMessage)) {
                    try {
                        SdkVersionVerificationTest.this.compareLocalAndOnlineVersions(localVersion, response.mMessage, testResults);
                    }
                    catch (JSONException e) {
                        IVLogger.log("SdkVersionVerificationTest | isSdkVersionTheLatestPublished | Exception: " + e.getLocalizedMessage());
                        testResults.onUnavailable();
                    }
                } else {
                    testResults.onUnavailable();
                }
            }

            @Override
            public void onError(HttpError onError) {
                IVLogger.log("SdkVersionVerificationTest | isSdkVersionTheLatestPublished | onError = " + onError);
                testResults.onUnavailable();
            }
        });
    }

    private void compareLocalAndOnlineVersions(String localVersion, String response, VerificationTest.TestResults testResults) throws JSONException {
        if (localVersion == null) {
            localVersion = "";
        }
        this.onlineVersion = new JSONObject(response).getString("name");
        IVLogger.log("SdkVersionVerificationTest | isSdkVersionTheLatestPublished | compareLocalAndOnlineVersions | Online version = " + this.onlineVersion + ", Local version = " + localVersion);
        if (localVersion.equals(this.onlineVersion)) {
            testResults.onSuccess();
        } else {
            testResults.onFail(this.isMandatory());
        }
    }

    @Override
    public VerificationOutputTargets getVerificationOutputTargets(@Nullable Bundle bundle) {
        VerificationOutputTargets verificationOutputTargets = new VerificationOutputTargets(new VerificationOutputTarget[0]);
        Bundle consoleBundle = new Bundle();
        String failMessage = String.format(ON_FAIL_ERROR_MESSAGE, this.localVersion, this.onlineVersion);
        consoleBundle.putString("consoleOutput_key_log_error_string", failMessage);
        verificationOutputTargets.add(new VerificationOutputTarget(2, consoleBundle));
        verificationOutputTargets.add(new VerificationOutputTarget(3, this.getKibanaBundle(IntegrationTypeNameParser.getNameFor(bundle.getInt("integration_verifier_key_integrationType")), TEST_NAME, failMessage)));
        return verificationOutputTargets;
    }
}

