/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.global_components.eventsmanager.events;

import android.support.annotation.Keep;
import android.text.TextUtils;
import com.taboola.android.global_components.eventsmanager.EventType;
import com.taboola.android.global_components.eventsmanager.events.TaboolaEvent;
import com.taboola.android.global_components.network.NetworkManager;
import com.taboola.android.utils.Logger;
import com.taboola.lightnetwork.protocols.http.HttpError;
import com.taboola.lightnetwork.protocols.http.HttpManager;
import com.taboola.lightnetwork.protocols.http.HttpResponse;
import org.json.JSONException;
import org.json.JSONObject;

@Keep
public class TaboolaMobileEvent
extends TaboolaEvent {
    private static final String TAG = TaboolaMobileEvent.class.getSimpleName();
    private static final String DEFAULT_APP_TYPE = "mobile";
    private static final String JSON_KEY_SESSION_ID = "sessionId";
    private static final String JSON_KEY_RESPONSE_ID = "responseId";
    private static final String JSON_KEY_API_KEY = "apiKey";
    private static final String JSON_KEY_APP_TYPE_KEY = "appType";
    private static final String JSON_KEY_DATA = "data";
    private String mSessionId;
    private String mResponseId;
    private String mPublisherId;
    private String mApiKey;
    private String mAppType = "mobile";
    private String mData;

    public TaboolaMobileEvent(String data) {
        this(DEFAULT_APP_TYPE, data);
    }

    public TaboolaMobileEvent(@EventType String eventType, String data) {
        super(eventType);
        this.setData(data);
    }

    @Override
    public boolean isValid() {
        return !TextUtils.isEmpty((CharSequence)this.mPublisherId);
    }

    @Override
    public void extendedSendEvent(NetworkManager networkManager, final TaboolaEvent.SendEventCallback sendEventCallback) {
        networkManager.getEventsManagerHandler().reportMobileEvent(new HttpManager.NetworkResponse(){

            @Override
            public void onResponse(HttpResponse response) {
                sendEventCallback.onSuccess();
            }

            @Override
            public void onError(HttpError error) {
                Logger.d("eventsmanager", "TaboolaMobileEvent | extendedSend()| error: " + error.toString());
                sendEventCallback.onFailure();
            }
        }, this);
    }

    public void setSessionId(String sessionId) {
        this.mSessionId = sessionId;
    }

    public String getSessionId() {
        return this.mSessionId;
    }

    public void setResponseId(String responseId) {
        this.mResponseId = responseId;
    }

    public String getResponseId() {
        return this.mResponseId;
    }

    public void setPublisherId(String publisherId) {
        this.mPublisherId = publisherId;
    }

    public String getPublisherId() {
        return this.mPublisherId;
    }

    public void setApiKey(String apiKey) {
        this.mApiKey = apiKey;
    }

    public String getApiKey() {
        return this.mApiKey;
    }

    public String getAppType() {
        return this.mAppType;
    }

    public void setAppType(String appType) {
        this.mAppType = appType;
    }

    public String getData() {
        return this.mData;
    }

    public void setData(String data) {
        this.mData = data;
    }

    @Override
    public JSONObject extendedToJson(JSONObject jsonObject) throws JSONException {
        jsonObject.put(JSON_KEY_SESSION_ID, (Object)this.mSessionId);
        jsonObject.put(JSON_KEY_RESPONSE_ID, (Object)this.mResponseId);
        jsonObject.put(JSON_KEY_API_KEY, (Object)this.mApiKey);
        jsonObject.put(JSON_KEY_APP_TYPE_KEY, (Object)this.mAppType);
        jsonObject.put(JSON_KEY_DATA, (Object)this.mData);
        return jsonObject;
    }

    @Override
    public TaboolaEvent extendedFromJson(JSONObject jsonObject) {
        this.mSessionId = jsonObject.optString(JSON_KEY_SESSION_ID);
        this.mResponseId = jsonObject.optString(JSON_KEY_RESPONSE_ID);
        this.mApiKey = jsonObject.optString(JSON_KEY_API_KEY);
        this.mAppType = jsonObject.optString(JSON_KEY_APP_TYPE_KEY);
        this.mData = jsonObject.optString(JSON_KEY_DATA);
        return this;
    }
}

