/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.js;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.webkit.JavascriptInterface;
import android.webkit.WebView;
import com.taboola.android.TaboolaWebView;
import com.taboola.android.api.TaboolaOnClickListener;
import com.taboola.android.global_components.network.NetworkManager;
import com.taboola.android.integration_verifier.utility.IVLogger;
import com.taboola.android.js.JsInitDataObserver;
import com.taboola.android.js.OnRenderListener;
import com.taboola.android.js.OnResizeListener;
import com.taboola.android.js.TaboolaJs;
import com.taboola.android.js.WebViewManager;
import com.taboola.android.utils.Logger;
import com.taboola.android.utils.PopupHelper;
import java.util.ArrayList;

class InjectedObject {
    private static final String TAG = InjectedObject.class.getSimpleName();
    private static final String DATA_KEY_PUBLISHER_ID = "DATA_KEY_PUBLISHER_ID";
    private static final String CAROUSEL_TOUCH_EVENT = "carouselTouchStart";
    private static final String UPDATE_CONTENT_COMPLETED_EVENT = "updateContentComplete";
    private Context mActivityContext;
    private WebViewManager mWebViewManager;
    private Handler mMainHandler;
    private String mPublisherId;
    private ArrayList<JsInitDataObserver> jsInitDataObservers;
    private boolean onJsInitDataAvailableCalled;
    private NetworkManager mNetworkManager;

    InjectedObject(Context activityContext, WebViewManager webViewManager, NetworkManager NetworkManager2) {
        this.mActivityContext = activityContext;
        this.mWebViewManager = webViewManager;
        this.mNetworkManager = NetworkManager2;
        this.mMainHandler = new Handler(Looper.getMainLooper());
        this.jsInitDataObservers = new ArrayList();
        this.onJsInitDataAvailableCalled = false;
        this.addJsInitDataObserver(new JsInitDataObserver(){

            @Override
            public void onData(String dataJsonString) {
                InjectedObject.this.addJsCallbacks(new String[]{InjectedObject.CAROUSEL_TOUCH_EVENT, InjectedObject.UPDATE_CONTENT_COMPLETED_EVENT});
            }
        });
    }

    void clearDependencies() {
        this.mMainHandler.removeCallbacksAndMessages(null);
        this.mWebViewManager = null;
        this.jsInitDataObservers.clear();
        this.mActivityContext = null;
    }

    @JavascriptInterface
    public boolean isAlive() {
        if (this.mWebViewManager != null) {
            Logger.d(TAG, "isAlive: " + this.mWebViewManager.isAlive());
            return this.mWebViewManager.isAlive();
        }
        Logger.d(TAG, "isAlive called but mWebViewManager is null, return isAlive = false ");
        return false;
    }

    @JavascriptInterface
    public boolean isMonitoringEnabled() {
        return this.mWebViewManager != null && this.mWebViewManager.isSdkMonitorEnabled();
    }

    @JavascriptInterface
    public int getLogLevel() {
        int nativeLogLevel = Logger.getLogLevel();
        int JS_ERROR = 3;
        int JS_WARN = 2;
        boolean JS_INFO = true;
        boolean JS_DEBUG = false;
        switch (nativeLogLevel) {
            case 6: {
                return 3;
            }
            case 5: {
                return 2;
            }
            case 4: {
                return 1;
            }
            case 3: {
                return 0;
            }
            case 2: {
                return 0;
            }
        }
        return 3;
    }

    @JavascriptInterface
    public String getExternalRects() {
        return this.mWebViewManager == null ? "" : this.mWebViewManager.getVisibleBounds();
    }

    @JavascriptInterface
    public String getDeviceData() {
        String deviceData = this.mWebViewManager == null ? "" : this.mWebViewManager.getDeviceData();
        Logger.d(TAG, "getDeviceData() called with [ " + deviceData + " ]");
        return deviceData;
    }

    @JavascriptInterface
    public void collectPendingEvents() {
        this.mMainHandler.post(new Runnable(){

            @Override
            public void run() {
                if (InjectedObject.this.mWebViewManager == null) {
                    return;
                }
                InjectedObject.this.mWebViewManager.collectPendingEvents();
            }
        });
    }

    @JavascriptInterface
    public void onPlacementResize(final String placementName, final int height) {
        this.mMainHandler.post(new Runnable(){

            @Override
            public void run() {
                if (InjectedObject.this.mWebViewManager == null) {
                    return;
                }
                OnResizeListener listener = InjectedObject.this.mWebViewManager.getOnResizeListener();
                if (listener != null) {
                    listener.onResize(InjectedObject.this.mWebViewManager.getWebView(), placementName, height);
                }
            }
        });
    }

    @JavascriptInterface
    public void onRenderSuccess(final String placementName, final int height) {
        this.mMainHandler.post(new Runnable(){

            @Override
            public void run() {
                OnRenderListener onRenderListener;
                if (InjectedObject.this.mWebViewManager == null) {
                    return;
                }
                String func = String.format("%1$s.onDataRetrieved(\"%2$s\", taboolaMobile.getPublisherId())", "taboolaNative", InjectedObject.DATA_KEY_PUBLISHER_ID);
                InjectedObject.this.mWebViewManager.callJsFunction(func);
                InjectedObject.this.mWebViewManager.setDidRender(true);
                OnResizeListener listener = InjectedObject.this.mWebViewManager.getOnResizeListener();
                if (listener != null) {
                    listener.onResize(InjectedObject.this.mWebViewManager.getWebView(), placementName, height);
                }
                if ((onRenderListener = InjectedObject.this.mWebViewManager.getOnRenderListener()) != null) {
                    onRenderListener.onRenderSuccessful(InjectedObject.this.mWebViewManager.getWebView(), placementName, height);
                }
                if (InjectedObject.this.mWebViewManager.isSdkMonitorEnabled()) {
                    InjectedObject.this.mWebViewManager.sendRenderSuccessful(placementName);
                }
            }
        });
    }

    @JavascriptInterface
    public void onOrientationChange(final int height) {
        this.mMainHandler.post(new Runnable(){

            @Override
            public void run() {
                if (InjectedObject.this.mWebViewManager == null) {
                    return;
                }
                OnResizeListener listener = InjectedObject.this.mWebViewManager.getOnResizeListener();
                if (listener != null) {
                    listener.onOrientationChange(InjectedObject.this.mWebViewManager.getWebView(), height);
                }
            }
        });
    }

    @JavascriptInterface
    public void onRenderFailure(final String placementName, final String errorMessage) {
        this.mMainHandler.post(new Runnable(){

            @Override
            public void run() {
                if (InjectedObject.this.mWebViewManager == null) {
                    return;
                }
                OnRenderListener listener = InjectedObject.this.mWebViewManager.getOnRenderListener();
                if (listener != null) {
                    listener.onRenderFailed(InjectedObject.this.mWebViewManager.getWebView(), placementName, errorMessage);
                }
                if (InjectedObject.this.mWebViewManager.isSdkMonitorEnabled()) {
                    InjectedObject.this.mWebViewManager.sendRenderFailed(placementName);
                }
            }
        });
    }

    @JavascriptInterface
    public void onMonitorDataRetrieved(String placementName, String data, String html) {
        if (this.mWebViewManager == null) {
            return;
        }
        if (this.mWebViewManager.isSdkMonitorEnabled()) {
            this.mWebViewManager.sendMonitorData(placementName, data, html);
        }
    }

    @JavascriptInterface
    public void handleAttributionClick(final String url) {
        this.mMainHandler.post(new Runnable(){

            @Override
            public void run() {
                if (InjectedObject.this.mWebViewManager == null) {
                    return;
                }
                Context context = InjectedObject.this.mWebViewManager.getWebView().getContext();
                if (!PopupHelper.openPopup(context, url)) {
                    Logger.d(TAG, "failed to open popup, so opening browser");
                    TaboolaJs.getInstance().openUrlInTabsOrBrowser(context, url);
                }
            }
        });
    }

    @JavascriptInterface
    public void onClick(String title, final String pageUrl, final String loggerUrl, final boolean isOrganic, final String itemId, final String placementName) {
        Logger.d(TAG, "onClick() called with: title = [" + title + "], pageUrl = [" + pageUrl + "], loggerUrl = [" + loggerUrl + "], isOrganic = [" + isOrganic + "], itemId = [" + itemId + "], placementName = [" + placementName + "]");
        this.mMainHandler.post(new Runnable(){

            @Override
            public void run() {
                if (InjectedObject.this.mWebViewManager == null) {
                    return;
                }
                InjectedObject.this.mNetworkManager.getTrackingHandler().reportPreClick(InjectedObject.this.mActivityContext.getApplicationContext(), InjectedObject.this.mPublisherId, pageUrl, InjectedObject.this.mWebViewManager.getSdkType());
                Boolean shouldAllowNonOrganicClickOverride = InjectedObject.this.mWebViewManager.shouldAllowNonOrganicClickOverride();
                if (shouldAllowNonOrganicClickOverride == null) {
                    shouldAllowNonOrganicClickOverride = TaboolaJs.getInstance().shouldAllowNonOrganicClickOverride();
                }
                boolean shouldSdkHandleClick = true;
                TaboolaOnClickListener onClickListener = InjectedObject.this.mWebViewManager.getOnClickListener();
                if (onClickListener == null) {
                    onClickListener = TaboolaJs.getInstance().getOnClickListener();
                }
                if (InjectedObject.this.mWebViewManager.isSdkMonitorEnabled()) {
                    InjectedObject.this.mWebViewManager.sendPlacementClicked(placementName);
                }
                if (onClickListener != null) {
                    Logger.d(TAG, " onClickListener.onItemClick() called from main lopper from " + TAG);
                    String tag = InjectedObject.this.mWebViewManager.getTag();
                    String placement = TextUtils.isEmpty((CharSequence)tag) ? placementName : placementName + "##" + tag;
                    shouldSdkHandleClick = onClickListener.onItemClick(placement, itemId, pageUrl, isOrganic);
                } else {
                    Logger.d(TAG, "onClickListener == null");
                }
                if (shouldSdkHandleClick) {
                    TaboolaJs.getInstance().openUrlInTabsOrBrowser(InjectedObject.this.mActivityContext, loggerUrl);
                } else if (isOrganic || shouldAllowNonOrganicClickOverride.booleanValue()) {
                    InjectedObject.this.notifyClick(loggerUrl);
                } else {
                    Logger.d(TAG, "onItemClick: Performing default click action even though click handler returned \u201cfalse\u201d.Can only override default click action for organic items");
                    TaboolaJs.getInstance().openUrlInTabsOrBrowser(InjectedObject.this.mActivityContext, loggerUrl);
                }
            }
        });
    }

    @JavascriptInterface
    public void onDataRetrieved(String key, String data) {
        switch (key) {
            case "DATA_KEY_PUBLISHER_ID": {
                this.mPublisherId = data;
                break;
            }
            default: {
                Logger.e(TAG, "Unknown data key: " + key);
            }
        }
    }

    private void notifyClick(String loggerUrl) {
        if (this.mWebViewManager == null) {
            return;
        }
        this.mWebViewManager.callJsFunction("taboolaMobile.fireClickEvent(\"" + loggerUrl + "\")");
    }

    private String removeQueryParameter(String url, String paramToRemove) {
        int queryStartIndex;
        String newUrl = url;
        String paramStartString = "?" + paramToRemove + "=";
        int paramStartIndex = url.indexOf(paramStartString, queryStartIndex = url.indexOf(63));
        if (paramStartIndex == -1) {
            paramStartString = "&" + paramToRemove + "=";
            paramStartIndex = url.indexOf(paramStartString, queryStartIndex);
        }
        if (paramStartIndex == -1) {
            return newUrl;
        }
        int paramEndIndex = url.indexOf("&", paramStartIndex + 1) - 1;
        if (paramEndIndex == -1 && (paramEndIndex = url.indexOf("#", paramStartIndex)) == -1) {
            paramEndIndex = url.length() - 1;
        }
        String parameterString = url.substring(paramStartIndex, paramEndIndex + 1);
        newUrl = url.replace(parameterString, "");
        newUrl = this.removeQueryParameter(newUrl, paramToRemove);
        return newUrl;
    }

    @JavascriptInterface
    public void onJsInitDataAvailable(String dataJsonString) {
        this.onJsInitDataAvailableCalled = true;
        for (int i = 0; i < this.jsInitDataObservers.size(); ++i) {
            this.jsInitDataObservers.get(i).onData(dataJsonString);
        }
    }

    public void addJsInitDataObserver(JsInitDataObserver jsInitDataObserver) {
        if (this.onJsInitDataAvailableCalled) {
            String errorMsg = "InjectedObject | addJsInitDataObserver | Not adding JsInitDataObserver. JS Init event already happened.";
            Logger.e(TAG, errorMsg);
            IVLogger.log(errorMsg);
            return;
        }
        this.jsInitDataObservers.add(jsInitDataObserver);
    }

    @JavascriptInterface
    public void carouselTouchStart() {
        WebView webView;
        if (this.mWebViewManager != null && (webView = this.mWebViewManager.getWebView()) instanceof TaboolaWebView) {
            ((TaboolaWebView)webView).carouselTouchStart();
        }
    }

    private void addCallbackOnEvent(String jsEventCode, String nativeCallback) {
        this.addCallbackOnEvent(jsEventCode, nativeCallback, false);
    }

    private void addJsCallbacks(String ... callbackEvents) {
        for (String callbackEvent : callbackEvents) {
            this.addCallbackOnEvent(callbackEvent, callbackEvent);
        }
    }

    private void addCallbackOnEvent(final String jsEventCode, final String nativeCallback, final boolean callbackHasArgument) {
        if (this.mWebViewManager != null) {
            this.mMainHandler.post(new Runnable(){

                @Override
                public void run() {
                    String optionalArg = callbackHasArgument ? "a" : "";
                    String jsRegisterString = String.format("taboolaBridge.on(\"%s\",  function(%s){ taboolaNative.%s(%s) })", jsEventCode, optionalArg, nativeCallback, optionalArg);
                    Logger.d(TAG, "addCallbackOnEvent | jsRegisterString = " + jsRegisterString);
                    InjectedObject.this.mWebViewManager.callJsFunction(jsRegisterString);
                }
            });
        }
    }

    @JavascriptInterface
    public void reportAction(int actionType, String dataJsonString) {
        this.mWebViewManager.reportUserAction(actionType, dataJsonString);
    }

    @JavascriptInterface
    public void updateContentComplete() {
        this.mWebViewManager.updateContentCompleted();
    }
}

