/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.global_components.configuration;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.internal.LinkedTreeMap;
import com.google.gson.reflect.TypeToken;
import com.taboola.android.global_components.TaboolaContextManager;
import com.taboola.android.global_components.configuration.ConfigError;
import com.taboola.android.global_components.configuration.TaboolaConfigResponse;
import com.taboola.android.global_components.network.NetworkManager;
import com.taboola.android.utils.Logger;
import com.taboola.android.utils.SharedPrefUtil;
import com.taboola.lightnetwork.protocols.http.HttpError;
import com.taboola.lightnetwork.protocols.http.HttpManager;
import com.taboola.lightnetwork.protocols.http.HttpResponse;
import java.lang.reflect.Type;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class ConfigManager {
    public static final String PUBLISHER = "publisher";
    public static final String KILL_SWITCH_ERROR_MESSAGE = "INTERNAL_1";
    public static final String TABOOLA_CONFIG = "taboolaConfig";
    public static final String KILL_SWITCH_KEY = "killSwitch";
    private static final String TAG = "ConfigManager";
    private static final String PLACEMENT_DEFAULT_KEY = "placementDefault";
    private static final String PLACEMENT_UNKNOWN_KEY = "placementUnknown";
    private static final String CONFIGURATION_URL_PATTERN = "https://cdn.taboola.com/mobile-config/%s/confV1_0/taboolaConfig.json";
    private NetworkManager mNetworkManager;
    private Context mApplicationContext = TaboolaContextManager.getInstance().getApplicationContext();
    private LinkedTreeMap mCachedResponse;

    public ConfigManager(NetworkManager networkManager, TaboolaConfigResponse callback) {
        this.mNetworkManager = networkManager;
        this.getConfigFromRemote(callback);
    }

    public boolean loadConfig() {
        if (this.mCachedResponse == null) {
            String config = SharedPrefUtil.getConfig(this.mApplicationContext);
            if (TextUtils.isEmpty((CharSequence)config)) {
                Logger.e(TAG, "Cached configuration is empty");
                return false;
            }
            this.mCachedResponse = this.parseJson(config);
        }
        return this.mCachedResponse != null;
    }

    public void setConfigDataFromRemoteWithPublisher(String publisher) {
        String lastKnownPublisherId = SharedPrefUtil.getConfigPublisherId(this.mApplicationContext);
        if (TextUtils.isEmpty((CharSequence)lastKnownPublisherId)) {
            lastKnownPublisherId = "";
        }
        if (!TextUtils.isEmpty((CharSequence)publisher) && !publisher.equals(lastKnownPublisherId)) {
            SharedPrefUtil.setConfigPublisherId(this.mApplicationContext, publisher);
            this.getConfigFromRemote();
        }
    }

    private void getConfigFromRemote() {
        this.getConfigFromRemote(null);
    }

    private void getConfigFromRemote(final TaboolaConfigResponse callback) {
        String configUrl;
        String publisher = SharedPrefUtil.getConfigPublisherId(this.mApplicationContext);
        if (TextUtils.isEmpty((CharSequence)publisher)) {
            Logger.d(TAG, "getConfigFromRemote | publisher is N/A. Will not fetch configuration.");
            return;
        }
        HttpManager httpManager = this.mNetworkManager.getHttpManager();
        Log.d((String)TAG, (String)("getConfigFromRemote | publisher = " + publisher));
        try {
            configUrl = this.createConfigurationUrl(publisher);
        }
        catch (Exception e) {
            if (callback != null) {
                callback.onFail(new ConfigError(e.getMessage()));
            }
            return;
        }
        Log.d((String)TAG, (String)("getConfigFromRemote: " + configUrl));
        httpManager.get(configUrl, new HttpManager.NetworkResponse(){

            @Override
            public void onResponse(HttpResponse response) {
                try {
                    new JSONObject(response.mMessage);
                }
                catch (JSONException e) {
                    ConfigManager.this.saveConfig("");
                    callback.onFail(new ConfigError(e.getMessage()));
                    return;
                }
                ConfigManager.this.saveConfig(response.mMessage);
                if (callback != null) {
                    callback.onSuccess(response);
                }
            }

            @Override
            public void onError(HttpError error) {
                if (callback != null) {
                    callback.onFail(new ConfigError(error.mMessage));
                }
            }
        });
    }

    private String createConfigurationUrl(String publisher) throws Exception {
        try {
            if (TextUtils.isEmpty((CharSequence)publisher)) {
                throw new Exception("Unable to create configuration URL");
            }
            return String.format(CONFIGURATION_URL_PATTERN, publisher);
        }
        catch (Exception e) {
            throw new Exception("Unable to create configuration URL");
        }
    }

    private void saveConfig(String config) {
        Logger.d(TAG, config);
        SharedPrefUtil.saveConfig(this.mApplicationContext, config);
    }

    private LinkedTreeMap parseJson(String config) {
        try {
            Gson gson = new Gson();
            Type configMapType = new TypeToken<Map<String, Object>>(){}.getType();
            Map configMap = (Map)gson.fromJson(config, configMapType);
            return (LinkedTreeMap)configMap.get(TABOOLA_CONFIG);
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean getConfigValue(String placement, String key, boolean defaultValue) {
        String configValue = this.getConfigValue(placement, key, String.valueOf(defaultValue));
        return Boolean.parseBoolean(configValue);
    }

    public String getConfigValue(String key, String defaultValue) {
        return this.getConfigValue(null, key, defaultValue);
    }

    public boolean getConfigValue(String key, boolean defaultValue) {
        return this.getConfigValue(null, key, defaultValue);
    }

    public String getConfigValue(String placement, String key, String defaultValue) {
        if (this.mCachedResponse != null) {
            Object placementKeyValueObject;
            LinkedTreeMap placementTreeMap = null;
            if (placement != null) {
                placementTreeMap = (LinkedTreeMap)this.mCachedResponse.get((Object)placement);
            }
            if (placementTreeMap != null && (placementKeyValueObject = placementTreeMap.get((Object)key)) instanceof String) {
                return (String)placementKeyValueObject;
            }
            LinkedTreeMap defaultTreeMap = (LinkedTreeMap)this.mCachedResponse.get((Object)PLACEMENT_DEFAULT_KEY);
            if (defaultTreeMap != null) {
                Object returnValue = defaultTreeMap.get((Object)key);
                if (returnValue instanceof String) {
                    return (String)returnValue;
                }
                return defaultValue;
            }
        }
        return defaultValue;
    }

    public void set(String key, String value) {
        this.set(null, key, value);
    }

    public void set(String key, boolean value) {
        this.set(key, String.valueOf(value));
    }

    public void set(String placement, String key, boolean value) {
        this.set(placement, key, String.valueOf(value));
    }

    public void set(String placement, String key, String value) {
        if (this.mCachedResponse == null) {
            this.mCachedResponse = new LinkedTreeMap();
        }
        if (!TextUtils.isEmpty((CharSequence)placement)) {
            LinkedTreeMap placementMap = (LinkedTreeMap)this.mCachedResponse.get((Object)placement);
            if (placementMap == null) {
                placementMap = new LinkedTreeMap();
            }
            placementMap.put((Object)key, (Object)value);
            this.mCachedResponse.put((Object)placement, (Object)placementMap);
        } else {
            LinkedTreeMap placementUnknown = (LinkedTreeMap)this.mCachedResponse.get((Object)PLACEMENT_UNKNOWN_KEY);
            if (placementUnknown == null) {
                placementUnknown = new LinkedTreeMap();
            }
            placementUnknown.put((Object)key, (Object)value);
            this.mCachedResponse.put((Object)PLACEMENT_UNKNOWN_KEY, (Object)placementUnknown);
        }
    }

    public String getConfigurationAsJsonString() {
        if (this.mCachedResponse == null) {
            return null;
        }
        try {
            Gson gson = new Gson();
            JsonObject asJsonObject = gson.toJsonTree((Object)this.mCachedResponse).getAsJsonObject();
            return String.valueOf(asJsonObject);
        }
        catch (Exception e) {
            Logger.e(TAG, "getConfigurationAsJsonString | " + e.getMessage());
            return "";
        }
    }
}

