/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android;

import android.content.Context;
import android.support.annotation.NonNull;
import android.util.Log;
import com.taboola.android.INTEGRATION_TYPE;
import com.taboola.android.ITaboolaImpl;
import com.taboola.android.TaboolaInterfaceComponent;
import com.taboola.android.TaboolaWidget;
import com.taboola.android.api.TaboolaApi;
import com.taboola.android.global_components.configuration.ConfigError;
import com.taboola.android.global_components.configuration.ConfigManager;
import com.taboola.android.global_components.configuration.TaboolaConfigResponse;
import com.taboola.android.global_components.gueh.GlobalUncaughtExceptionHandler;
import com.taboola.android.global_components.gueh.TaboolaExceptionHandler;
import com.taboola.android.global_components.network.NetworkManager;
import com.taboola.android.integration_verifier.IntegrationVerifier;
import com.taboola.android.js.TaboolaJs;
import com.taboola.android.utils.ExtraProperty;
import com.taboola.android.utils.IntegrationVerifierUtils;
import com.taboola.android.utils.Logger;
import com.taboola.lightnetwork.protocols.http.HttpResponse;
import java.util.Map;

class TaboolaImpl
implements ITaboolaImpl {
    private static final String TAG = TaboolaImpl.class.getSimpleName();
    private NetworkManager mNetworkManager;
    private GlobalUncaughtExceptionHandler mGlobalExceptionHandler;
    private IntegrationVerifier mIntegrationVerifier;
    private Context mContext;
    private ConfigManager mConfigManager;

    TaboolaImpl() {
        Logger.d(TAG, "TaboolaImpl constructed.");
    }

    @Override
    public void internalGlobalInit(Context context) {
        Log.d((String)TAG, (String)"TaboolaImpl | init called..");
        this.mContext = context;
        this.mNetworkManager = new NetworkManager(context);
        this.mIntegrationVerifier = new IntegrationVerifier(this.mNetworkManager);
        this.mGlobalExceptionHandler = new GlobalUncaughtExceptionHandler(this.mNetworkManager, this.mContext);
        this.mGlobalExceptionHandler.start();
        this.mConfigManager = new ConfigManager(this.mNetworkManager, new TaboolaConfigResponse(){

            @Override
            public void onSuccess(HttpResponse response) {
                TaboolaImpl.this.mConfigManager.loadConfig();
                boolean useGUEH = TaboolaImpl.this.mConfigManager.getConfigValue("useGUEH", true);
                Log.d((String)TAG, (String)("TaboolaImpl | internalGlobalInit | TaboolaConfigResponse | useGueh = " + useGUEH));
                TaboolaImpl.this.setupGUEH(useGUEH);
            }

            @Override
            public void onFail(ConfigError error) {
                Logger.d(TAG, "TaboolaImpl | internalGlobalInit | TaboolaConfigResponse error: " + error);
            }
        });
    }

    @Override
    public int getImplementationId() {
        return 0;
    }

    @Override
    public TaboolaInterfaceComponent getComponent(@INTEGRATION_TYPE int integrationType) {
        switch (integrationType) {
            case 1: {
                return new TaboolaWidget(this.mContext);
            }
            case 2: {
                return TaboolaJs.getInstance();
            }
            case 3: {
                return TaboolaApi.getInstance();
            }
        }
        throw new RuntimeException("Must be of type extending TaboolaInterfaceComponent.");
    }

    @Override
    public void registerTaboolaExceptionHandler(TaboolaExceptionHandler taboolaExceptionHandler) {
        if (this.mGlobalExceptionHandler != null) {
            this.mGlobalExceptionHandler.registerExceptionHandler(taboolaExceptionHandler);
        } else {
            Logger.d(TAG, "registerTaboolaExceptionHandler | not registering handler, mGlobalExceptionHandler is null.");
        }
    }

    @Override
    public void setExtraProperties(@NonNull Map<String, String> extraProperties) {
        IntegrationVerifierUtils.verifyExtraProperties(this.mIntegrationVerifier, 0, extraProperties);
        for (String key : extraProperties.keySet()) {
            String value = extraProperties.get(key);
            ExtraProperty extraProperty = ExtraProperty.getExtraProperty(key);
            switch (extraProperty) {
                case SET_GUEH: {
                    this.setupGUEH(Boolean.parseBoolean(value));
                }
            }
        }
    }

    private void setupGUEH(boolean enableGUEH) {
        if (this.mGlobalExceptionHandler == null) {
            Logger.e(TAG, "Trying to enable/disable GUEH before initialization. mGlobalExceptionHandler = null.");
            return;
        }
        if (enableGUEH) {
            this.mGlobalExceptionHandler.start();
        } else {
            this.mGlobalExceptionHandler.stop();
        }
    }

    @Override
    public void verifyIntegration(boolean stopOnMandatoryFail) {
        this.mIntegrationVerifier.verifyIntegration(this.mContext, stopOnMandatoryFail);
    }

    @Override
    public NetworkManager getNetworkManager() {
        return this.mNetworkManager;
    }

    @Override
    public IntegrationVerifier getIntegrationVerifier() {
        return this.mIntegrationVerifier;
    }

    @Override
    public ConfigManager loadAndGetConfigManager() {
        this.mConfigManager.loadConfig();
        return this.mConfigManager;
    }

    @Override
    public boolean isKillSwitchEnabled(String placement) {
        if (this.mConfigManager != null) {
            return this.mConfigManager.getConfigValue(placement, "killSwitch", false);
        }
        return false;
    }
}

