/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.global_components.network.http;

import android.os.Looper;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.taboola.android.global_components.network.http.HeadersManager;
import com.taboola.android.global_components.network.http.HttpManager;
import com.taboola.android.utils.Logger;
import com.taboola.android.utils.StringUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import javax.net.ssl.HttpsURLConnection;

abstract class HttpRequest {
    private static final String TAG = HttpRequest.class.getSimpleName();
    private static final String HEADER_FIELD_LOCATION = "Location";
    private int mConfiguredTimeout;
    private HeadersManager mHeadersManager;
    String mTrackHeaders;
    String mUrl;

    public HttpRequest(int configuredTimeout, HeadersManager headersManager) {
        this.mConfiguredTimeout = configuredTimeout;
        this.mHeadersManager = headersManager;
    }

    void performRequsetOnBackgroundThread(final @Nullable HttpManager.NetworkResponse networkResponse) {
        if (Looper.myLooper() == Looper.getMainLooper()) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    HttpRequest.this.performRequest(networkResponse);
                }
            }).start();
        } else {
            this.performRequest(networkResponse);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performRequest(@Nullable HttpManager.NetworkResponse networkResponse) {
        HttpURLConnection connection = null;
        try {
            if (this.mUrl.toLowerCase().contains("https://")) {
                connection = (HttpsURLConnection)new URL(this.mUrl).openConnection();
            } else if (this.mUrl.toLowerCase().contains("http://")) {
                connection = (HttpURLConnection)new URL(this.mUrl).openConnection();
            } else {
                if (networkResponse != null) {
                    networkResponse.onError("url must begin with http:// or https://");
                }
                return;
            }
            this.applyHeadersToRequest(connection);
            connection.setConnectTimeout(this.mConfiguredTimeout);
            connection.setReadTimeout(this.mConfiguredTimeout);
            this.adjustUserAgent(connection);
            this.protocolSpecificConnectionSetup(connection);
            connection.connect();
            this.handleResponse(networkResponse, connection);
        }
        catch (NullPointerException e) {
            Logger.e(TAG, "performRequest error: " + e.getLocalizedMessage());
            if (networkResponse != null) {
                networkResponse.onError("NullPointerException: " + e.getLocalizedMessage());
            }
        }
        catch (MalformedURLException e) {
            Logger.e(TAG, "performRequest error: " + e.getLocalizedMessage());
            if (networkResponse != null) {
                networkResponse.onError("MalformedURLException: " + e.getLocalizedMessage());
            }
        }
        catch (IOException e) {
            Logger.e(TAG, "performRequest error: " + e.getLocalizedMessage());
            if (networkResponse != null) {
                networkResponse.onError("IOException: " + e.getLocalizedMessage());
            }
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    protected void applyHeadersToRequest(HttpURLConnection connection) {
        if (this.mTrackHeaders != null) {
            this.mHeadersManager.setHeadersInRequest(connection, this.mTrackHeaders);
        }
    }

    private void adjustUserAgent(HttpURLConnection connection) {
        String HTTP_AGENT = "http.agent";
        String USER_AGENT_PROPERTY = "User-Agent";
        String userAgent = System.getProperty("http.agent");
        if (!TextUtils.isEmpty((CharSequence)userAgent)) {
            userAgent = StringUtil.removeNonAscii(userAgent);
            connection.setRequestProperty("User-Agent", userAgent);
        }
    }

    abstract void protocolSpecificConnectionSetup(HttpURLConnection var1) throws IOException;

    private void handleResponse(@Nullable HttpManager.NetworkResponse networkResponse, HttpURLConnection connection) throws IOException {
        int status = connection.getResponseCode();
        if (status >= 200 && status < 300) {
            this.handleResponseOK(networkResponse, connection);
        } else if (status == 301 || status == 302 || status == 303) {
            this.handleResponseRedirect(networkResponse, connection);
        } else {
            Logger.v(TAG, "HttpRequest | handleResponse | error, response code = " + status);
            if (networkResponse != null) {
                networkResponse.onError("Invalid response code: " + status);
            }
        }
    }

    private void handleResponseOK(@Nullable HttpManager.NetworkResponse networkResponse, HttpURLConnection connection) throws IOException {
        String line;
        if (this.mTrackHeaders != null) {
            this.mHeadersManager.getHeadersFromResponse(connection, this.mTrackHeaders);
        }
        BufferedReader br = new BufferedReader(new InputStreamReader(connection.getInputStream()));
        StringBuilder response = new StringBuilder();
        while ((line = br.readLine()) != null) {
            response.append(line).append("\n");
        }
        br.close();
        if (networkResponse != null) {
            networkResponse.onResponse(response.toString());
        }
    }

    private void handleResponseRedirect(@Nullable HttpManager.NetworkResponse networkResponse, HttpURLConnection connection) {
        this.mUrl = connection.getHeaderField(HEADER_FIELD_LOCATION);
        Logger.v(TAG, "HttpRequest | handleResponse | redirect, url = " + this.mUrl);
        this.performRequest(networkResponse);
    }
}

