/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.global_components.gueh;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.support.v4.util.Pair;
import android.text.TextUtils;
import com.taboola.android.global_components.gueh.TaboolaExceptionHandler;
import com.taboola.android.global_components.network.NetworkManager;
import com.taboola.android.global_components.network.handlers.KustoHandler;
import com.taboola.android.global_components.network.http.HttpManager;
import com.taboola.android.global_components.network.requests.kibana.GlobalExceptionKibanaReport;
import com.taboola.android.global_components.network.requests.kusto.GlobalExceptionKustoReport;
import com.taboola.android.utils.AdvertisingIdClient;
import com.taboola.android.utils.Logger;
import com.taboola.android.utils.SharedPrefUtil;
import com.taboola.android.utils.network.KibanaUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.CountDownLatch;

public class SDKExceptionHandler
extends TaboolaExceptionHandler {
    private static final String TAG = SDKExceptionHandler.class.getSimpleName();
    private static final String TABOOLA_SDK_PKG = "com.taboola.android";
    private static final String TABOOLA_SDK_PLUS_PKG = "com.taboola.android.plus";
    private static final int REPORT_TIMEOUT = 5000;
    private final KustoHandler mKustoHandler;
    private Context mContext;
    private NetworkManager mNetworkManager;

    public SDKExceptionHandler(Context context, NetworkManager networkManager) {
        this.mContext = context;
        this.mNetworkManager = networkManager;
        this.mKustoHandler = new KustoHandler(networkManager);
    }

    @Override
    public boolean isHandling(Throwable throwable) {
        Throwable tmpThrowable = throwable;
        ArrayList<StackTraceElement> allElements = new ArrayList<StackTraceElement>(Arrays.asList(tmpThrowable.getStackTrace()));
        while (tmpThrowable.getCause() != null) {
            allElements.addAll(Arrays.asList(tmpThrowable.getCause().getStackTrace()));
            tmpThrowable = tmpThrowable.getCause();
        }
        return this.searchElementsForPackageName(allElements);
    }

    private boolean searchElementsForPackageName(ArrayList<StackTraceElement> elements) {
        for (StackTraceElement ste : elements) {
            if (!ste.getClassName().contains(TABOOLA_SDK_PKG) || ste.getClassName().contains(TABOOLA_SDK_PLUS_PKG)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void handle(Throwable throwable) {
        String exceptionMessage = throwable.getLocalizedMessage();
        Logger.e(TAG, "Exception message: " + exceptionMessage);
        this.sendExceptionToKusto(throwable);
        if (this.shouldSendCrashReportToKibana(throwable)) {
            Logger.e(TAG, "Sending exception to Kibana. Message: " + exceptionMessage);
            this.sendExceptionToKibana(throwable);
        }
    }

    private boolean shouldSendCrashReportToKibana(Throwable throwable) {
        Pair<String, String> pair = SharedPrefUtil.getLastCrashDetected(this.mContext);
        String exceptionMessage = (String)pair.first;
        String exceptionStackTrace = (String)pair.second;
        boolean thisCrashWasReported = TextUtils.equals((CharSequence)exceptionMessage, (CharSequence)throwable.getMessage()) && TextUtils.equals((CharSequence)exceptionStackTrace, (CharSequence)Arrays.toString(throwable.getStackTrace()));
        return !thisCrashWasReported;
    }

    private void sendExceptionToKibana(final Throwable throwable) {
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        this.mNetworkManager.getKibanaHandler().sendGUEHExceptionToKibana(this.buildGlobalExceptionReport(throwable), new HttpManager.NetworkResponse(){

            @Override
            public void onResponse(String response) {
                Logger.d(TAG, "sendExceptionToKibana | Exception reported, response: " + response);
                SharedPrefUtil.setLastCrashDetected(SDKExceptionHandler.this.mContext, throwable.getMessage(), Arrays.toString(throwable.getStackTrace()));
                countDownLatch.countDown();
            }

            @Override
            public void onError(String error) {
                Logger.e(TAG, "sendExceptionToKibana | Exception not reported, error: " + error);
                countDownLatch.countDown();
            }
        });
        new Handler(Looper.getMainLooper()).postDelayed(new Runnable(){

            @Override
            public void run() {
                countDownLatch.countDown();
            }
        }, 5000L);
        try {
            countDownLatch.await();
        }
        catch (InterruptedException e) {
            Logger.e(TAG, "Kibana report thread interrupted while waiting for report.");
        }
    }

    public GlobalExceptionKibanaReport buildGlobalExceptionReport(Throwable throwable) {
        String packageName = this.mContext.getPackageName();
        String exception = throwable.getLocalizedMessage();
        String sdkVer = "2.2.4-45051-11";
        String timeStamp = KibanaUtils.getISO8601currentTime();
        String deviceId = AdvertisingIdClient.getCachedAdvertisingId(this.mContext);
        String stackTraceString = Arrays.toString(throwable.getStackTrace());
        return new GlobalExceptionKibanaReport(packageName, exception, sdkVer, timeStamp, deviceId, stackTraceString);
    }

    private void sendExceptionToKusto(Throwable throwable) {
        Logger.e(TAG, "Sending exception sendExceptionToKusto. Message: " + throwable.getMessage());
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        GlobalExceptionKustoReport exceptionReport = new GlobalExceptionKustoReport(this.mContext, throwable);
        this.mKustoHandler.sendGUEHExceptionToKusto(exceptionReport, new HttpManager.NetworkResponse(){

            @Override
            public void onResponse(String response) {
                Logger.d(TAG, "sendExceptionToKusto | Exception reported, response: " + response);
                countDownLatch.countDown();
            }

            @Override
            public void onError(String error) {
                Logger.e(TAG, "sendExceptionToKusto | Exception not reported, error: " + error);
                countDownLatch.countDown();
            }
        });
        new Handler(Looper.getMainLooper()).postDelayed(new Runnable(){

            @Override
            public void run() {
                countDownLatch.countDown();
            }
        }, 5000L);
        try {
            countDownLatch.await();
        }
        catch (InterruptedException e) {
            Logger.e(TAG, "Kusto report thread interrupted while waiting for report.");
        }
    }
}

